/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mock;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ListenerServiceMock
extends ListenerService {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.ListenerService");
    private final Map<String, List<ListenerBase>> listeners = new ConcurrentHashMap<String, List<ListenerBase>>();

    public ListenerServiceMock(ExoContainerContext ctx) {
        super(ctx, null, null);
    }

    public void addListener(Listener listener) {
        this.addListener(listener.getName(), (ListenerBase)listener);
    }

    public synchronized void addListener(String eventName, ListenerBase listener) {
        this.listeners.computeIfAbsent(eventName, key -> new Vector()).add(listener);
    }

    public <S, D> void broadcast(String name, S source, D data) {
        List<ListenerBase> list = this.listeners.get(name);
        if (list == null) {
            return;
        }
        for (ListenerBase listener : list) {
            try {
                listener.onEvent(new Event(name, source, data));
            }
            catch (Exception e) {
                LOG.error("Exception while broadcasting event with name {}", new Object[]{name, e});
            }
        }
    }

    public <T extends Event> void broadcast(T event) {
        List<ListenerBase> list = this.listeners.get(event.getEventName());
        if (list == null) {
            return;
        }
        for (ListenerBase listener : list) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                LOG.error("Exception while broadcasting event {}: ", new Object[]{event, e});
            }
        }
    }
}

