/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.security.service;

import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.model.RegistrationSetting;
import io.meeds.portal.security.service.SecuritySettingService;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.listener.ListenerService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SecuritySettingServiceTest {
    @Mock
    private SettingService settingService;
    @Mock
    private ListenerService listenerService;
    private SecuritySettingService securitySettingService;

    @Before
    public void setUp() {
        this.securitySettingService = new SecuritySettingService(this.settingService, this.listenerService);
    }

    @Test
    public void testGetRegistrationSetting() {
        RegistrationSetting registrationSetting = this.securitySettingService.getRegistrationSetting();
        Assert.assertNotNull((Object)registrationSetting);
        Assert.assertEquals((Object)SecuritySettingService.DEFAULT_REGISTRATION_TYPE, (Object)registrationSetting.getType());
        Assert.assertEquals((Object)SecuritySettingService.DEFAULT_REGISTRATION_EXTERNAL_USER, (Object)registrationSetting.isExternalUser());
        Assert.assertNotNull((Object)registrationSetting.getExtraGroupIds());
        Assert.assertEquals((long)0L, (long)registrationSetting.getExtraGroupIds().length);
    }

    @Test
    public void testSaveRegistrationSetting() {
        this.securitySettingService.saveRegistrationSetting(new RegistrationSetting());
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_CONTEXT), (Scope)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_SCOPE), ArgumentMatchers.anyString(), (SettingValue)ArgumentMatchers.any());
    }

    @Test
    public void testSaveRegistrationSettingWithNoDefault() {
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_TYPE")).thenReturn((Object)SettingValue.create((String)UserRegistrationType.RESTRICTED.name()));
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_EXTERNAL_USER")).thenReturn((Object)SettingValue.create((Boolean)true));
        this.securitySettingService.saveRegistrationSetting(new RegistrationSetting());
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)3))).set((Context)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_CONTEXT), (Scope)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_SCOPE), ArgumentMatchers.anyString(), (SettingValue)ArgumentMatchers.any());
    }

    @Test
    public void testGetRegistrationType() {
        UserRegistrationType registrationType = this.securitySettingService.getRegistrationType();
        Assert.assertNotNull((Object)registrationType);
        Assert.assertEquals((Object)SecuritySettingService.DEFAULT_REGISTRATION_TYPE, (Object)registrationType);
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_TYPE")).thenReturn((Object)SettingValue.create((String)UserRegistrationType.OPEN.name()));
        registrationType = this.securitySettingService.getRegistrationType();
        Assert.assertNotNull((Object)registrationType);
        Assert.assertEquals((Object)UserRegistrationType.OPEN, (Object)registrationType);
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_TYPE")).thenReturn((Object)SettingValue.create((String)UserRegistrationType.RESTRICTED.name()));
        registrationType = this.securitySettingService.getRegistrationType();
        Assert.assertNotNull((Object)registrationType);
        Assert.assertEquals((Object)UserRegistrationType.RESTRICTED, (Object)registrationType);
    }

    @Test
    public void testSaveRegistrationType() throws Exception {
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_TYPE")).thenReturn((Object)SettingValue.create((String)UserRegistrationType.RESTRICTED.name()));
        this.securitySettingService.saveRegistrationType(UserRegistrationType.OPEN);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_CONTEXT), (Scope)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_SCOPE), (String)ArgumentMatchers.eq((Object)"REGISTRATION_TYPE"), (SettingValue)ArgumentMatchers.argThat(args -> StringUtils.equals((CharSequence)args.getValue().toString(), (CharSequence)UserRegistrationType.OPEN.name())));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("meeds.settings.access.type.modified", null, (Object)UserRegistrationType.OPEN);
        this.securitySettingService.saveRegistrationType(UserRegistrationType.RESTRICTED);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.never())).set((Context)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_CONTEXT), (Scope)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_SCOPE), (String)ArgumentMatchers.eq((Object)"REGISTRATION_TYPE"), (SettingValue)ArgumentMatchers.argThat(args -> StringUtils.equals((CharSequence)args.getValue().toString(), (CharSequence)UserRegistrationType.RESTRICTED.name())));
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_TYPE")).thenReturn((Object)SettingValue.create((String)UserRegistrationType.OPEN.name()));
        this.securitySettingService.saveRegistrationType(UserRegistrationType.RESTRICTED);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_CONTEXT), (Scope)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_SCOPE), (String)ArgumentMatchers.eq((Object)"REGISTRATION_TYPE"), (SettingValue)ArgumentMatchers.argThat(args -> StringUtils.equals((CharSequence)args.getValue().toString(), (CharSequence)UserRegistrationType.RESTRICTED.name())));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("meeds.settings.access.type.modified", null, (Object)UserRegistrationType.RESTRICTED);
    }

    @Test
    public void testIsRegistrationExternalUser() {
        Assert.assertEquals((Object)SecuritySettingService.DEFAULT_REGISTRATION_EXTERNAL_USER, (Object)this.securitySettingService.isRegistrationExternalUser());
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_EXTERNAL_USER")).thenReturn((Object)SettingValue.create((Boolean)true));
        Assert.assertTrue((boolean)this.securitySettingService.isRegistrationExternalUser());
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_EXTERNAL_USER")).thenReturn((Object)SettingValue.create((Boolean)false));
        Assert.assertFalse((boolean)this.securitySettingService.isRegistrationExternalUser());
    }

    @Test
    public void testSaveRegistrationExternalUser() throws Exception {
        this.securitySettingService.saveRegistrationExternalUser(true);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_CONTEXT), (Scope)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_SCOPE), (String)ArgumentMatchers.eq((Object)"REGISTRATION_EXTERNAL_USER"), (SettingValue)ArgumentMatchers.argThat(args -> StringUtils.equals((CharSequence)args.getValue().toString(), (CharSequence)"true")));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("meeds.settings.access.externalUsers.modified", null, (Object)true);
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_EXTERNAL_USER")).thenReturn((Object)SettingValue.create((String)"true"));
        this.securitySettingService.saveRegistrationExternalUser(false);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_CONTEXT), (Scope)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_SCOPE), (String)ArgumentMatchers.eq((Object)"REGISTRATION_EXTERNAL_USER"), (SettingValue)ArgumentMatchers.argThat(args -> StringUtils.equals((CharSequence)args.getValue().toString(), (CharSequence)"false")));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("meeds.settings.access.externalUsers.modified", null, (Object)false);
    }

    @Test
    public void testGetRegistrationGroupIds() {
        Assert.assertEquals((long)0L, (long)this.securitySettingService.getRegistrationGroupIds().length);
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_EXTRA_GROUPS")).thenReturn((Object)SettingValue.create((String)""));
        Assert.assertEquals((long)0L, (long)this.securitySettingService.getRegistrationGroupIds().length);
        Mockito.when((Object)this.settingService.get(SecuritySettingService.SECURITY_CONTEXT, SecuritySettingService.SECURITY_SCOPE, "REGISTRATION_EXTRA_GROUPS")).thenReturn((Object)SettingValue.create((String)"group1,group2"));
        String[] registrationGroupIds = this.securitySettingService.getRegistrationGroupIds();
        Assert.assertNotNull((Object)registrationGroupIds);
        Assert.assertEquals((long)2L, (long)registrationGroupIds.length);
        Assert.assertEquals((Object)"group1", (Object)registrationGroupIds[0]);
        Assert.assertEquals((Object)"group2", (Object)registrationGroupIds[1]);
    }

    @Test
    public void testSaveRegistrationGroupIds() {
        this.securitySettingService.saveRegistrationGroupIds(new String[0]);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_CONTEXT), (Scope)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_SCOPE), (String)ArgumentMatchers.eq((Object)"REGISTRATION_EXTRA_GROUPS"), (SettingValue)ArgumentMatchers.argThat(args -> StringUtils.equals((CharSequence)args.getValue().toString(), (CharSequence)"")));
        this.securitySettingService.saveRegistrationGroupIds(new String[]{"/group1", "/group2"});
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_CONTEXT), (Scope)ArgumentMatchers.eq((Object)SecuritySettingService.SECURITY_SCOPE), (String)ArgumentMatchers.eq((Object)"REGISTRATION_EXTRA_GROUPS"), (SettingValue)ArgumentMatchers.argThat(args -> StringUtils.equals((CharSequence)args.getValue().toString(), (CharSequence)"/group1,/group2")));
    }
}

