/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.DynamicPortalLayoutMatcherPlugin;
import org.exoplatform.portal.config.DynamicPortalLayoutService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class DynamicPortalLayoutServiceTest {
    private static final String EXISTING_PORTAL_SITE_NAME = "testPortal";
    private static final String NON_EXISTING_PORTAL_SITE_NAME = "testPortal2";
    private static final String EXISTING_GROUP_SITE_NAME = "testGroup";
    private static final String NON_EXISTING_GROUP_SITE_NAME = "testGroup2";
    private static final String EXISTING_USER_SITE_NAME = "testUser";
    private static final String NON_EXISTING_USER_SITE_NAME = "testUser2";

    @Test
    public void testNoLayoutMatchers() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, true, true, false);
        Assert.assertNotNull((Object)dynamicPortalLayoutService.getDynamicLayoutMatchers());
        Assert.assertEquals((long)0L, (long)dynamicPortalLayoutService.getDynamicLayoutMatchers().size());
    }

    @Test
    public void testLayoutMatchersPriority() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, true, true, false);
        DynamicPortalLayoutMatcherPlugin matcher1 = new DynamicPortalLayoutMatcherPlugin(null);
        matcher1.setName("matcher1");
        DynamicPortalLayoutMatcherPlugin matcher2 = new DynamicPortalLayoutMatcherPlugin(null);
        matcher1.setName("matcher2");
        dynamicPortalLayoutService.addDynamicLayoutMatcher(matcher1);
        dynamicPortalLayoutService.addDynamicLayoutMatcher(matcher2);
        List dynamicLayoutMatchers = dynamicPortalLayoutService.getDynamicLayoutMatchers();
        Assert.assertEquals((Object)matcher2, dynamicLayoutMatchers.get(0));
        Assert.assertEquals((Object)matcher1, dynamicLayoutMatchers.get(1));
    }

    @Test
    public void testCanNotAddNullMatcher() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, true, true, false);
        try {
            dynamicPortalLayoutService.addDynamicLayoutMatcher(null);
            Assert.fail((String)"Should throw IllegalArgumentException when injecting null plugin");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testThrowExceptionWhenGettingLayoutWithNullSiteKey() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, true, true, false);
        try {
            dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(null, EXISTING_PORTAL_SITE_NAME);
            Assert.fail((String)"Should throw IllegalArgumentException when using null siteKey");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail((String)("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout : " + e.getMessage()));
        }
    }

    @Test
    public void testWithNonExistingSiteKeyAndNullCurrentPortal() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, true, true, false);
        PortalConfig result = null;
        try {
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.portal((String)NON_EXISTING_PORTAL_SITE_NAME), null);
            Assert.assertNull((Object)result);
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.group((String)NON_EXISTING_GROUP_SITE_NAME), null);
            Assert.assertNull((Object)result);
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.user((String)NON_EXISTING_USER_SITE_NAME), null);
            Assert.assertNull((Object)result);
        }
        catch (Exception e) {
            Assert.fail((String)("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout : " + e.getMessage()));
        }
    }

    @Test
    public void testWithNonExistingSiteKeyAndExistingCurrentPortal() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, true, true, false);
        PortalConfig result = null;
        try {
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.portal((String)NON_EXISTING_PORTAL_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNull((Object)result);
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.group((String)NON_EXISTING_GROUP_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNull((Object)result);
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.user((String)NON_EXISTING_USER_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNull((Object)result);
        }
        catch (Exception e) {
            Assert.fail((String)("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout : " + e.getMessage()));
        }
    }

    @Test
    public void testWithExistingSiteKeyAndNullCurrentPortal() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, true, true, false);
        PortalConfig result = null;
        try {
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.portal((String)EXISTING_PORTAL_SITE_NAME), null);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.PORTAL.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_PORTAL_SITE_NAME, (Object)result.getName());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.group((String)EXISTING_GROUP_SITE_NAME), null);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.GROUP.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_GROUP_SITE_NAME, (Object)result.getName());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.user((String)EXISTING_USER_SITE_NAME), null);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.USER.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_USER_SITE_NAME, (Object)result.getName());
        }
        catch (Exception e) {
            Assert.fail((String)("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout : " + e.getMessage()));
        }
    }

    @Test
    public void testWithExistingSiteKeyAndNonExistingCurrentPortal() {
        PortalConfig result;
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, true, true, false);
        try {
            dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.portal((String)EXISTING_PORTAL_SITE_NAME), NON_EXISTING_PORTAL_SITE_NAME);
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Shouldnt throw IllegalStateException since siteKey exists and it's not default");
        }
        catch (Exception e) {
            Assert.fail((String)("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout : " + e.getMessage()));
        }
        try {
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.group((String)EXISTING_GROUP_SITE_NAME), NON_EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
        }
        catch (Exception e) {
            Assert.fail((String)("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout : " + e.getMessage()));
        }
        try {
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.user((String)EXISTING_USER_SITE_NAME), NON_EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
        }
        catch (Exception e) {
            Assert.fail((String)("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout : " + e.getMessage()));
        }
    }

    @Test
    public void testWithExistingSiteKeyAndExistingCurrentPortal() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, true, true, false);
        PortalConfig result = null;
        try {
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.portal((String)EXISTING_PORTAL_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.PORTAL.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_PORTAL_SITE_NAME, (Object)result.getName());
            Assert.assertFalse((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((long)3L, (long)result.getPortalLayout().getChildren().size());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.group((String)EXISTING_GROUP_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.GROUP.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_GROUP_SITE_NAME, (Object)result.getName());
            Assert.assertTrue((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((long)1L, (long)result.getPortalLayout().getChildren().size());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.user((String)EXISTING_USER_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.USER.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_USER_SITE_NAME, (Object)result.getName());
            Assert.assertTrue((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((long)1L, (long)result.getPortalLayout().getChildren().size());
        }
        catch (Exception e) {
            throw new AssertionError("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout", e);
        }
    }

    @Test
    public void testWithExistingSiteKeyAndExistingCurrentPortalAndIgnoredStoredSiteKeyLayout() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(true, true, true, false);
        PortalConfig result = null;
        try {
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.portal((String)EXISTING_PORTAL_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.PORTAL.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_PORTAL_SITE_NAME, (Object)result.getName());
            Assert.assertFalse((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((long)3L, (long)result.getPortalLayout().getChildren().size());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.group((String)EXISTING_GROUP_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.GROUP.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_GROUP_SITE_NAME, (Object)result.getName());
            Assert.assertTrue((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((long)1L, (long)result.getPortalLayout().getChildren().size());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.user((String)EXISTING_USER_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.USER.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_USER_SITE_NAME, (Object)result.getName());
            Assert.assertTrue((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((long)1L, (long)result.getPortalLayout().getChildren().size());
        }
        catch (Exception e) {
            throw new AssertionError("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout", e);
        }
    }

    @Test
    public void testUsingMatcherWithDefaultSiteLayout() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, true, true, true);
        PortalConfig result = null;
        try {
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.portal((String)EXISTING_PORTAL_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.PORTAL.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_PORTAL_SITE_NAME, (Object)result.getName());
            Assert.assertFalse((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((String)"Last PORTAL site PortalConfig layout should be returned", (long)3L, (long)result.getPortalLayout().getChildren().size());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.group((String)EXISTING_GROUP_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.GROUP.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_GROUP_SITE_NAME, (Object)result.getName());
            Assert.assertTrue((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((String)"Last PORTAL site PortalConfig layout should be returned", (long)3L, (long)result.getPortalLayout().getChildren().size());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.user((String)EXISTING_USER_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.USER.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_USER_SITE_NAME, (Object)result.getName());
            Assert.assertTrue((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((long)3L, (long)result.getPortalLayout().getChildren().size());
        }
        catch (Exception e) {
            throw new AssertionError("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout", e);
        }
    }

    @Test
    public void testUsingMatcherWithNotDefaultSiteLayout() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(false, false, true, true);
        PortalConfig result = null;
        try {
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.portal((String)EXISTING_PORTAL_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.PORTAL.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_PORTAL_SITE_NAME, (Object)result.getName());
            Assert.assertFalse((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((long)3L, (long)result.getPortalLayout().getChildren().size());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.group((String)EXISTING_GROUP_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.GROUP.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_GROUP_SITE_NAME, (Object)result.getName());
            Assert.assertFalse((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((String)"Persisted PortalConfig layout should be returned", (long)1L, (long)result.getPortalLayout().getChildren().size());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.user((String)EXISTING_USER_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.USER.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_USER_SITE_NAME, (Object)result.getName());
            Assert.assertFalse((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((String)"Persisted PortalConfig layout should be returned", (long)1L, (long)result.getPortalLayout().getChildren().size());
        }
        catch (Exception e) {
            throw new AssertionError("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout", e);
        }
    }

    @Test
    public void testUsingMatcherWithNotDefaultSiteLayoutAndForceIgnoreStoredLayout() {
        DynamicPortalLayoutService dynamicPortalLayoutService = this.mockDynamicLayoutService(true, false, true, true);
        PortalConfig result = null;
        try {
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.portal((String)EXISTING_PORTAL_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.PORTAL.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_PORTAL_SITE_NAME, (Object)result.getName());
            Assert.assertFalse((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((long)3L, (long)result.getPortalLayout().getChildren().size());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.group((String)EXISTING_GROUP_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.GROUP.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_GROUP_SITE_NAME, (Object)result.getName());
            Assert.assertFalse((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((String)"Last PORTAL site PortalConfig layout should be returned", (long)3L, (long)result.getPortalLayout().getChildren().size());
            result = dynamicPortalLayoutService.getPortalConfigWithDynamicLayout(SiteKey.user((String)EXISTING_USER_SITE_NAME), EXISTING_PORTAL_SITE_NAME);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)SiteType.USER.getName(), (Object)result.getType());
            Assert.assertEquals((Object)EXISTING_USER_SITE_NAME, (Object)result.getName());
            Assert.assertFalse((boolean)result.isDefaultLayout());
            Assert.assertNotNull((Object)result.getPortalLayout());
            Assert.assertEquals((String)"Last PORTAL site PortalConfig layout should be returned", (long)3L, (long)result.getPortalLayout().getChildren().size());
        }
        catch (Exception e) {
            throw new AssertionError("Unhandled error occurs when invoking getPortalConfigWithDynamicLayout", e);
        }
    }

    private DynamicPortalLayoutService mockDynamicLayoutService(boolean forceIgnoreStoredLayout, boolean markPortalConfigAsDefault, boolean startService, boolean addMatcher) {
        try {
            InitParams params = new InitParams();
            ValueParam ignoreStoredLayoutParam = new ValueParam();
            ignoreStoredLayoutParam.setName("forceIgnoreStoredLayout");
            ignoreStoredLayoutParam.setValue(String.valueOf(forceIgnoreStoredLayout));
            params.addParameter((Parameter)ignoreStoredLayoutParam);
            ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
            LayoutService dataStorage = (LayoutService)Mockito.mock(LayoutService.class);
            PortalConfig portalPortalConfig = new PortalConfig(SiteType.PORTAL.getName(), EXISTING_PORTAL_SITE_NAME);
            Container portalLayout = new Container();
            ArrayList<Object> children = new ArrayList<Object>();
            children.add(new Container());
            children.add(new PageBody());
            children.add(new Container());
            portalLayout.setChildren(children);
            portalPortalConfig.setPortalLayout(portalLayout);
            Mockito.when((Object)dataStorage.getPortalConfig((String)ArgumentMatchers.eq((Object)SiteType.PORTAL.getName()), (String)ArgumentMatchers.eq((Object)EXISTING_PORTAL_SITE_NAME))).thenReturn((Object)portalPortalConfig);
            PortalConfig groupPortalConfig = new PortalConfig(SiteType.GROUP.getName(), EXISTING_GROUP_SITE_NAME);
            groupPortalConfig.useMetaPortalLayout();
            groupPortalConfig.setDefaultLayout(markPortalConfigAsDefault);
            Mockito.when((Object)dataStorage.getPortalConfig((String)ArgumentMatchers.eq((Object)SiteType.GROUP.getName()), (String)ArgumentMatchers.eq((Object)EXISTING_GROUP_SITE_NAME))).thenReturn((Object)groupPortalConfig);
            PortalConfig userPortalConfig = new PortalConfig(SiteType.USER.getName(), EXISTING_USER_SITE_NAME);
            userPortalConfig.useMetaPortalLayout();
            userPortalConfig.setDefaultLayout(markPortalConfigAsDefault);
            Mockito.when((Object)dataStorage.getPortalConfig((String)ArgumentMatchers.eq((Object)SiteType.USER.getName()), (String)ArgumentMatchers.eq((Object)EXISTING_USER_SITE_NAME))).thenReturn((Object)userPortalConfig);
            DynamicPortalLayoutService dynamicPortalLayoutService = new DynamicPortalLayoutService(configurationManager, dataStorage, params);
            if (addMatcher) {
                DynamicPortalLayoutMatcherPlugin dynamicPortalLayoutMatcherPlugin = (DynamicPortalLayoutMatcherPlugin)Mockito.mock(DynamicPortalLayoutMatcherPlugin.class);
                PortalConfig dynamicGroupPortalConfig = groupPortalConfig.clone();
                dynamicGroupPortalConfig.setPortalLayout(portalLayout.clone());
                PortalConfig dynamicUserPortalConfig = userPortalConfig.clone();
                dynamicUserPortalConfig.setPortalLayout(portalLayout.clone());
                Mockito.when((Object)dynamicPortalLayoutMatcherPlugin.getPortalConfigWithDynamicLayout((SiteKey)ArgumentMatchers.eq((Object)SiteKey.group((String)EXISTING_GROUP_SITE_NAME)), (PortalConfig)ArgumentMatchers.eq((Object)groupPortalConfig), (PortalConfig)ArgumentMatchers.eq((Object)portalPortalConfig))).thenReturn((Object)dynamicGroupPortalConfig);
                Mockito.when((Object)dynamicPortalLayoutMatcherPlugin.getPortalConfigWithDynamicLayout((SiteKey)ArgumentMatchers.eq((Object)SiteKey.user((String)EXISTING_USER_SITE_NAME)), (PortalConfig)ArgumentMatchers.eq((Object)userPortalConfig), (PortalConfig)ArgumentMatchers.eq((Object)portalPortalConfig))).thenReturn((Object)dynamicUserPortalConfig);
                dynamicPortalLayoutService.addDynamicLayoutMatcher(dynamicPortalLayoutMatcherPlugin);
            }
            if (startService) {
                dynamicPortalLayoutService.start();
            }
            return dynamicPortalLayoutService;
        }
        catch (Exception e) {
            throw new AssertionError("Unknown error occurred while preparing mocks", e);
        }
    }
}

