/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.Node;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.SiteStorage;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.PortalData;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/test.navigation.configuration.xml")})
public class TestJDBCNavigationService
extends AbstractKernelTest {
    protected NavigationService service;
    private SiteStorage modelStorage;

    protected void setUp() throws Exception {
        super.setUp();
        PortalContainer container = PortalContainer.getInstance();
        this.service = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.modelStorage = (SiteStorage)container.getComponentInstanceOfType(SiteStorage.class);
        this.begin();
    }

    protected void createSite(SiteType type, String siteName) throws Exception {
        ContainerData container = new ContainerData(null, "testcontainer_" + siteName, "", "", "", "", "", "", "", "", "", "", null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        PortalData portal = new PortalData(null, siteName, type.getName(), null, null, null, new ArrayList(), null, null, null, container, true, 9, 0L);
        this.modelStorage.create(portal);
        NavigationContext nav = new NavigationContext(type.key(siteName), new NavigationState(Integer.valueOf(1)));
        this.service.saveNavigation(nav);
        this.restartTransaction();
    }

    public void testHiddenNode() throws Exception {
        this.createSite(SiteType.PORTAL, "hidden_node");
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"hidden_node"));
        NodeContext node = this.service.loadNode(Node.MODEL, nav, Scope.ALL, null);
        node.add(Integer.valueOf(0), "a");
        node.add(Integer.valueOf(1), "b");
        node.add(Integer.valueOf(2), "c");
        this.service.saveNode(node, null);
        this.restartTransaction();
        nav = this.service.loadNavigation(SiteKey.portal((String)"hidden_node"));
        Node root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.GRANDCHILDREN, null).getNode();
        Node a = root.getChild("a");
        Node b = root.getChild("b");
        a.setHidden(true);
        TestJDBCNavigationService.assertEquals((int)2, (int)root.getChildren().size());
        TestJDBCNavigationService.assertNull((Object)root.getChild("a"));
        TestJDBCNavigationService.assertEquals((String)"b", (String)root.getChild(0).getName());
        try {
            root.getChild(2);
            TestJDBCNavigationService.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        TestJDBCNavigationService.assertFalse((boolean)root.removeChild("a"));
        try {
            b.setName("a");
            TestJDBCNavigationService.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        a = root.getChild("a");
        b = root.getChild("b");
        Node c = root.getChild("c");
        b.setHidden(true);
        TestJDBCNavigationService.assertSame((Object)a, (Object)root.getChild(0));
        TestJDBCNavigationService.assertSame((Object)c, (Object)root.getChild(1));
        try {
            root.getChild(2);
            TestJDBCNavigationService.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        a = root.getChild("a");
        b = root.getChild("b");
        c = root.getChild("c");
        a.setHidden(true);
        c.setHidden(true);
        TestJDBCNavigationService.assertSame((Object)b, (Object)root.getChild(0));
        try {
            root.getChild(1);
            TestJDBCNavigationService.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testHiddenInsert1() throws Exception {
        this.createSite(SiteType.PORTAL, "hidden_insert_1");
        NavigationContext defaultNav = this.service.loadNavigation(SiteKey.portal((String)"hidden_insert_1"));
        NodeContext node = this.service.loadNode(Node.MODEL, defaultNav, Scope.ALL, null);
        node.add(Integer.valueOf(0), "a");
        this.service.saveNode(node, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"hidden_insert_1"));
        Node root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        Node a = root.getChild("a");
        a.setHidden(true);
        Node b = root.addChild("b");
        TestJDBCNavigationService.assertEquals((int)1, (int)root.getChildren().size());
        TestJDBCNavigationService.assertSame((Object)b, (Object)root.getChildren().iterator().next());
        a.setHidden(false);
        TestJDBCNavigationService.assertEquals((int)2, (int)root.getChildren().size());
        Iterator<Node> it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)b, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        a = root.getChild("a");
        a.setHidden(true);
        b = root.addChild(0, "b");
        TestJDBCNavigationService.assertEquals((int)1, (int)root.getChildren().size());
        TestJDBCNavigationService.assertSame((Object)b, (Object)root.getChildren().iterator().next());
        a.setHidden(false);
        TestJDBCNavigationService.assertEquals((int)2, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)b, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
    }

    public void testHiddenInsert2() throws Exception {
        this.createSite(SiteType.PORTAL, "hidden_insert_2");
        NavigationContext defaultNav = this.service.loadNavigation(SiteKey.portal((String)"hidden_insert_2"));
        NodeContext node = this.service.loadNode(Node.MODEL, defaultNav, Scope.ALL, null);
        node.add(Integer.valueOf(0), "a");
        node.add(Integer.valueOf(1), "b");
        this.service.saveNode(node, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"hidden_insert_2"));
        Node root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        Node a = root.getChild("a");
        Node b = root.getChild("b");
        b.setHidden(true);
        Node c = root.addChild(0, "c");
        TestJDBCNavigationService.assertEquals((int)2, (int)root.getChildren().size());
        Iterator<Node> it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        b.setHidden(false);
        TestJDBCNavigationService.assertEquals((int)3, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)b, (Object)it.next());
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        a = root.getChild("a");
        b = root.getChild("b");
        b.setHidden(true);
        c = root.addChild(1, "c");
        TestJDBCNavigationService.assertEquals((int)2, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        b.setHidden(false);
        TestJDBCNavigationService.assertEquals((int)3, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)b, (Object)it.next());
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        a = root.getChild("a");
        b = root.getChild("b");
        b.setHidden(true);
        c = root.addChild("c");
        TestJDBCNavigationService.assertEquals((int)2, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        b.setHidden(false);
        TestJDBCNavigationService.assertEquals((int)3, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)b, (Object)it.next());
    }

    public void testHiddenInsert3() throws Exception {
        this.createSite(SiteType.PORTAL, "hidden_insert_3");
        NavigationContext defaultNav = this.service.loadNavigation(SiteKey.portal((String)"hidden_insert_3"));
        NodeContext node = this.service.loadNode(Node.MODEL, defaultNav, Scope.ALL, null);
        node.add(Integer.valueOf(0), "a");
        node.add(Integer.valueOf(1), "b");
        node.add(Integer.valueOf(2), "c");
        this.service.saveNode(node, null);
        this.restartTransaction();
        NavigationContext nav = this.service.loadNavigation(SiteKey.portal((String)"hidden_insert_3"));
        Node root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        Node a = root.getChild("a");
        Node b = root.getChild("b");
        Node c = root.getChild("c");
        b.setHidden(true);
        Node d = root.addChild(0, "d");
        TestJDBCNavigationService.assertEquals((int)3, (int)root.getChildren().size());
        Iterator<Node> it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)d, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        b.setHidden(false);
        TestJDBCNavigationService.assertEquals((int)4, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)d, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)b, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        a = root.getChild("a");
        b = root.getChild("b");
        c = root.getChild("c");
        b.setHidden(true);
        d = root.addChild(1, "d");
        TestJDBCNavigationService.assertEquals((int)3, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)d, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        b.setHidden(false);
        TestJDBCNavigationService.assertEquals((int)4, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)d, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)b, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        a = root.getChild("a");
        b = root.getChild("b");
        c = root.getChild("c");
        b.setHidden(true);
        d = root.addChild(2, "d");
        TestJDBCNavigationService.assertEquals((int)3, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)d, (Object)it.next());
        b.setHidden(false);
        TestJDBCNavigationService.assertEquals((int)4, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)b, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)d, (Object)it.next());
        root = (Node)this.service.loadNode(Node.MODEL, nav, Scope.CHILDREN, null).getNode();
        a = root.getChild("a");
        b = root.getChild("b");
        c = root.getChild("c");
        b.setHidden(true);
        d = root.addChild("d");
        TestJDBCNavigationService.assertEquals((int)3, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)d, (Object)it.next());
        b.setHidden(false);
        TestJDBCNavigationService.assertEquals((int)4, (int)root.getChildren().size());
        it = root.getChildren().iterator();
        TestJDBCNavigationService.assertSame((Object)a, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)b, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)c, (Object)it.next());
        TestJDBCNavigationService.assertSame((Object)d, (Object)it.next());
    }

    public void testCount() throws Exception {
        this.createSite(SiteType.PORTAL, "count");
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"count"));
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.SINGLE, null).getNode();
        TestJDBCNavigationService.assertEquals((int)0, (int)root.getNodeCount());
        root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        TestJDBCNavigationService.assertEquals((int)0, (int)root.getNodeCount());
        TestJDBCNavigationService.assertEquals((int)0, (int)root.getSize());
        Node a = root.addChild("a");
        TestJDBCNavigationService.assertEquals((int)1, (int)root.getNodeCount());
        TestJDBCNavigationService.assertEquals((int)1, (int)root.getSize());
        a.setHidden(true);
        TestJDBCNavigationService.assertEquals((int)0, (int)root.getNodeCount());
        TestJDBCNavigationService.assertEquals((int)1, (int)root.getSize());
    }

    public void testInsertDuplicate() {
        try {
            this.createSite(SiteType.PORTAL, "insert_duplicate");
            NavigationContext defaultNav = this.service.loadNavigation(SiteKey.portal((String)"insert_duplicate"));
            NodeContext node = this.service.loadNode(Node.MODEL, defaultNav, Scope.ALL, null);
            node.add(Integer.valueOf(0), "a");
            this.service.saveNode(node, null);
        }
        catch (Exception ex) {
            TestJDBCNavigationService.fail((Throwable)ex);
        }
        this.restartTransaction();
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"insert_duplicate"));
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        try {
            root.addChild("a");
            TestJDBCNavigationService.fail((String)"Exception should be thrown due to the duplicate insert");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLoadNodeById() throws Exception {
        this.createSite(SiteType.PORTAL, "test_site");
        NavigationContext defaultNav = this.service.loadNavigation(SiteKey.portal((String)"test_site"));
        NodeContext rootNode = this.service.loadNode(Node.MODEL, defaultNav, Scope.ALL, null);
        rootNode.add(Integer.valueOf(0), "child1").getNode();
        rootNode.add(Integer.valueOf(1), "child2").getNode();
        this.service.saveNode(rootNode, null);
        NodeContext node = this.service.loadNodeById(Node.MODEL, rootNode.getId(), Scope.ALL, null);
        TestJDBCNavigationService.assertNotNull((Object)node.getNode());
        TestJDBCNavigationService.assertEquals((int)2, (int)((Node)node.getNode()).getChildren().size());
    }
}

