/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.security.listener;

import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.listener.PortalRegistrationUpdateListener;
import java.util.Arrays;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.listener.Event;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class PortalRegistrationUpdateListenerTest {
    private static final String NAV_NODE_ID = "1225";
    private static final String NAV_NODE_URI = "publicSiteNodeUri";
    @Mock
    private NavigationService navigationService;
    @Mock
    private InitParams params;
    @Mock
    private NodeContext<NodeContext<Object>> navNode;
    @Mock
    private NodeState navState;
    @Mock
    private NodeState.Builder navStateBuilder;
    @Mock
    private Event<Object, UserRegistrationType> event;

    @Test
    public void testUpdateRegistrationType() throws Exception {
        ValuesParam valuesParam = new ValuesParam();
        valuesParam.setValues(Arrays.asList(NAV_NODE_URI));
        Mockito.when((Object)this.params.getValuesParam("managed-pages")).thenReturn((Object)valuesParam);
        Mockito.when((Object)this.navigationService.loadNode(SiteKey.portal((String)"public"), NAV_NODE_URI)).thenReturn(this.navNode);
        Mockito.when((Object)this.navNode.getId()).thenReturn((Object)NAV_NODE_ID);
        Mockito.when((Object)this.navNode.getState()).thenReturn((Object)this.navState);
        Mockito.when((Object)this.navState.builder()).thenReturn((Object)this.navStateBuilder);
        Mockito.when((Object)this.navStateBuilder.visibility((Visibility)ArgumentMatchers.any())).thenReturn((Object)this.navStateBuilder);
        Mockito.when((Object)this.navStateBuilder.build()).thenReturn((Object)this.navState);
        PortalRegistrationUpdateListener registrationUpdateListener = new PortalRegistrationUpdateListener(this.navigationService, this.params);
        Mockito.when((Object)((UserRegistrationType)this.event.getData())).thenReturn((Object)UserRegistrationType.OPEN);
        registrationUpdateListener.onEvent(this.event);
        ((NodeState.Builder)Mockito.verify((Object)this.navStateBuilder, (VerificationMode)Mockito.times((int)1))).visibility(Visibility.DISPLAYED);
        ((NodeState.Builder)Mockito.verify((Object)this.navStateBuilder, (VerificationMode)Mockito.never())).visibility(Visibility.HIDDEN);
        ((NavigationService)Mockito.verify((Object)this.navigationService, (VerificationMode)Mockito.times((int)1))).updateNode(Long.valueOf(Long.parseLong(NAV_NODE_ID)), this.navState);
        Mockito.when((Object)((UserRegistrationType)this.event.getData())).thenReturn((Object)UserRegistrationType.RESTRICTED);
        registrationUpdateListener.onEvent(this.event);
        ((NodeState.Builder)Mockito.verify((Object)this.navStateBuilder, (VerificationMode)Mockito.times((int)1))).visibility(Visibility.HIDDEN);
        ((NavigationService)Mockito.verify((Object)this.navigationService, (VerificationMode)Mockito.times((int)2))).updateNode(Long.valueOf(Long.parseLong(NAV_NODE_ID)), this.navState);
    }
}

