/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;

public class TestXSDCorruption
extends TestCase {
    private void assertHash(String expected, String resourcePath) throws Exception {
        String hash = this.getHashOfFile(resourcePath);
        TestXSDCorruption.assertEquals((String)expected, (String)hash);
    }

    private String getHashOfFile(String resourcePath) throws IOException, NoSuchAlgorithmException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        TestXSDCorruption.assertNotNull((Object)in);
        String content = IOUtils.toString((InputStream)in);
        content = content.replaceAll("\r\n", "\n");
        MessageDigest digester = MessageDigest.getInstance("MD5");
        digester.update(content.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : digester.digest()) {
            String hex = Integer.toHexString(b);
            if (hex.length() == 1) {
                sb.append('0');
                sb.append(hex.charAt(0));
                continue;
            }
            sb.append(hex.substring(hex.length() - 2));
        }
        return sb.toString();
    }

    public void testGateInObjects1_x() throws Exception {
        this.assertHash("4d9910ede9174952cc7b6ab1724004fc", "gatein_objects_1_0.xsd");
        this.assertHash("84f12eedf716ceda613b4eaf5e53b8b7", "gatein_objects_1_1.xsd");
        this.assertHash("a1c6ff34609376a873baa2a2f5513a69", "gatein_objects_1_1_1.xsd");
        this.assertHash("52a0042722b55085bb0c61996c137699", "gatein_objects_1_2.xsd");
        this.assertHash("949559e6559207a6c5effabb9367f3d1", "gatein_objects_1_3.xsd");
        this.assertHash("f8f04d14ff2a1e1e3279b84983dac359", "gatein_objects_1_4.xsd");
        this.assertHash("be0d30a87f5aee880b69cfbdcceb16f1", "gatein_objects_1_5.xsd");
        this.assertHash("1f7067931e791863474c012f6bdbba95", "gatein_objects_1_6.xsd");
    }
}

