/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import junit.framework.TestCase;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.I18NString;
import org.exoplatform.portal.config.model.LocalizedString;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.portal.config.model.Version;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.gatein.common.util.Tools;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

public class TestJIBXXmlMapping
extends TestCase {
    public TestJIBXXmlMapping(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void testPageSetMapping() throws Exception {
        FileInputStream input = new FileInputStream("src/test/resources/org/exoplatform/portal/config/conf/portal/classic/pages.xml");
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(Page.PageSet.class, (InputStream)input);
        Page.PageSet pages = (Page.PageSet)obj.getObject();
        TestJIBXXmlMapping.assertNotNull((Object)pages);
        TestJIBXXmlMapping.assertEquals((int)3, (int)pages.getPages().size());
    }

    public void testPortalConfigMapping() throws Exception {
        FileInputStream input = new FileInputStream("src/test/resources/org/exoplatform/portal/config/conf/portal/classic/portal.xml");
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(PortalConfig.class, (InputStream)input);
        PortalConfig portalConfig = (PortalConfig)obj.getObject();
        TestJIBXXmlMapping.assertNotNull((Object)portalConfig);
        TestJIBXXmlMapping.assertEquals((String)"classic", (String)portalConfig.getName());
    }

    public void testNavigationMapping() throws Exception {
        FileInputStream input = new FileInputStream("src/test/resources/org/exoplatform/portal/config/conf/portal/classic/navigation.xml");
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(PageNavigation.class, (InputStream)input);
        PageNavigation pageNavigation = (PageNavigation)obj.getObject();
        TestJIBXXmlMapping.assertEquals((String)"portal::classic::homepage", (String)pageNavigation.getFragment().getNode("home").getPageReference());
        input = new FileInputStream("src/test/resources/org/exoplatform/portal/mop/management/navigation-empty.xml");
        obj = ModelUnmarshaller.unmarshall(PageNavigation.class, (InputStream)input);
        pageNavigation = (PageNavigation)obj.getObject();
        TestJIBXXmlMapping.assertEquals((int)-1, (int)pageNavigation.getPriority());
    }

    public void testPortletApplicationMapping() throws Exception {
        IBindingFactory bfact = BindingDirectory.getFactory(PortalConfig.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        Application app = (Application)uctx.unmarshalDocument((InputStream)new FileInputStream("src/test/resources/jibx/portlet-application.xml"), null);
        TransientApplicationState portletState = (TransientApplicationState)app.getState();
        TestJIBXXmlMapping.assertNotNull((Object)portletState);
        TestJIBXXmlMapping.assertEquals((String)"web/BannerPortlet", (String)portletState.getContentId());
        Portlet preferences = portletState.getContentState();
        TestJIBXXmlMapping.assertEquals((Object)new PortletBuilder().add("template", "template_value").build(), (Object)preferences);
    }

    public void testSimpleNavigationMapping() throws Exception {
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(PageNavigation.class, (InputStream)new FileInputStream("src/test/resources/jibx/simple-navigation.xml"));
        PageNavigation nav = (PageNavigation)obj.getObject();
        TestJIBXXmlMapping.assertEquals((Object)Version.V_1_6, (Object)obj.getVersion());
        PageNode bar = nav.getFragment().getNode("bar");
        TestJIBXXmlMapping.assertEquals((String)"bar_label", (String)bar.getLabel());
        I18NString barLabels = bar.getLabels();
        TestJIBXXmlMapping.assertNotNull((Object)barLabels);
        TestJIBXXmlMapping.assertEquals((int)1, (int)barLabels.size());
        TestJIBXXmlMapping.assertEquals((String)"bar_label", (String)((String)((LocalizedString)barLabels.get(0)).getValue()));
        TestJIBXXmlMapping.assertEquals(null, (Object)((LocalizedString)barLabels.get(0)).getLang());
        TestJIBXXmlMapping.assertEquals(null, (Object)bar.getLabels().getExtended(Locale.ENGLISH));
    }

    public void testExtendedNavigationMapping() throws Exception {
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(PageNavigation.class, (InputStream)new FileInputStream("src/test/resources/jibx/extended-navigation.xml"));
        PageNavigation nav = (PageNavigation)obj.getObject();
        TestJIBXXmlMapping.assertEquals((Object)Version.V_1_6, (Object)obj.getVersion());
        PageNode foo = nav.getFragment().getNode("foo");
        TestJIBXXmlMapping.assertEquals((String)"foo_label", (String)foo.getLabel());
        I18NString fooLabels = foo.getLabels();
        TestJIBXXmlMapping.assertNotNull((Object)fooLabels);
        TestJIBXXmlMapping.assertEquals((int)3, (int)fooLabels.size());
        TestJIBXXmlMapping.assertEquals((String)"foo_label_en", (String)((String)((LocalizedString)fooLabels.get(0)).getValue()));
        TestJIBXXmlMapping.assertEquals((Object)Locale.ENGLISH, (Object)((LocalizedString)fooLabels.get(0)).getLang());
        TestJIBXXmlMapping.assertEquals((String)"foo_label", (String)((String)((LocalizedString)fooLabels.get(1)).getValue()));
        TestJIBXXmlMapping.assertEquals(null, (Object)((LocalizedString)fooLabels.get(1)).getLang());
        TestJIBXXmlMapping.assertEquals((String)"foo_label_fr", (String)((String)((LocalizedString)fooLabels.get(2)).getValue()));
        TestJIBXXmlMapping.assertEquals((Object)Locale.FRENCH, (Object)((LocalizedString)fooLabels.get(2)).getLang());
        TestJIBXXmlMapping.assertEquals((Object)Tools.toSet((Object[])new Locale[]{Locale.ENGLISH, Locale.FRENCH}), foo.getLabels().getExtended(Locale.ENGLISH).keySet());
        TestJIBXXmlMapping.assertEquals((Object)Tools.toSet((Object[])new Locale[]{Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN}), foo.getLabels().getExtended(Locale.GERMAN).keySet());
        PageNode bar = nav.getFragment().getNode("bar");
        TestJIBXXmlMapping.assertEquals((String)"bar_label", (String)bar.getLabel());
        I18NString barLabels = bar.getLabels();
        TestJIBXXmlMapping.assertNotNull((Object)barLabels);
        TestJIBXXmlMapping.assertEquals((int)1, (int)barLabels.size());
        TestJIBXXmlMapping.assertEquals((String)"bar_label", (String)((String)((LocalizedString)barLabels.get(0)).getValue()));
        TestJIBXXmlMapping.assertEquals(null, (Object)((LocalizedString)barLabels.get(0)).getLang());
        TestJIBXXmlMapping.assertEquals(null, (Object)bar.getLabels().getExtended(Locale.ENGLISH));
        PageNode juu = nav.getFragment().getNode("juu");
        TestJIBXXmlMapping.assertEquals(null, (String)juu.getLabel());
        I18NString juuLabels = juu.getLabels();
        TestJIBXXmlMapping.assertNotNull((Object)juuLabels);
        TestJIBXXmlMapping.assertEquals((int)3, (int)juuLabels.size());
        TestJIBXXmlMapping.assertEquals((String)"juu_label_en", (String)((String)((LocalizedString)juuLabels.get(0)).getValue()));
        TestJIBXXmlMapping.assertEquals((Object)Locale.ENGLISH, (Object)((LocalizedString)juuLabels.get(0)).getLang());
        TestJIBXXmlMapping.assertEquals((String)"juu_label_fr", (String)((String)((LocalizedString)juuLabels.get(1)).getValue()));
        TestJIBXXmlMapping.assertEquals((Object)Locale.FRENCH, (Object)((LocalizedString)juuLabels.get(1)).getLang());
        TestJIBXXmlMapping.assertEquals((String)"juu_label_fr_FR", (String)((String)((LocalizedString)juuLabels.get(2)).getValue()));
        TestJIBXXmlMapping.assertEquals((Object)Locale.FRANCE, (Object)((LocalizedString)juuLabels.get(2)).getLang());
    }

    public void testNavigationFragment() throws Exception {
        UnmarshalledObject obj = ModelUnmarshaller.unmarshall(PageNavigation.class, (InputStream)new FileInputStream("src/test/resources/jibx/fragment-navigation.xml"));
        PageNavigation nav = (PageNavigation)obj.getObject();
        TestJIBXXmlMapping.assertEquals((Object)Version.V_1_6, (Object)obj.getVersion());
        ArrayList fragments = nav.getFragments();
        TestJIBXXmlMapping.assertNotNull((Object)fragments);
        TestJIBXXmlMapping.assertEquals((int)1, (int)fragments.size());
        NavigationFragment fragment = (NavigationFragment)fragments.get(0);
        TestJIBXXmlMapping.assertEquals((String)"foo", (String)fragment.getParentURI());
        TestJIBXXmlMapping.assertEquals((int)1, (int)fragment.getNodes().size());
        PageNode bar = fragment.getNode("bar");
        TestJIBXXmlMapping.assertNotNull((Object)bar);
    }
}

