/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.AbstractSiteDataImportTest;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.serialize.model.SiteLayout;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.storage.PageStorage;

public class TestSiteDataImportOverwrite
extends AbstractSiteDataImportTest {
    @Override
    protected ImportMode getMode() {
        return ImportMode.OVERWRITE;
    }

    @Override
    protected void afterOneBootWithExtention(PortalContainer container) throws Exception {
        this.begin();
        LayoutService layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
        PageStorage pageStorage = (PageStorage)container.getComponentInstanceOfType(PageStorage.class);
        PortalConfig portal = layoutService.getPortalConfig("classic");
        SiteLayout layout = portal.getPortalLayout();
        TestSiteDataImportOverwrite.assertEquals((int)1, (int)layout.getChildren().size());
        Application layoutPortlet = (Application)layout.getChildren().get(0);
        TestSiteDataImportOverwrite.assertEquals((String)"site2/layout", (String)layoutService.getId(layoutPortlet.getState()));
        PageContext page = pageStorage.loadPage(PageKey.parse((String)"portal::classic::home"));
        TestSiteDataImportOverwrite.assertNull((Object)page);
        page = pageStorage.loadPage(PageKey.parse((String)"portal::classic::page1"));
        TestSiteDataImportOverwrite.assertNotNull((Object)page);
        TestSiteDataImportOverwrite.assertEquals((String)"site 2", (String)page.getState().getDisplayName());
        page = pageStorage.loadPage(PageKey.parse((String)"portal::classic::page2"));
        TestSiteDataImportOverwrite.assertNotNull((Object)page);
        TestSiteDataImportOverwrite.assertEquals((String)"site 2", (String)page.getState().getDisplayName());
        portal = layoutService.getPortalConfig(SiteType.GROUP.getName(), "/platform/administrators");
        layout = portal.getPortalLayout();
        TestSiteDataImportOverwrite.assertEquals((int)1, (int)layout.getChildren().size());
        layoutPortlet = (Application)layout.getChildren().get(0);
        TestSiteDataImportOverwrite.assertEquals((String)"site1/layout", (String)layoutService.getId(layoutPortlet.getState()));
        page = pageStorage.loadPage(PageKey.parse((String)"group::/platform/administrators::page1"));
        TestSiteDataImportOverwrite.assertNotNull((Object)page);
        TestSiteDataImportOverwrite.assertEquals((String)"site 2", (String)page.getState().getDisplayName());
        this.end();
    }

    @Override
    protected void afterSecondBootWithOverride(PortalContainer container) throws Exception {
        this.begin();
        LayoutService layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
        PageStorage pageStorage = (PageStorage)container.getComponentInstanceOfType(PageStorage.class);
        PortalConfig portal = layoutService.getPortalConfig("classic");
        SiteLayout layout = portal.getPortalLayout();
        TestSiteDataImportOverwrite.assertEquals((int)1, (int)layout.getChildren().size());
        Application layoutPortlet = (Application)layout.getChildren().get(0);
        TestSiteDataImportOverwrite.assertEquals((String)"site2/layout", (String)layoutService.getId(layoutPortlet.getState()));
        PageContext home = pageStorage.loadPage(PageKey.parse((String)"portal::classic::home"));
        TestSiteDataImportOverwrite.assertNull((Object)home);
        PageContext page1 = pageStorage.loadPage(PageKey.parse((String)"portal::classic::page1"));
        TestSiteDataImportOverwrite.assertNotNull((Object)page1);
        TestSiteDataImportOverwrite.assertEquals((String)"site 2", (String)page1.getState().getDisplayName());
        PageContext page2 = pageStorage.loadPage(PageKey.parse((String)"portal::classic::page2"));
        TestSiteDataImportOverwrite.assertNotNull((Object)page2);
        TestSiteDataImportOverwrite.assertEquals((String)"site 2", (String)page2.getState().getDisplayName());
        this.end();
    }
}

