/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity(name="GateInContainer")
@Table(name="PORTAL_CONTAINERS")
@NamedQueries(value={@NamedQuery(name="ContainerEntity.findByIds", query="SELECT c FROM GateInContainer c WHERE c.id in (:ids)")})
public class ContainerEntity
extends ComponentEntity
implements Serializable {
    private static final long serialVersionUID = -8045606258160322858L;
    @Id
    @SequenceGenerator(name="SEQ_CONTAINER_ID_GENERATOR", sequenceName="SEQ_CONTAINER_ID_GENERATOR", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CONTAINER_ID_GENERATOR")
    @Column(name="ID")
    protected Long id;
    @Column(name="WEBUI_ID", length=200)
    private String webuiId;
    @Column(name="NAME", length=200)
    private String name;
    @Column(name="ICON", length=200)
    private String icon;
    @Column(name="TEMPLATE", length=500)
    private String template;
    @Column(name="FACTORY_ID", length=200)
    private String factoryId;
    @Column(name="TITLE", length=200)
    private String title;
    @Column(name="DESCRIPTION", length=2000)
    private String description;
    @Column(name="WIDTH", length=20)
    private String width;
    @Column(name="HEIGHT", length=20)
    private String height;
    @Column(name="PROPERTIES", length=2000)
    private String properties = ContainerEntity.getJSONString(new JSONObject());
    @Transient
    private List<ComponentEntity> children = new LinkedList<ComponentEntity>();
    @Column(name="CONTAINER_BODY", length=5000)
    private String containerBody = ContainerEntity.getJSONString(new JSONArray());

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getWebuiId() {
        return this.webuiId;
    }

    public void setWebuiId(String webuiId) {
        this.webuiId = webuiId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public void setFactoryId(String factoryId) {
        this.factoryId = factoryId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public List<ComponentEntity> getChildren() {
        return this.children;
    }

    public void setChildren(List<ComponentEntity> children) {
        this.children = children;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getContainerBody() {
        return this.containerBody;
    }

    public void setContainerBody(String containerBody) {
        this.containerBody = containerBody;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject obj = super.toJSON();
        JSONArray jChildren = new JSONArray();
        for (ComponentEntity child : this.getChildren()) {
            jChildren.add((Object)child.toJSON());
        }
        obj.put((Object)"children", (Object)jChildren);
        return obj;
    }

    @Override
    public ComponentEntity.TYPE getType() {
        return ComponentEntity.TYPE.CONTAINER;
    }
}

