/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.AbstractConfigTest;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.NewPortalConfigListener;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.storage.SiteStorage;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.junit.jupiter.api.Assertions;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/config/conf/configuration.xml")})
public class TestUserPortalConfigService
extends AbstractConfigTest {
    private static final String DEFAULT_CLASSIC_HOME = "/portal/classic/home";
    private UserPortalConfigService userPortalConfigService;
    private LayoutService layoutService;
    private NavigationService navigationService;
    private PageStorage pageStorage;
    private Authenticator authenticator;
    private ListenerService listenerService;
    private LinkedList<Event> events;
    private boolean registered = false;
    private SiteStorage siteStorage;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Listener listener = new Listener(){

            public void onEvent(Event event) throws Exception {
                TestUserPortalConfigService.this.events.add(event);
            }
        };
        PortalContainer container = this.getContainer();
        this.userPortalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        this.authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
        this.listenerService = (ListenerService)container.getComponentInstanceOfType(ListenerService.class);
        this.events = new LinkedList();
        this.layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
        this.navigationService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.pageStorage = (PageStorage)container.getComponentInstanceOfType(PageStorage.class);
        this.siteStorage = (SiteStorage)container.getComponentInstanceOfType(SiteStorage.class);
        if (!this.registered) {
            this.listenerService.addListener(LayoutService.PAGE_CREATED, (ListenerBase)listener);
            this.listenerService.addListener("org.exoplatform.portal.mop.page.page_destroyed", (ListenerBase)listener);
            this.listenerService.addListener("org.exoplatform.portal.mop.page.page_updated", (ListenerBase)listener);
            this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_created", (ListenerBase)listener);
            this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_destroyed", (ListenerBase)listener);
            this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_updated", (ListenerBase)listener);
        }
    }

    public void testCreateUserPortalConfigFromTemplate() {
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        GroupHandler groupHandler = organizationService.getGroupHandler();
        Group group = groupHandler.createGroupInstance();
        group.setGroupName("groupFromTemplate");
        group.setLabel("Group from template");
        groupHandler.addChild(null, group, true);
        String permission = "/organization/management/executive-board";
        String siteTemplate = "classic";
        String groupId = "/" + group.getGroupName();
        SiteKey groupSiteKey = SiteKey.group((String)groupId);
        SiteKey templateSiteKey = SiteKey.groupTemplate((String)siteTemplate);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.userPortalConfigService.createSiteFromTemplate(SiteKey.groupTemplate((String)"NotExistingTemplate"), groupSiteKey, permission));
        this.userPortalConfigService.createSiteFromTemplate(templateSiteKey, groupSiteKey, permission);
        PortalConfig portalConfig = this.layoutService.getPortalConfig(groupSiteKey);
        TestUserPortalConfigService.assertNotNull((Object)portalConfig);
        TestUserPortalConfigService.assertEquals((int)1, (int)portalConfig.getAccessPermissions().length);
        String accessPermission = "member:/organization/management/executive-board";
        TestUserPortalConfigService.assertEquals((String)accessPermission, (String)portalConfig.getAccessPermissions()[0]);
        String editPermission = "manager:/organization/management/executive-board";
        TestUserPortalConfigService.assertEquals((String)editPermission, (String)portalConfig.getEditPermission());
        TestUserPortalConfigService.assertEquals((long)0L, (long)portalConfig.getBannerFileId());
        TestUserPortalConfigService.assertEquals((int)1, (int)portalConfig.getDisplayOrder());
        TestUserPortalConfigService.assertFalse((boolean)portalConfig.isDefaultLayout());
        TestUserPortalConfigService.assertFalse((boolean)portalConfig.isDisplayed());
        TestUserPortalConfigService.assertEquals((String)"Classic Label", (String)portalConfig.getLabel());
        TestUserPortalConfigService.assertEquals((String)"Classic Description", (String)portalConfig.getDescription());
        TestUserPortalConfigService.assertEquals((String)groupSiteKey.getName(), (String)portalConfig.getName());
        TestUserPortalConfigService.assertEquals((String)groupSiteKey.getTypeName(), (String)portalConfig.getType());
        TestUserPortalConfigService.assertNotNull((Object)portalConfig.getPortalLayout());
        TestUserPortalConfigService.assertNotNull((Object)portalConfig.getPortalLayout().getChildren());
        TestUserPortalConfigService.assertEquals((int)2, (int)portalConfig.getPortalLayout().getChildren().size());
        TestUserPortalConfigService.assertEquals(Application.class, ((ModelObject)portalConfig.getPortalLayout().getChildren().get(0)).getClass());
        TestUserPortalConfigService.assertEquals(PageBody.class, ((ModelObject)portalConfig.getPortalLayout().getChildren().get(1)).getClass());
        TestUserPortalConfigService.assertEquals((String)"Everyone", (String)((Application)portalConfig.getPortalLayout().getChildren().get(0)).getAccessPermissions()[0]);
        List pages = this.layoutService.findPages(groupSiteKey);
        TestUserPortalConfigService.assertNotNull((Object)pages);
        TestUserPortalConfigService.assertEquals((int)3, (int)pages.size());
        PageContext pageContext = pages.stream().filter(p -> p.getKey().getName().equals("homepage")).findFirst().orElseThrow();
        TestUserPortalConfigService.assertEquals((String)accessPermission, (String)((String)pageContext.getState().getAccessPermissions().get(0)));
        TestUserPortalConfigService.assertEquals((String)editPermission, (String)pageContext.getState().getEditPermission());
        TestUserPortalConfigService.assertEquals((String)"Home Page", (String)pageContext.getState().getDisplayName());
        Page page = this.layoutService.getPage(pageContext.getKey());
        TestUserPortalConfigService.assertNotNull((Object)page);
        TestUserPortalConfigService.assertEquals((int)1, (int)page.getChildren().size());
        TestUserPortalConfigService.assertEquals((String)"Everyone", (String)((Application)page.getChildren().get(0)).getAccessPermissions()[0]);
        NavigationContext navigation = this.navigationService.loadNavigation(groupSiteKey);
        TestUserPortalConfigService.assertNotNull((Object)navigation);
        NodeContext rootNode = this.navigationService.loadNode(groupSiteKey);
        TestUserPortalConfigService.assertNotNull((Object)rootNode);
        TestUserPortalConfigService.assertEquals((int)2, (int)rootNode.getNodeCount());
        NodeData data = ((NodeContext)rootNode.get(0)).getData();
        NodeState state = ((NodeContext)rootNode.get(0)).getState();
        TestUserPortalConfigService.assertEquals((String)"home", (String)data.getName());
        TestUserPortalConfigService.assertEquals((String)"Home", (String)state.getLabel());
        TestUserPortalConfigService.assertEquals((Object)groupSiteKey.page("homepage"), (Object)state.getPageRef());
        TestUserPortalConfigService.assertEquals((int)1, (int)((NodeContext)rootNode.get(0)).getNodeCount());
        data = ((NodeContext)((NodeContext)rootNode.get(0)).get(0)).getData();
        state = ((NodeContext)((NodeContext)rootNode.get(0)).get(0)).getState();
        TestUserPortalConfigService.assertEquals((String)"testSubNode", (String)data.getName());
        TestUserPortalConfigService.assertEquals((String)"Sub Node", (String)state.getLabel());
        TestUserPortalConfigService.assertEquals((Object)groupSiteKey.page("testSubNode"), (Object)state.getPageRef());
        data = ((NodeContext)rootNode.get(1)).getData();
        state = ((NodeContext)rootNode.get(1)).getState();
        TestUserPortalConfigService.assertEquals((String)"test", (String)data.getName());
        TestUserPortalConfigService.assertEquals((String)"Test", (String)state.getLabel());
        TestUserPortalConfigService.assertEquals((Object)groupSiteKey.page("test"), (Object)state.getPageRef());
    }

    public void testDuplicateSiteTemplate() {
        String siteTemplate = "classic";
        String targetSiteTemplate = "classic2";
        String accessPermission = "member:@owner_id@";
        String editPermission = "manager:@owner_id@";
        SiteKey sourceTemplateSiteKey = SiteKey.groupTemplate((String)siteTemplate);
        SiteKey targetTemplateSiteKey = SiteKey.groupTemplate((String)targetSiteTemplate);
        PortalConfig sourcePortalConfig = this.layoutService.getPortalConfig(sourceTemplateSiteKey);
        TestUserPortalConfigService.assertNotNull((Object)sourcePortalConfig);
        this.userPortalConfigService.createSiteFromTemplate(sourceTemplateSiteKey, targetTemplateSiteKey);
        PortalConfig targetPortalConfig = this.layoutService.getPortalConfig(targetTemplateSiteKey);
        TestUserPortalConfigService.assertNotNull((Object)targetPortalConfig);
        TestUserPortalConfigService.assertEquals((int)1, (int)targetPortalConfig.getAccessPermissions().length);
        TestUserPortalConfigService.assertEquals((String)sourcePortalConfig.getAccessPermissions()[0], (String)targetPortalConfig.getAccessPermissions()[0]);
        TestUserPortalConfigService.assertEquals((String)sourcePortalConfig.getEditPermission(), (String)targetPortalConfig.getEditPermission());
        TestUserPortalConfigService.assertEquals((int)sourcePortalConfig.getDisplayOrder(), (int)targetPortalConfig.getDisplayOrder());
        TestUserPortalConfigService.assertEquals((boolean)sourcePortalConfig.isDefaultLayout(), (boolean)targetPortalConfig.isDefaultLayout());
        TestUserPortalConfigService.assertEquals((boolean)sourcePortalConfig.isDisplayed(), (boolean)targetPortalConfig.isDisplayed());
        TestUserPortalConfigService.assertEquals((String)sourcePortalConfig.getLabel(), (String)targetPortalConfig.getLabel());
        TestUserPortalConfigService.assertEquals((String)sourcePortalConfig.getDescription(), (String)targetPortalConfig.getDescription());
        TestUserPortalConfigService.assertEquals((String)targetTemplateSiteKey.getName(), (String)targetPortalConfig.getName());
        TestUserPortalConfigService.assertEquals((String)targetTemplateSiteKey.getTypeName(), (String)targetPortalConfig.getType());
        TestUserPortalConfigService.assertNotNull((Object)targetPortalConfig.getPortalLayout());
        TestUserPortalConfigService.assertNotNull((Object)targetPortalConfig.getPortalLayout().getChildren());
        TestUserPortalConfigService.assertEquals((int)2, (int)targetPortalConfig.getPortalLayout().getChildren().size());
        TestUserPortalConfigService.assertEquals(Application.class, ((ModelObject)targetPortalConfig.getPortalLayout().getChildren().get(0)).getClass());
        TestUserPortalConfigService.assertEquals(PageBody.class, ((ModelObject)targetPortalConfig.getPortalLayout().getChildren().get(1)).getClass());
        TestUserPortalConfigService.assertEquals((String)"Everyone", (String)((Application)targetPortalConfig.getPortalLayout().getChildren().get(0)).getAccessPermissions()[0]);
        List pages = this.layoutService.findPages(targetTemplateSiteKey);
        TestUserPortalConfigService.assertNotNull((Object)pages);
        TestUserPortalConfigService.assertEquals((int)3, (int)pages.size());
        PageContext pageContext = pages.stream().filter(p -> p.getKey().getName().equals("homepage")).findFirst().orElseThrow();
        TestUserPortalConfigService.assertEquals((String)accessPermission, (String)((String)pageContext.getState().getAccessPermissions().get(0)));
        TestUserPortalConfigService.assertEquals((String)editPermission, (String)pageContext.getState().getEditPermission());
        TestUserPortalConfigService.assertEquals((String)"Home Page", (String)pageContext.getState().getDisplayName());
        Page page = this.layoutService.getPage(pageContext.getKey());
        TestUserPortalConfigService.assertNotNull((Object)page);
        TestUserPortalConfigService.assertEquals((int)1, (int)page.getChildren().size());
        TestUserPortalConfigService.assertEquals((String)"Everyone", (String)((Application)page.getChildren().get(0)).getAccessPermissions()[0]);
        NavigationContext navigation = this.navigationService.loadNavigation(targetTemplateSiteKey);
        TestUserPortalConfigService.assertNotNull((Object)navigation);
        NodeContext rootNode = this.navigationService.loadNode(targetTemplateSiteKey);
        TestUserPortalConfigService.assertNotNull((Object)rootNode);
        TestUserPortalConfigService.assertEquals((int)2, (int)rootNode.getNodeCount());
        NodeData data = ((NodeContext)rootNode.get(0)).getData();
        NodeState state = ((NodeContext)rootNode.get(0)).getState();
        TestUserPortalConfigService.assertEquals((String)"home", (String)data.getName());
        TestUserPortalConfigService.assertEquals((String)"Home", (String)state.getLabel());
        TestUserPortalConfigService.assertEquals((Object)targetTemplateSiteKey.page("homepage"), (Object)state.getPageRef());
        TestUserPortalConfigService.assertEquals((int)1, (int)((NodeContext)rootNode.get(0)).getNodeCount());
        data = ((NodeContext)((NodeContext)rootNode.get(0)).get(0)).getData();
        state = ((NodeContext)((NodeContext)rootNode.get(0)).get(0)).getState();
        TestUserPortalConfigService.assertEquals((String)"testSubNode", (String)data.getName());
        TestUserPortalConfigService.assertEquals((String)"Sub Node", (String)state.getLabel());
        TestUserPortalConfigService.assertEquals((Object)targetTemplateSiteKey.page("testSubNode"), (Object)state.getPageRef());
        data = ((NodeContext)rootNode.get(1)).getData();
        state = ((NodeContext)rootNode.get(1)).getState();
        TestUserPortalConfigService.assertEquals((String)"test", (String)data.getName());
        TestUserPortalConfigService.assertEquals((String)"Test", (String)state.getLabel());
        TestUserPortalConfigService.assertEquals((Object)targetTemplateSiteKey.page("test"), (Object)state.getPageRef());
    }

    public void testComputePortalSitePath() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                NewPortalConfig config = new NewPortalConfig("classpath:/org/exoplatform/portal/config/conf");
                config.setOwnerType("portal");
                config.setOverrideMode(true);
                config.setImportMode("merge");
                HashSet<String> owners = new HashSet<String>();
                owners.add("test2");
                config.setPredefinedOwner(owners);
                NewPortalConfigListener newPortalConfigListener = new NewPortalConfigListener(TestUserPortalConfigService.this.userPortalConfigService, TestUserPortalConfigService.this.layoutService, (ConfigurationManager)TestUserPortalConfigService.this.getContainer().getComponentInstanceOfType(ConfigurationManager.class), new InitParams(), (NavigationService)TestUserPortalConfigService.this.getContainer().getComponentInstanceOfType(NavigationService.class), (DescriptionStorage)TestUserPortalConfigService.this.getContainer().getComponentInstanceOfType(DescriptionStorage.class), (UserACL)TestUserPortalConfigService.this.getContainer().getComponentInstanceOfType(UserACL.class), (LocaleConfigService)TestUserPortalConfigService.this.getContainer().getComponentInstanceOfType(LocaleConfigService.class));
                newPortalConfigListener.initPortalConfigDB(config);
                newPortalConfigListener.initPageDB(config);
                newPortalConfigListener.initPageNavigationDB(config);
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("test2", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"test2", (String)portalCfg.getName());
                String path = TestUserPortalConfigService.this.userPortalConfigService.getDefaultSitePath("test2", "mary");
                TestCase.assertEquals((String)"/portal/test2/test", (String)path);
                TestUserPortalConfigService.this.restartTransaction();
                TestUserPortalConfigService.this.layoutService.remove(PageKey.parse((String)"portal::test2::test"));
                TestUserPortalConfigService.this.restartTransaction();
                path = TestUserPortalConfigService.this.userPortalConfigService.getDefaultSitePath("test2", "mary");
                TestCase.assertEquals((String)"/portal/test2/home/page", (String)path);
            }
        }.execute("root");
    }

    public void testUpdatePortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                TestCase.assertEquals((String)"en", (String)portalCfg.getLocale());
                portalCfg.setLocale("fr");
                TestUserPortalConfigService.this.layoutService.save(portalCfg);
                userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "root");
                portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertEquals((String)"fr", (String)portalCfg.getLocale());
            }
        }.execute("root");
    }

    public void testEnforcedReimporting() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                TestCase.assertEquals((String)"en", (String)portalCfg.getLocale());
                portalCfg.setLocale("fr");
                TestUserPortalConfigService.this.layoutService.save(portalCfg);
                userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "root");
                portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertEquals((String)"fr", (String)portalCfg.getLocale());
                TestUserPortalConfigService.this.userPortalConfigService.start();
                userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "root");
                portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertEquals((String)"en", (String)portalCfg.getLocale());
            }
        }.execute("root");
    }

    public void testRootGetUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertEquals((String)("expected to have 5 navigations instead of " + String.valueOf(navigations)), (int)5, (int)navigations.size());
                TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
                TestCase.assertTrue((boolean)navigations.containsKey("portal::systemportal"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/administrators"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/users"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/organization/management/executive-board"));
            }
        }.execute("root");
    }

    public void testGetGlobalUserPortalConfig() {
        new UnitTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "john");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
                TestCase.assertTrue((boolean)navigations.containsKey("portal::" + TestUserPortalConfigService.this.userPortalConfigService.getGlobalPortal()));
                String originalGlobalPortal = TestUserPortalConfigService.this.userPortalConfigService.getGlobalPortal();
                TestUserPortalConfigService.this.userPortalConfigService.setGlobalPortal("system");
                try {
                    userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "root");
                    userPortal = userPortalCfg.getUserPortal();
                    navigations = TestUserPortalConfigService.toMap(userPortal);
                    TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
                    TestCase.assertTrue((boolean)navigations.containsKey("portal::system"));
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigService.setGlobalPortal(originalGlobalPortal);
                }
            }
        }.execute("root");
    }

    public void testGetGlobalUserNodes() {
        new UnitTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
                filterConfigBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
                filterConfigBuilder.withTemporalCheck();
                UserNodeFilterConfig filterConfig = filterConfigBuilder.build();
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "john");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                Collection nodes = userPortal.getNodes(SiteType.PORTAL, Scope.ALL, filterConfig);
                TestCase.assertNotNull((Object)nodes);
                int initialNodesSize = nodes.size();
                TestCase.assertTrue((initialNodesSize > 0 ? 1 : 0) != 0);
                String originalGlobalPortal = TestUserPortalConfigService.this.userPortalConfigService.getGlobalPortal();
                TestUserPortalConfigService.this.userPortalConfigService.setGlobalPortal("systemtest");
                try {
                    userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "root");
                    portalCfg = userPortalCfg.getPortalConfig();
                    userPortal = userPortalCfg.getUserPortal();
                    nodes = userPortal.getNodes(SiteType.PORTAL, Scope.ALL, filterConfig);
                    TestCase.assertNotNull((Object)nodes);
                    TestCase.assertEquals((int)initialNodesSize, (int)nodes.size());
                    UserNode homeNode = (UserNode)nodes.iterator().next();
                    TestCase.assertEquals((String)"home", (String)homeNode.getName());
                    TestCase.assertEquals((String)"classic", (String)homeNode.getNavigation().getKey().getName());
                    UserNode lastUserNode = (UserNode)new ArrayList(nodes).get(initialNodesSize - 1);
                    TestCase.assertEquals((String)"systemhome", (String)lastUserNode.getName());
                    TestCase.assertEquals((String)"systemtest", (String)lastUserNode.getNavigation().getKey().getName());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigService.setGlobalPortal(originalGlobalPortal);
                }
            }
        }.execute("root");
    }

    public void testGetUserNodesGlobalNotIncluded() {
        new UnitTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
                filterConfigBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
                filterConfigBuilder.withTemporalCheck();
                UserNodeFilterConfig filterConfig = filterConfigBuilder.build();
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "john");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                Collection nodes = userPortal.getNodes(SiteType.PORTAL, Scope.ALL, filterConfig, false);
                TestCase.assertNotNull((Object)nodes);
                int initialNodesSize = nodes.size();
                TestCase.assertTrue((initialNodesSize > 0 ? 1 : 0) != 0);
                String originalGlobalPortal = TestUserPortalConfigService.this.userPortalConfigService.getGlobalPortal();
                TestUserPortalConfigService.this.userPortalConfigService.setGlobalPortal("systemtest");
                try {
                    userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "root");
                    portalCfg = userPortalCfg.getPortalConfig();
                    userPortal = userPortalCfg.getUserPortal();
                    nodes = userPortal.getNodes(SiteType.PORTAL, Scope.ALL, filterConfig, false);
                    TestCase.assertNotNull((Object)nodes);
                    TestCase.assertEquals((int)initialNodesSize, (int)nodes.size());
                    UserNode homeNode = (UserNode)nodes.iterator().next();
                    TestCase.assertEquals((String)"home", (String)homeNode.getName());
                    TestCase.assertEquals((String)"classic", (String)homeNode.getNavigation().getKey().getName());
                    UserNode lastUserNode = (UserNode)new ArrayList(nodes).get(nodes.size() - 1);
                    TestCase.assertEquals((String)"webexplorer", (String)lastUserNode.getName());
                    TestCase.assertEquals((String)"classic", (String)lastUserNode.getNavigation().getKey().getName());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigService.setGlobalPortal(originalGlobalPortal);
                }
            }
        }.execute("root");
    }

    public void testJohnGetUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "john");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertEquals((String)("expected to have 5 navigations instead of " + String.valueOf(navigations)), (int)5, (int)navigations.size());
                TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/administrators"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/users"));
            }
        }.execute("john");
    }

    public void testMaryGetUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "mary");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertEquals((int)3, (int)navigations.size());
                TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/users"));
            }
        }.execute("mary");
    }

    public void testGuestGetUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", null);
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertEquals((String)String.valueOf(navigations), (int)2, (int)navigations.size());
                TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
            }
        }.execute(null);
    }

    public void testGetMetaPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                PortalConfig portalConfig = TestUserPortalConfigService.this.userPortalConfigService.getMetaPortalConfig();
                TestCase.assertNotNull((Object)portalConfig);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalConfig.getType());
                TestCase.assertEquals((String)"classic", (String)portalConfig.getName());
            }
        }.execute(null);
    }

    public void testNavigationOrder() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("classic", "root");
                UserPortal userPortal = userPortalCfg.getUserPortal();
                List navigations = userPortal.getNavigations();
                TestCase.assertEquals((String)("expected to have 5 navigations instead of " + String.valueOf(navigations)), (int)5, (int)navigations.size());
                TestCase.assertEquals((String)"classic", (String)((UserNavigation)navigations.get(0)).getKey().getName());
                TestCase.assertEquals((String)"/platform/administrators", (String)((UserNavigation)navigations.get(1)).getKey().getName());
                TestCase.assertEquals((String)"/organization/management/executive-board", (String)((UserNavigation)navigations.get(2)).getKey().getName());
                TestCase.assertEquals((String)"/platform/users", (String)((UserNavigation)navigations.get(3)).getKey().getName());
            }
        }.execute("root");
    }

    public void testCreateUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestUserPortalConfigService.this.userPortalConfigService.createUserPortalConfig(PortalConfig.PORTAL_TYPE, "jazz", "test");
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigService.getUserPortalConfig("jazz", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"jazz", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertEquals((String)("expected to have 5 navigations instead of " + String.valueOf(navigations)), (int)5, (int)navigations.size());
                TestCase.assertTrue((boolean)navigations.containsKey("portal::jazz"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/administrators"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/organization/management/executive-board"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/users"));
                this.queryPage();
            }

            private void queryPage() {
                try {
                    TestUserPortalConfigService.this.pageStorage.findPages(0, 10, SiteType.PORTAL, null, null, null);
                }
                catch (Exception ex) {
                    TestCase.assertTrue((String)"Exception while querying pages with new portal", (boolean)false);
                }
            }
        }.execute("root");
    }

    public void testCanRestore() {
        TestUserPortalConfigService.assertTrue((boolean)this.userPortalConfigService.canRestore("portal", "classic"));
        String customSiteName = "customSiteName";
        this.userPortalConfigService.createUserPortalConfig(PortalConfig.PORTAL_TYPE, customSiteName, "test");
        TestUserPortalConfigService.assertFalse((boolean)this.userPortalConfigService.canRestore("portal", customSiteName));
    }

    public void testRestore() {
        TestUserPortalConfigService.assertTrue((boolean)this.userPortalConfigService.restoreSite("portal", "classic", ImportMode.CONSERVE, true, true, true));
        TestUserPortalConfigService.assertTrue((boolean)this.userPortalConfigService.restoreSite("portal", "classic", ImportMode.INSERT, true, false, true));
        TestUserPortalConfigService.assertTrue((boolean)this.userPortalConfigService.restoreSite("portal", "classic", ImportMode.MERGE, true, true, false));
        TestUserPortalConfigService.assertTrue((boolean)this.userPortalConfigService.restoreSite("portal", "classic", ImportMode.OVERWRITE, false, false, true));
        String customSiteName = "customSiteName";
        this.userPortalConfigService.createUserPortalConfig(PortalConfig.PORTAL_TYPE, customSiteName, "test");
        TestUserPortalConfigService.assertFalse((boolean)this.userPortalConfigService.restoreSite("portal", customSiteName, ImportMode.OVERWRITE, false, true, false));
    }

    public void testRootGetPage() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertEquals((String)"group::/platform/administrators::newAccount", (String)TestUserPortalConfigService.this.userPortalConfigService.getPage(PageKey.parse((String)"group::/platform/administrators::newAccount"), "root").getKey().format());
                TestCase.assertEquals((String)"group::/organization/management/executive-board::newStaff", (String)TestUserPortalConfigService.this.userPortalConfigService.getPage(PageKey.parse((String)"group::/organization/management/executive-board::newStaff"), "root").getKey().format());
            }
        }.execute("root");
    }

    public void testJohnGetPage() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertNull((Object)TestUserPortalConfigService.this.userPortalConfigService.getPage(PageKey.parse((String)"group::/platform/administrators::newAccount"), "john"));
                TestCase.assertEquals((String)"group::/organization/management/executive-board::newStaff", (String)TestUserPortalConfigService.this.userPortalConfigService.getPage(PageKey.parse((String)"group::/organization/management/executive-board::newStaff"), "john").getKey().format());
            }
        }.execute("john");
    }

    public void testMaryGetPage() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertNull((Object)TestUserPortalConfigService.this.userPortalConfigService.getPage(PageKey.parse((String)"group::/platform/administrators::newAccount"), "mary"));
                TestCase.assertNull((Object)TestUserPortalConfigService.this.userPortalConfigService.getPage(PageKey.parse((String)"group::/organization/management/executive-board::newStaff"), "mary"));
            }
        }.execute("mary");
    }

    public void testAnonymousGetPage() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertNull((Object)TestUserPortalConfigService.this.userPortalConfigService.getPage(PageKey.parse((String)"group::/platform/administrators::newAccount"), null));
                TestCase.assertNull((Object)TestUserPortalConfigService.this.userPortalConfigService.getPage(PageKey.parse((String)"group::/organization/management/executive-board::newStaff"), null));
            }
        }.execute(null);
    }

    public void testGetUserHomePage() {
        TestUserPortalConfigService.assertNull((Object)this.userPortalConfigService.getUserHomePage(null));
        TestUserPortalConfigService.assertNull((Object)this.userPortalConfigService.getUserHomePage("john"));
        TestUserPortalConfigService.assertNull((Object)this.userPortalConfigService.getUserHomePage("NotExisting"));
        TestUserPortalConfigService.assertEquals((String)DEFAULT_CLASSIC_HOME, (String)this.userPortalConfigService.getDefaultPath("john"));
        this.userPortalConfigService.setUserHomePage("john", "/portal");
        TestUserPortalConfigService.assertEquals((String)"/portal", (String)this.userPortalConfigService.getUserHomePage("john"));
        TestUserPortalConfigService.assertEquals((String)"/portal", (String)this.userPortalConfigService.getDefaultPath("john"));
    }

    public void testGetDefaultSitePath() {
        TestUserPortalConfigService.assertEquals((String)DEFAULT_CLASSIC_HOME, (String)this.userPortalConfigService.getDefaultSitePath("classic", null));
        TestUserPortalConfigService.assertEquals((String)DEFAULT_CLASSIC_HOME, (String)this.userPortalConfigService.getDefaultSitePath("classic", "NotExisting"));
        TestUserPortalConfigService.assertEquals((String)DEFAULT_CLASSIC_HOME, (String)this.userPortalConfigService.getDefaultSitePath("classic", "john"));
        TestUserPortalConfigService.assertEquals((String)DEFAULT_CLASSIC_HOME, (String)this.userPortalConfigService.getDefaultSitePath("classic", "james"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSiteNodeOrGlobalNode() {
        UserNode userNode = this.userPortalConfigService.getDefaultSiteNode("classic", null);
        TestUserPortalConfigService.assertEquals((String)"home", (String)userNode.getURI());
        Page homePage = this.layoutService.getPage(userNode.getPageRef());
        String[] accessPermissions = homePage.getAccessPermissions();
        try {
            homePage.setAccessPermissions(new String[]{"*:/platform/administrators"});
            this.layoutService.save(new PageContext(homePage.getPageKey(), Utils.toPageState((Page)homePage)));
            userNode = this.userPortalConfigService.getDefaultSiteNode("classic", null);
            TestUserPortalConfigService.assertEquals((String)"home/subnode", (String)userNode.getURI());
        }
        finally {
            homePage.setAccessPermissions(accessPermissions);
            this.layoutService.save(new PageContext(homePage.getPageKey(), Utils.toPageState((Page)homePage)));
        }
    }

    public void testGetSiteNodeNoHomePageAccess() {
        UserNode userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "home", null);
        TestUserPortalConfigService.assertEquals((String)"home", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "Notfound", null);
        TestUserPortalConfigService.assertEquals((String)"home", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "webexplorer", null);
        TestUserPortalConfigService.assertEquals((String)"home", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "home", "NotExisting");
        TestUserPortalConfigService.assertEquals((String)"home", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "webexplorer", "NotExisting");
        TestUserPortalConfigService.assertEquals((String)"home", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "home", "john");
        TestUserPortalConfigService.assertEquals((String)"home", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "home/subnode", "john");
        TestUserPortalConfigService.assertEquals((String)"home/subnode", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "subnode", "john");
        TestUserPortalConfigService.assertEquals((String)"home/subnode", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "home/subnode2", "john");
        TestUserPortalConfigService.assertEquals((String)"home/subnode2", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "webexplorer", "john");
        TestUserPortalConfigService.assertEquals((String)"webexplorer", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "home/subnode233", "john");
        TestUserPortalConfigService.assertEquals((String)"home", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "home", "mary");
        TestUserPortalConfigService.assertEquals((String)"home", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "home/subnode", "mary");
        TestUserPortalConfigService.assertEquals((String)"home/subnode", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "home/subnode2", "mary");
        TestUserPortalConfigService.assertEquals((String)"home/subnode2", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "webexplorer", "john");
        TestUserPortalConfigService.assertEquals((String)"webexplorer", (String)userNode.getURI());
        userNode = this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "classic", "webexplorer", null);
        TestUserPortalConfigService.assertEquals((String)"home", (String)userNode.getURI());
        TestUserPortalConfigService.assertNull((Object)this.userPortalConfigService.getSiteNodeOrGlobalNode(SiteType.PORTAL.getName(), "NotFound", "home/subnode233", "mary"));
    }

    private static Map<String, UserNavigation> toMap(UserPortal cfg) {
        return TestUserPortalConfigService.toMap(cfg.getNavigations());
    }

    private static Map<String, UserNavigation> toMap(List<UserNavigation> navigations) {
        HashMap<String, UserNavigation> map = new HashMap<String, UserNavigation>();
        for (UserNavigation nav : navigations) {
            map.put(nav.getKey().getType().getName() + "::" + nav.getKey().getName(), nav);
        }
        return map;
    }

    private abstract class UnitTest {
        private UnitTest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void execute(String userId) {
            Exception failure = null;
            TestUserPortalConfigService.this.begin();
            ConversationState conversationState = null;
            if (userId != null) {
                try {
                    conversationState = new ConversationState(TestUserPortalConfigService.this.authenticator.createIdentity(userId));
                }
                catch (Exception e) {
                    failure = e;
                }
            }
            if (failure == null) {
                ConversationState.setCurrent(conversationState);
                try {
                    this.execute();
                }
                catch (Exception e) {
                    failure = e;
                }
                finally {
                    ConversationState.setCurrent(null);
                    TestUserPortalConfigService.this.end();
                }
            }
            if (failure != null) {
                AssertionFailedError err = new AssertionFailedError();
                err.initCause((Throwable)failure);
                throw err;
            }
        }

        protected abstract void execute() throws Exception;
    }
}

