/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import jakarta.persistence.EntityTransaction;
import java.util.List;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PersistentApplicationState;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.storage.TestDataStorage;
import org.exoplatform.portal.pom.spi.portlet.Portlet;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/standalone/portal-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/mop/navigation/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/config/conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/test.mop.portal.configuration.xml")})
public class TestModelStorage
extends TestDataStorage {
    private LayoutService storage_;

    public TestModelStorage(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.storage_ = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
    }

    protected void end(boolean save) {
        EntityManagerService managerService = (EntityManagerService)this.getContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityTransaction transaction = managerService.getEntityManager().getTransaction();
        if (transaction.isActive()) {
            if (save) {
                transaction.commit();
            } else {
                transaction.rollback();
            }
        }
        super.end();
    }

    protected void begin() {
        super.begin();
        EntityManagerService managerService = (EntityManagerService)this.getContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityTransaction transaction = managerService.getEntityManager().getTransaction();
        if (!transaction.isActive()) {
            transaction.begin();
        }
    }

    public void testWindowMove1() throws Exception {
        Page page = this.storage_.getPage("portal::test::test4");
        Application a1 = (Application)page.getChildren().get(0);
        Container a2 = (Container)page.getChildren().get(1);
        Application a3 = (Application)a2.getChildren().get(0);
        Application a4 = (Application)a2.getChildren().remove(1);
        page.getChildren().add(1, a4);
        List changes = this.storage_.save(page);
        page = this.storage_.getPage("portal::test::test4");
        TestModelStorage.assertEquals((int)3, (int)page.getChildren().size());
        Application c1 = (Application)page.getChildren().get(0);
        TestModelStorage.assertEquals((String)a1.getStorageId(), (String)c1.getStorageId());
        Application c2 = (Application)page.getChildren().get(1);
        TestModelStorage.assertEquals((String)a4.getStorageId(), (String)c2.getStorageId());
        Container c3 = (Container)page.getChildren().get(2);
        TestModelStorage.assertEquals((String)a2.getStorageId(), (String)c3.getStorageId());
        TestModelStorage.assertEquals((int)1, (int)c3.getChildren().size());
        Application c4 = (Application)c3.getChildren().get(0);
        TestModelStorage.assertEquals((String)a3.getStorageId(), (String)c4.getStorageId());
    }

    @Override
    public void testPageMerge() throws Exception {
        Page page = this.storage_.getPage("portal::test::test5");
        String app1Id = ((ModelObject)page.getChildren().get(0)).getStorageId();
        Container container = (Container)page.getChildren().get(1);
        String containerId = container.getStorageId();
        String app2Id = ((ModelObject)container.getChildren().get(0)).getStorageId();
        String app3Id = ((ModelObject)container.getChildren().get(1)).getStorageId();
        Application groovyApp = Application.createPortletApplication();
        TransientApplicationState state = new TransientApplicationState("web/GroovyPortlet");
        groovyApp.setState((ApplicationState)state);
        ((Container)page.getChildren().get(1)).getChildren().add(1, groovyApp);
        this.storage_.save(page);
        page = this.storage_.getPage("portal::test::test5");
        TestModelStorage.assertEquals((int)2, (int)page.getChildren().size());
        TestModelStorage.assertEquals((String)app1Id, (String)((ModelObject)page.getChildren().get(0)).getStorageId());
        container = (Container)page.getChildren().get(1);
        TestModelStorage.assertEquals((int)3, (int)container.getChildren().size());
        TestModelStorage.assertEquals((String)containerId, (String)container.getStorageId());
        TestModelStorage.assertEquals((String)app2Id, (String)((ModelObject)container.getChildren().get(0)).getStorageId());
        TestModelStorage.assertNotNull((Object)((ModelObject)container.getChildren().get(0)).getStorageId());
        TestModelStorage.assertEquals((String)app3Id, (String)((ModelObject)container.getChildren().get(2)).getStorageId());
        container.getChildren().remove(1);
        this.storage_.save(page);
        page = this.storage_.getPage("portal::test::test5");
        TestModelStorage.assertEquals((int)2, (int)page.getChildren().size());
        TestModelStorage.assertEquals((String)app1Id, (String)((ModelObject)page.getChildren().get(0)).getStorageId());
        container = (Container)page.getChildren().get(1);
        TestModelStorage.assertEquals((int)2, (int)container.getChildren().size());
        TestModelStorage.assertEquals((String)containerId, (String)container.getStorageId());
        TestModelStorage.assertEquals((String)app2Id, (String)((ModelObject)container.getChildren().get(0)).getStorageId());
        TestModelStorage.assertEquals((String)app3Id, (String)((ModelObject)container.getChildren().get(1)).getStorageId());
    }

    @Override
    public void testSiteLayout() throws Exception {
        PortalConfig pConfig = this.storage_.getPortalConfig(PortalConfig.PORTAL_TYPE, "classic");
        TestModelStorage.assertNotNull((Object)pConfig);
        TestModelStorage.assertNotNull((String)("The Group layout of " + pConfig.getName() + " is null"), (Object)pConfig.getPortalLayout());
        pConfig = this.storage_.getPortalConfig(PortalConfig.GROUP_TYPE, "/platform/administrators");
        TestModelStorage.assertNotNull((Object)pConfig);
        TestModelStorage.assertNotNull((String)("The Group layout of " + pConfig.getName() + " is null"), (Object)pConfig.getPortalLayout());
        TestModelStorage.assertTrue((pConfig.getPortalLayout().getChildren() != null && pConfig.getPortalLayout().getChildren().size() > 1 ? 1 : 0) != 0);
        pConfig.getPortalLayout().getChildren().clear();
        this.storage_.save(pConfig);
        pConfig = this.storage_.getPortalConfig(PortalConfig.GROUP_TYPE, "/platform/administrators");
        TestModelStorage.assertNotNull((Object)pConfig);
        TestModelStorage.assertNotNull((String)("The Group layout of " + pConfig.getName() + " is null"), (Object)pConfig.getPortalLayout());
        TestModelStorage.assertTrue((pConfig.getPortalLayout().getChildren() != null && pConfig.getPortalLayout().getChildren().size() == 0 ? 1 : 0) != 0);
    }

    public void testGetPageChildrenFilteredByProfiles() throws Exception {
        Page page = this.storage_.getPage("portal::test::test6");
        TestModelStorage.assertNotNull((Object)page.getChildren());
        TestModelStorage.assertEquals((int)1, (int)page.getChildren().size());
        Container container = (Container)page.getChildren().get(0);
        TestModelStorage.assertEquals((String)"test", (String)container.getProfiles());
    }

    public void testGetContainerClass() throws Exception {
        Page page = this.storage_.getPage("portal::test::test6");
        TestModelStorage.assertNotNull((Object)page.getChildren());
        TestModelStorage.assertEquals((int)1, (int)page.getChildren().size());
        Container container = (Container)page.getChildren().get(0);
        TestModelStorage.assertEquals((String)"testClass1 testClass2", (String)container.getCssClass());
    }

    @Override
    public void testNullPreferenceValue() throws Exception {
        Page page = this.storage_.getPage("portal::test::test4");
        Application app = (Application)page.getChildren().get(0);
        PersistentApplicationState state = (PersistentApplicationState)app.getState();
        Portlet prefs = this.storage_.load((ApplicationState)state);
        prefs.setValue("template", null);
        this.storage_.save((ApplicationState)state, prefs);
        prefs = this.storage_.load((ApplicationState)state);
        TestModelStorage.assertNotNull((Object)prefs);
    }
}

