/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.rest;

import java.util.Locale;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.resources.ResourceBundleService;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class UserFieldValidatorTest {
    @BeforeClass
    public static void setup() {
        PortalContainer container = PortalContainer.getInstance();
        ResourceBundleService resourceBundleService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
        if (resourceBundleService == null) {
            resourceBundleService = (ResourceBundleService)Mockito.mock(ResourceBundleService.class);
            container.registerComponentInstance((Object)resourceBundleService);
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
    }

    @Test
    public void testValidateFieldLength() {
        UserFieldValidator fieldValidator = new UserFieldValidator("field", false, false);
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "123"));
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, null));
        fieldValidator = new UserFieldValidator("field", false, false, 8, 10);
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "1234567"));
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "12345678"));
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "12345678901"));
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "1234567890"));
    }

    @Test
    public void testValidateUsername() {
        UserFieldValidator fieldValidator = new UserFieldValidator("field", true, false);
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "123"));
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "1aa"));
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "a1aa"));
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "aaA"));
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "aaa"));
    }

    @Test
    public void testValidatePersonalName() {
        UserFieldValidator fieldValidator = new UserFieldValidator("field", false, true);
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "123"));
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "1aa"));
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "&aa"));
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "a@a"));
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "aaa bb"));
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "aaa-bb"));
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "aaa'bb"));
    }

    @Test
    public void testValidateEmail() {
        UserFieldValidator fieldValidator = new UserFieldValidator("email", false, false);
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, ""));
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "WRONG_FORMAT"));
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "WRONG_FORMAT@"));
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "WRONG_FORMAT@test"));
        Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "@test.com"));
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "GOOD_FORMAT@test.com"));
        Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "GOOD_FORMAT@test.test"));
    }

    @Test
    public void testValidateFieldRegex() {
        System.setProperty("gatein.validators.fieldregexp.regexp", "[1-9]*");
        try {
            UserFieldValidator fieldValidator = new UserFieldValidator("fieldregexp", false, false);
            Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "123"));
            Assert.assertNotNull((Object)fieldValidator.validate(Locale.ENGLISH, "1aa"));
            String message = "FORMAT_MESSAGE";
            System.setProperty("gatein.validators.fieldregexp.format.message", message);
            fieldValidator = new UserFieldValidator("fieldregexp", false, false);
            Assert.assertEquals((Object)message, (Object)fieldValidator.validate(Locale.ENGLISH, "1aa"));
        }
        finally {
            System.setProperty("gatein.validators.fieldregexp.regexp", "");
        }
    }

    @Test
    public void testValidatePassword() {
        System.setProperty("gatein.validators.passwordpolicy.regexp", "((?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{9,256})");
        System.setProperty("gatein.validators.passwordpolicy.length.max", "256");
        System.setProperty("gatein.validators.passwordpolicy.length.min", "9");
        UserFieldValidator passwordValidator = new UserFieldValidator("password", false, false);
        Assert.assertNotNull((Object)passwordValidator.validate(Locale.ENGLISH, "passw"));
        Assert.assertNotNull((Object)passwordValidator.validate(Locale.ENGLISH, "1aa"));
        Assert.assertNotNull((Object)passwordValidator.validate(Locale.ENGLISH, "newPassword"));
        Assert.assertNotNull((Object)passwordValidator.validate(Locale.ENGLISH, "Aa123456"));
        Assert.assertNull((Object)passwordValidator.validate(Locale.ENGLISH, "newPassword1"));
    }

    @Test
    public void testValidateFieldRegexWithHyphen() {
        System.setProperty("gatein.validators.fieldregexphyphen.regexp", "[a-z1-9-]*");
        try {
            UserFieldValidator fieldValidator = new UserFieldValidator("fieldregexphyphen", true, false);
            Assert.assertNull((Object)fieldValidator.validate(Locale.ENGLISH, "a123-456"));
        }
        finally {
            System.setProperty("gatein.validators.fieldregexphyphen.regexp", "");
        }
    }
}

