/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao;

import java.io.Serializable;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.AbstractDAOTest;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.page.PageKey;

public class PageDAOTest
extends AbstractDAOTest {
    private PageDAO pageDAO;
    private SiteDAO siteDAO;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.pageDAO = this.getService(PageDAO.class);
        this.siteDAO = this.getService(SiteDAO.class);
        this.begin();
    }

    @Override
    protected void tearDown() throws Exception {
        this.pageDAO.deleteAll();
        this.siteDAO.deleteAll();
        super.tearDown();
        this.end();
    }

    public void testCreatePage() {
        PageEntity entity = this.createInstance("portal::b::c", "testCreatePage", "create page description");
        this.pageDAO.create((Object)entity);
        this.restartTransaction();
        PageEntity result = (PageEntity)this.pageDAO.find((Serializable)entity.getId());
        PageDAOTest.assertNotNull((Object)result);
        this.assertPage(entity, result);
    }

    public void testFindByKey() {
        PageEntity entity = this.createInstance("portal::b::c", "testPage", null);
        this.pageDAO.create((Object)entity);
        this.restartTransaction();
        PageEntity result = this.pageDAO.findByKey(PageKey.parse((String)"portal::b::c"));
        PageDAOTest.assertNotNull((Object)result);
        this.assertPage(entity, result);
    }

    public void testFindByQuery() throws Exception {
        PageEntity page1 = this.createInstance("portal::b::c1", "aBc dEf", null);
        this.pageDAO.create((Object)page1);
        PageEntity page2 = this.createInstance("portal::b::c2", "Efg Hik", null);
        this.pageDAO.create((Object)page2);
        this.restartTransaction();
        PageDAOTest.assertEquals((int)2, (int)this.pageDAO.findByQuery(SiteType.PORTAL, "b", "ef", 0, 0).getSize());
        PageDAOTest.assertEquals((int)1, (int)this.pageDAO.findByQuery(SiteType.PORTAL, "b", "hik", 0, 0).getSize());
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.getContainer().getComponentInstanceOfType(clazz);
    }

    private PageEntity createInstance(String key, String displayName, String description) {
        PageEntity entity = new PageEntity();
        PageKey pageKey = PageKey.parse((String)key);
        entity.setOwner(this.getOrCreateSite(pageKey.getSite().getName()));
        entity.setName(pageKey.getName());
        entity.setDisplayName(displayName);
        entity.setDescription(description);
        entity.setShowMaxWindow(true);
        entity.setHideSharedLayout(true);
        entity.setShowSharedLayout(true);
        entity.setFactoryId("testFactoryId");
        entity.setPageBody("testPageBody");
        entity.setPageType(PageType.PAGE);
        return entity;
    }

    private void assertPage(PageEntity entity, PageEntity result) {
        PageDAOTest.assertEquals((Object)entity.getId(), (Object)result.getId());
        PageDAOTest.assertEquals((String)entity.getDescription(), (String)result.getDescription());
        PageDAOTest.assertEquals((String)entity.getDisplayName(), (String)result.getDisplayName());
        PageDAOTest.assertEquals((String)entity.getFactoryId(), (String)result.getFactoryId());
        PageDAOTest.assertEquals((String)entity.getOwnerId(), (String)result.getOwnerId());
        PageDAOTest.assertEquals((Object)entity.getOwnerType(), (Object)result.getOwnerType());
        PageDAOTest.assertEquals((String)entity.getName(), (String)result.getName());
        PageDAOTest.assertEquals((String)entity.getFactoryId(), (String)result.getFactoryId());
        PageDAOTest.assertEquals((String)entity.getPageBody(), (String)result.getPageBody());
        PageDAOTest.assertEquals((Object)entity.getPageType(), (Object)result.getPageType());
    }

    private SiteEntity getOrCreateSite(String name) {
        SiteEntity siteEntity = this.siteDAO.findByKey(SiteType.PORTAL.key(name));
        if (siteEntity == null) {
            siteEntity = new SiteEntity();
            siteEntity.setSiteType(SiteType.PORTAL);
            siteEntity.setName(name);
            this.siteDAO.create((Object)siteEntity);
        }
        return siteEntity;
    }
}

