/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.account.setup.web;

import org.exoplatform.account.setup.web.AccountSetupService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.organization.OrganizationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AccountSetupServiceTest {
    @Mock
    private SettingService settingService;
    @Mock
    private OrganizationService organizationService;

    @Test
    public void shouldNotSkipAccountSetupWhenNothingSet() {
        PropertyManager.setProperty((String)"accountsetup.skip", (String)"");
        PropertyManager.setProperty((String)"exo.product.developing", (String)"");
        Mockito.when((Object)this.settingService.get((Context)Matchers.any(Context.class), (Scope)Matchers.any(Scope.class), (String)Matchers.eq((Object)"accountSetup"))).thenReturn(null);
        AccountSetupService accountSetupService = new AccountSetupService(this.settingService, this.organizationService);
        boolean mustSkip = accountSetupService.mustSkipAccountSetup();
        Assert.assertFalse((boolean)mustSkip);
    }

    @Test
    public void shouldSkipAccountSetupWhenPropertyIsSet() {
        PropertyManager.setProperty((String)"accountsetup.skip", (String)"true");
        AccountSetupService accountSetupService = new AccountSetupService(this.settingService, this.organizationService);
        boolean mustSkip = accountSetupService.mustSkipAccountSetup();
        Assert.assertTrue((boolean)mustSkip);
        PropertyManager.setProperty((String)"accountsetup.skip", (String)"");
    }

    @Test
    public void shouldSkipAccountSetupWhenAlreadyDoneOrSkipped() {
        Mockito.when((Object)this.settingService.get((Context)Matchers.any(Context.class), (Scope)Matchers.any(Scope.class), (String)Matchers.eq((Object)"accountSetup"))).thenReturn((Object)new SettingValue((Object)"true"));
        AccountSetupService accountSetupService = new AccountSetupService(this.settingService, this.organizationService);
        boolean mustSkip = accountSetupService.mustSkipAccountSetup();
        Assert.assertTrue((boolean)mustSkip);
    }

    @Test
    public void shouldSkipAccountSetupWhenDevelopingModeIsSet() {
        PropertyManager.setProperty((String)"exo.product.developing", (String)"true");
        AccountSetupService accountSetupService = new AccountSetupService(this.settingService, this.organizationService);
        boolean mustSkip = accountSetupService.mustSkipAccountSetup();
        Assert.assertTrue((boolean)mustSkip);
        PropertyManager.setProperty((String)"exo.product.developing", (String)"");
    }

    @Test
    public void shouldSkipAccountSetupWhenSkipSetup() {
        AccountSetupService accountSetupService = new AccountSetupService(this.settingService, this.organizationService);
        boolean mustSkipBefore = accountSetupService.mustSkipAccountSetup();
        accountSetupService.setSkipSetup(true);
        boolean mustSkipAfter = accountSetupService.mustSkipAccountSetup();
        Assert.assertFalse((boolean)mustSkipBefore);
        Assert.assertTrue((boolean)mustSkipAfter);
    }
}

