/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.mop.plugin;

import io.meeds.portal.mop.plugin.SiteAclPlugin;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class SiteAclPluginTest {
    private static final String SITE_ID = "123";
    private static final String SITE_NAME = "classic";
    @Mock
    private PortalContainer container;
    @Mock
    private LayoutService layoutService;
    @Mock
    private UserACL userAcl;
    @Mock
    private Identity identity;
    @Mock
    private PortalConfig portalConfig;
    @InjectMocks
    private SiteAclPlugin plugin;

    @Before
    public void setUp() {
        Mockito.when((Object)((LayoutService)this.container.getComponentInstanceOfType(LayoutService.class))).thenReturn((Object)this.layoutService);
        Mockito.when((Object)((UserACL)this.container.getComponentInstanceOfType(UserACL.class))).thenReturn((Object)this.userAcl);
        this.plugin.init();
    }

    @Test
    public void testGetObjectType() {
        Assert.assertEquals((Object)"site", (Object)this.plugin.getObjectType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHasPermissionWithNonNumericSiteId() {
        this.plugin.hasPermission("abc", "view", this.identity);
    }

    @Test
    public void testHasPermissionWithNullPortalConfigAndAdmin() {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn(null);
        Mockito.when((Object)this.userAcl.isAdministrator(this.identity)).thenReturn((Object)true);
        boolean result = this.plugin.hasPermission(SITE_ID, "VIEW", this.identity);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testHasPermissionWithNullPortalConfigAndNotAdmin() {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn(null);
        Mockito.when((Object)this.userAcl.isAdministrator(this.identity)).thenReturn((Object)false);
        boolean result = this.plugin.hasPermission(SITE_ID, "VIEW", this.identity);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testHasPermissionViewPermissionHasAccess() {
        this.mockPortalConfig(SITE_NAME);
        Mockito.when((Object)this.userAcl.hasAccessPermission(this.identity, "type", SITE_NAME, this.portalConfig.getAccessPermissions())).thenReturn((Object)true);
        Mockito.when((Object)this.userAcl.hasEditPermission(this.identity, "type", SITE_NAME, this.portalConfig.getEditPermission())).thenReturn((Object)false);
        boolean result = this.plugin.hasPermission(SITE_ID, "VIEW", this.identity);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testHasPermissionViewPermissionHasEdit() {
        this.mockPortalConfig(SITE_NAME);
        Mockito.when((Object)this.userAcl.hasAccessPermission(this.identity, "type", SITE_NAME, this.portalConfig.getAccessPermissions())).thenReturn((Object)false);
        Mockito.when((Object)this.userAcl.hasEditPermission(this.identity, "type", SITE_NAME, this.portalConfig.getEditPermission())).thenReturn((Object)true);
        boolean result = this.plugin.hasPermission(SITE_ID, "VIEW", this.identity);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testHasPermissionEditPermission() {
        this.mockPortalConfig(SITE_NAME);
        Mockito.when((Object)this.userAcl.hasEditPermission(this.identity, "type", SITE_NAME, this.portalConfig.getEditPermission())).thenReturn((Object)true);
        boolean result = this.plugin.hasPermission(SITE_ID, "EDIT", this.identity);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testHasPermissionDeletePermission() {
        this.mockPortalConfig(SITE_NAME);
        Mockito.when((Object)this.userAcl.hasEditPermission(this.identity, "type", SITE_NAME, this.portalConfig.getEditPermission())).thenReturn((Object)false);
        boolean result = this.plugin.hasPermission(SITE_ID, "DELETE", this.identity);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testHasPermissionUnknownPermission() {
        this.mockPortalConfig(SITE_NAME);
        boolean result = this.plugin.hasPermission(SITE_ID, "unknown", this.identity);
        Assert.assertFalse((boolean)result);
    }

    private void mockPortalConfig(String name) {
        Mockito.when((Object)this.layoutService.getPortalConfig(123L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)name);
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)"type");
        Mockito.when((Object)this.portalConfig.getEditPermission()).thenReturn((Object)"editPerm");
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)new String[]{"accessPerm"});
    }
}

