/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.permlink.service;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import io.meeds.portal.permlink.service.PermanentLinkServiceImpl;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PermanentLinkServiceTest {
    private static final String PERMANENT_LINK_ID = "testLinkId";
    private static final String INTERNAL_PATH_TEST_PREFIX = "internalPath/";
    private static final String TEST_USER = "testUser";
    private static final String TEST_PLUGIN = "testPlugin";
    @Mock
    private PortalContainer container;
    @Mock
    private SettingService settingService;
    private PermanentLinkServiceImpl permanentLinkService;

    @Before
    public void setup() {
        this.permanentLinkService = new PermanentLinkServiceImpl(this.container, this.settingService);
    }

    @Test
    public void testInit() {
        this.permanentLinkService.start();
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)ArgumentMatchers.eq((Object)PermanentLinkServiceImpl.PERMANEN_LINK_CONTEXT), (Scope)ArgumentMatchers.eq((Object)PermanentLinkServiceImpl.PERMANENT_LINK_IDS_SCOPE), (String)ArgumentMatchers.eq((Object)"PermanentLinkSalt"), (SettingValue)ArgumentMatchers.argThat(v -> StringUtils.equals((CharSequence)this.permanentLinkService.getSalt(), (CharSequence)v.getValue().toString())));
    }

    @Test
    public void testGetPermannentLinkWhenNoPlugin() {
        this.mockEmptyPlugins();
        Assert.assertNull((Object)this.permanentLinkService.getPermanentLink(new PermanentLinkObject(TEST_PLUGIN, "2")));
    }

    @Test
    public void testGetPermannentLink() {
        this.mockPlugins();
        String permanentLink = this.permanentLinkService.getPermanentLink(new PermanentLinkObject(TEST_PLUGIN, "2"));
        Assert.assertNotNull((Object)permanentLink);
        Assert.assertTrue((boolean)permanentLink.startsWith("/portal/l/"));
        Assert.assertFalse((boolean)permanentLink.contains(INTERNAL_PATH_TEST_PREFIX));
    }

    @Test
    public void testGetLinkWhenNoPlugin() {
        this.mockEmptyPlugins();
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.permanentLinkService.getLink(new PermanentLinkObject(TEST_PLUGIN, "2")));
    }

    @Test
    public void testGetLink() throws ObjectNotFoundException {
        this.mockPlugins();
        String directLink = this.permanentLinkService.getLink(new PermanentLinkObject(TEST_PLUGIN, "2"));
        Assert.assertNotNull((Object)directLink);
        Assert.assertFalse((boolean)directLink.startsWith("/portal/l/"));
        Assert.assertTrue((boolean)directLink.contains(INTERNAL_PATH_TEST_PREFIX));
    }

    @Test
    public void testGetDirectAccessUrlWhenNoPlugins() {
        this.mockEmptyPlugins();
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.permanentLinkService.getDirectAccessUrl("", identity));
    }

    @Test
    public void testGetDirectAccessUrlWhenAccessDenied() {
        this.mockPlugins();
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.settingService.get(PermanentLinkServiceImpl.PERMANEN_LINK_CONTEXT, PermanentLinkServiceImpl.PERMANENT_LINK_IDS_SCOPE, PERMANENT_LINK_ID)).thenReturn((Object)SettingValue.create((String)"testPlugin/3?param=value"));
        Assert.assertThrows(IllegalAccessException.class, () -> this.permanentLinkService.getDirectAccessUrl(PERMANENT_LINK_ID, identity));
    }

    @Test
    public void testGetDirectAccessUrl() throws IllegalAccessException, ObjectNotFoundException {
        this.mockPlugins();
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)TEST_USER);
        Mockito.when((Object)this.settingService.get(PermanentLinkServiceImpl.PERMANEN_LINK_CONTEXT, PermanentLinkServiceImpl.PERMANENT_LINK_IDS_SCOPE, PERMANENT_LINK_ID)).thenReturn((Object)SettingValue.create((String)"testPlugin/3?param=value"));
        String directAccessUrl = this.permanentLinkService.getDirectAccessUrl(PERMANENT_LINK_ID, identity);
        Assert.assertNotNull((Object)directAccessUrl);
        Assert.assertTrue((boolean)directAccessUrl.contains(INTERNAL_PATH_TEST_PREFIX));
    }

    private void mockEmptyPlugins() {
        Mockito.when((Object)this.container.getComponentInstancesOfType(PermanentLinkPlugin.class)).thenReturn(Collections.emptyList());
        this.permanentLinkService.initPlugins();
        this.permanentLinkService.initSalt();
    }

    private void mockPlugins() {
        Mockito.when((Object)this.container.getComponentInstancesOfType(PermanentLinkPlugin.class)).thenReturn(Collections.singletonList(new PermanentLinkPlugin(this){

            public String getObjectType() {
                return PermanentLinkServiceTest.TEST_PLUGIN;
            }

            public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
                boolean hasParam = object.getParameters() != null && object.getParameters().containsKey("param");
                return PermanentLinkServiceTest.INTERNAL_PATH_TEST_PREFIX + object.getObjectType() + "/" + object.getObjectId() + (String)(hasParam ? "?param=" + (String)object.getParameters().get("param") : "");
            }

            public boolean canAccess(PermanentLinkObject object, Identity identity) throws ObjectNotFoundException {
                return identity != null && PermanentLinkServiceTest.TEST_USER.equals(identity.getUserId());
            }
        }));
        this.permanentLinkService.initPlugins();
        this.permanentLinkService.initSalt();
    }
}

