/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.security.listener;

import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.listener.DefaultUserMembershipListener;
import io.meeds.portal.security.service.SecuritySettingService;
import java.util.Collections;
import java.util.Date;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultUserMembershipListenerTest {
    private static final String INTERNAL_USERS_GROUP = "/platform/users";
    private static final String GROUP_ID = "group1";
    private static final String USERNAME = "username";
    private static final String MT = "member";
    @Mock
    ExoContainer container;
    @Mock
    OrganizationService organizationService;
    @Mock
    SecuritySettingService securitySettingService;
    @Mock
    IdentityRegistry identityRegistry;
    @Mock
    ConversationRegistry conversationRegistry;
    @Mock
    Authenticator authenticator;
    @Mock
    Event<ConversationRegistry, ConversationState> event;
    @Mock
    ConversationState state;
    @Mock
    Identity identity;
    @Mock
    UserHandler userHandler;
    @Mock
    GroupHandler groupHandler;
    @Mock
    MembershipTypeHandler membershipTypeHandler;
    @Mock
    MembershipHandler membershipHandler;
    @Mock
    User user;
    @Mock
    Group group;
    @Mock
    MembershipType membershipType;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)((OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class))).thenReturn((Object)this.organizationService);
        Mockito.when((Object)((SecuritySettingService)this.container.getComponentInstanceOfType(SecuritySettingService.class))).thenReturn((Object)this.securitySettingService);
        Mockito.when((Object)((IdentityRegistry)this.container.getComponentInstanceOfType(IdentityRegistry.class))).thenReturn((Object)this.identityRegistry);
        Mockito.when((Object)((ConversationRegistry)this.container.getComponentInstanceOfType(ConversationRegistry.class))).thenReturn((Object)this.conversationRegistry);
        Mockito.when((Object)((Authenticator)this.container.getComponentInstanceOfType(Authenticator.class))).thenReturn((Object)this.authenticator);
        Mockito.when((Object)((ConversationState)this.event.getData())).thenReturn((Object)this.state);
        Mockito.when((Object)this.state.getIdentity()).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.organizationService.getGroupHandler()).thenReturn((Object)this.groupHandler);
        Mockito.when((Object)this.organizationService.getMembershipTypeHandler()).thenReturn((Object)this.membershipTypeHandler);
        Mockito.when((Object)this.organizationService.getMembershipHandler()).thenReturn((Object)this.membershipHandler);
        Mockito.when((Object)this.userHandler.findUserByName(USERNAME)).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getUserName()).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.groupHandler.findGroupById(GROUP_ID)).thenReturn((Object)this.group);
        Mockito.when((Object)this.membershipTypeHandler.findMembershipType(MT)).thenReturn((Object)this.membershipType);
    }

    @Test
    public void testConversationStateWhenNull() throws Exception {
        DefaultUserMembershipListener listener = new DefaultUserMembershipListener(this.container);
        Mockito.when((Object)((ConversationState)this.event.getData())).thenReturn(null);
        listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.organizationService});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.securitySettingService});
    }

    @Test
    public void testAddConversationStateWhenIdentityNull() throws Exception {
        DefaultUserMembershipListener listener = new DefaultUserMembershipListener(this.container);
        Mockito.when((Object)this.state.getIdentity()).thenReturn(null);
        listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.organizationService});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.securitySettingService});
    }

    @Test
    public void testAddConversationStateWhenUserNull() throws Exception {
        DefaultUserMembershipListener listener = new DefaultUserMembershipListener(this.container);
        Mockito.when((Object)this.identity.getUserId()).thenReturn(null);
        listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.organizationService});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.securitySettingService});
    }

    @Test
    public void testAddConversationStateWhenUserAnonym() throws Exception {
        DefaultUserMembershipListener listener = new DefaultUserMembershipListener(this.container);
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)IdentityConstants.ANONIM);
        listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.organizationService});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.securitySettingService});
    }

    @Test
    public void testAddConversationStateWhenNoGroups() throws Exception {
        DefaultUserMembershipListener listener = new DefaultUserMembershipListener(this.container);
        listener.onEvent(this.event);
        ((UserHandler)Mockito.verify((Object)this.userHandler)).saveUser(this.user, true);
        ((SecuritySettingService)Mockito.verify((Object)this.securitySettingService)).getRegistrationGroupIds();
    }

    @Test
    public void testLoginNotFirstTime() throws Exception {
        DefaultUserMembershipListener listener = new DefaultUserMembershipListener(this.container);
        Mockito.when((Object)this.user.getLastLoginTime()).thenReturn((Object)new Date());
        listener.onEvent(this.event);
        ((MembershipHandler)Mockito.verify((Object)this.membershipHandler, (VerificationMode)Mockito.never())).linkMembership(this.user, this.group, this.membershipType, true);
    }

    @Test
    public void testLoginFirstTimeWithExternalRegistrationAndNotOpen() throws Exception {
        DefaultUserMembershipListener listener = new DefaultUserMembershipListener(this.container);
        Mockito.when((Object)this.securitySettingService.getRegistrationGroupIds()).thenReturn((Object)new String[]{GROUP_ID});
        listener.onEvent(this.event);
        ((MembershipHandler)Mockito.verify((Object)this.membershipHandler, (VerificationMode)Mockito.never())).linkMembership(this.user, this.group, this.membershipType, true);
    }

    @Test
    public void testLoginFirstTimeWithInternalRegistrationAndNotOpen() throws Exception {
        DefaultUserMembershipListener listener = new DefaultUserMembershipListener(this.container);
        Mockito.when((Object)this.securitySettingService.getRegistrationGroupIds()).thenReturn((Object)new String[]{GROUP_ID});
        Mockito.when((Object)this.membershipHandler.findMembershipsByUserAndGroup(USERNAME, INTERNAL_USERS_GROUP)).thenReturn(Collections.singleton(new MembershipImpl()));
        listener.onEvent(this.event);
        ((MembershipHandler)Mockito.verify((Object)this.membershipHandler, (VerificationMode)Mockito.times((int)1))).linkMembership(this.user, this.group, this.membershipType, true);
    }

    @Test
    public void testLoginFirstTimeWhenOpenRegistration() throws Exception {
        DefaultUserMembershipListener listener = new DefaultUserMembershipListener(this.container);
        Mockito.when((Object)this.securitySettingService.getRegistrationGroupIds()).thenReturn((Object)new String[]{GROUP_ID});
        Mockito.when((Object)this.securitySettingService.getRegistrationType()).thenReturn((Object)UserRegistrationType.OPEN);
        listener.onEvent(this.event);
        ((MembershipHandler)Mockito.verify((Object)this.membershipHandler, (VerificationMode)Mockito.times((int)1))).linkMembership(this.user, this.group, this.membershipType, true);
    }
}

