/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.DynamicPortalLayoutMatcher;
import org.exoplatform.portal.config.DynamicPortalLayoutMatcherPlugin;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DynamicPortalLayoutMatcherPluginTest {
    private static final String NON_EXISTING_PATH = "NonExistingPath";
    private static final String EXISTING_PATH = "ExistingPath";
    private static final String PORTAL_SITE_NAME = "testPortal";
    private static final String GROUP_SITE_NAME = "testGroup";
    private static final String USER_SITE_NAME = "testUser";
    private InputStream portalLayoutInputStream;

    @Test
    public void testInitParams() {
        boolean enabled = true;
        boolean useCurrentPortalLayout = true;
        String layoutTemplatePath = "layoutPath";
        DynamicPortalLayoutMatcher matcher = (DynamicPortalLayoutMatcher)Mockito.mock(DynamicPortalLayoutMatcher.class);
        DynamicPortalLayoutMatcherPlugin dynamicPortalLayoutMatcherPlugin = this.mockPlugin(enabled, useCurrentPortalLayout, layoutTemplatePath, matcher);
        Assert.assertEquals((Object)matcher, (Object)dynamicPortalLayoutMatcherPlugin.getDynamicLayoutMatcher());
        Assert.assertEquals((Object)enabled, (Object)dynamicPortalLayoutMatcherPlugin.isEnabled());
        Assert.assertEquals((Object)useCurrentPortalLayout, (Object)dynamicPortalLayoutMatcherPlugin.isUseCurrentPortalLayout());
        Assert.assertEquals((Object)layoutTemplatePath, (Object)dynamicPortalLayoutMatcherPlugin.getLayoutTemplatePath());
        Assert.assertEquals((Object)layoutTemplatePath, (Object)dynamicPortalLayoutMatcherPlugin.getLayoutTemplatePath());
        enabled = !enabled;
        useCurrentPortalLayout = !useCurrentPortalLayout;
        dynamicPortalLayoutMatcherPlugin = this.mockPlugin(enabled, useCurrentPortalLayout, layoutTemplatePath, matcher);
        Assert.assertEquals((Object)matcher, (Object)dynamicPortalLayoutMatcherPlugin.getDynamicLayoutMatcher());
        Assert.assertEquals((Object)enabled, (Object)dynamicPortalLayoutMatcherPlugin.isEnabled());
        Assert.assertEquals((Object)useCurrentPortalLayout, (Object)dynamicPortalLayoutMatcherPlugin.isUseCurrentPortalLayout());
        Assert.assertEquals((Object)layoutTemplatePath, (Object)dynamicPortalLayoutMatcherPlugin.getLayoutTemplatePath());
        Assert.assertEquals((Object)layoutTemplatePath, (Object)dynamicPortalLayoutMatcherPlugin.getLayoutTemplatePath());
    }

    @Test
    public void testPluginInit() throws Exception {
        DynamicPortalLayoutMatcher matcher = (DynamicPortalLayoutMatcher)Mockito.mock(DynamicPortalLayoutMatcher.class);
        DynamicPortalLayoutMatcherPlugin dynamicPortalLayoutMatcherPlugin = this.mockPlugin(true, true, null, matcher);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        dynamicPortalLayoutMatcherPlugin.init(configurationManager);
        Assert.assertTrue((boolean)dynamicPortalLayoutMatcherPlugin.isInitialized());
        Assert.assertNull((Object)dynamicPortalLayoutMatcherPlugin.getLayoutTemplate());
        dynamicPortalLayoutMatcherPlugin = this.mockPlugin(true, true, NON_EXISTING_PATH, matcher);
        dynamicPortalLayoutMatcherPlugin.init(configurationManager);
        Assert.assertFalse((boolean)dynamicPortalLayoutMatcherPlugin.isEnabled());
        Assert.assertTrue((boolean)dynamicPortalLayoutMatcherPlugin.isInitialized());
        Assert.assertNull((Object)dynamicPortalLayoutMatcherPlugin.getLayoutTemplate());
        Mockito.when((Object)configurationManager.getInputStream(NON_EXISTING_PATH)).thenThrow(new Throwable[]{new IllegalStateException("Just Testing, no bug !"){
            private static final long serialVersionUID = -3930575563406989213L;

            @Override
            public StackTraceElement[] getStackTrace() {
                return new StackTraceElement[0];
            }
        }});
        dynamicPortalLayoutMatcherPlugin = this.mockPlugin(true, true, NON_EXISTING_PATH, matcher);
        dynamicPortalLayoutMatcherPlugin.init(configurationManager);
        Assert.assertFalse((boolean)dynamicPortalLayoutMatcherPlugin.isEnabled());
        Assert.assertTrue((boolean)dynamicPortalLayoutMatcherPlugin.isInitialized());
        Assert.assertNull((Object)dynamicPortalLayoutMatcherPlugin.getLayoutTemplate());
        Mockito.reset((Object[])new ConfigurationManager[]{configurationManager});
        Mockito.when((Object)configurationManager.getInputStream((String)Matchers.eq((Object)EXISTING_PATH))).thenReturn((Object)this.getPortalLayoutInputStream());
        dynamicPortalLayoutMatcherPlugin = this.mockPlugin(true, true, EXISTING_PATH, matcher);
        dynamicPortalLayoutMatcherPlugin.init(configurationManager);
        Assert.assertTrue((boolean)dynamicPortalLayoutMatcherPlugin.isEnabled());
        Assert.assertTrue((boolean)dynamicPortalLayoutMatcherPlugin.isInitialized());
        Assert.assertNotNull((Object)dynamicPortalLayoutMatcherPlugin.getLayoutTemplate());
        Assert.assertNotNull((Object)dynamicPortalLayoutMatcherPlugin.getLayoutTemplate().getChildren());
        Assert.assertEquals((long)5L, (long)dynamicPortalLayoutMatcherPlugin.getLayoutTemplate().getChildren().size());
    }

    @Test
    public void testGetDynamicLayout() {
        DynamicPortalLayoutMatcher matcher = (DynamicPortalLayoutMatcher)Mockito.mock(DynamicPortalLayoutMatcher.class);
        DynamicPortalLayoutMatcherPlugin dynamicPortalLayoutMatcherPlugin = this.mockPlugin(true, true, EXISTING_PATH, matcher);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        try {
            Mockito.reset((Object[])new ConfigurationManager[]{configurationManager});
            Mockito.when((Object)configurationManager.getInputStream((String)Matchers.eq((Object)EXISTING_PATH))).thenReturn((Object)this.getPortalLayoutInputStream());
        }
        catch (Exception e) {
            throw new AssertionError("Error while mocking configurationManager", e);
        }
        dynamicPortalLayoutMatcherPlugin.init(configurationManager);
        try {
            dynamicPortalLayoutMatcherPlugin.getPortalConfigWithDynamicLayout(null, null, null);
            Assert.fail((String)"Should throw IllegalArgumentException when siteKey is null");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        PortalConfig result = dynamicPortalLayoutMatcherPlugin.getPortalConfigWithDynamicLayout(SiteKey.group((String)GROUP_SITE_NAME), null, null);
        Assert.assertNull((Object)result);
        PortalConfig userPortalConfig = new PortalConfig(SiteType.USER.getName(), USER_SITE_NAME);
        userPortalConfig.useMetaPortalLayout();
        userPortalConfig.setDefaultLayout(false);
        result = dynamicPortalLayoutMatcherPlugin.getPortalConfigWithDynamicLayout(SiteKey.user((String)USER_SITE_NAME), userPortalConfig, null);
        Assert.assertNull((Object)result);
        PortalConfig sitePortalConfig = new PortalConfig(SiteType.PORTAL.getName(), PORTAL_SITE_NAME);
        result = dynamicPortalLayoutMatcherPlugin.getPortalConfigWithDynamicLayout(SiteKey.user((String)USER_SITE_NAME), userPortalConfig, sitePortalConfig);
        Assert.assertNull((Object)result);
        Mockito.when((Object)matcher.matches(SiteKey.user((String)USER_SITE_NAME), PORTAL_SITE_NAME)).thenReturn((Object)true);
        result = dynamicPortalLayoutMatcherPlugin.getPortalConfigWithDynamicLayout(SiteKey.user((String)USER_SITE_NAME), userPortalConfig, sitePortalConfig);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)userPortalConfig.getType(), (Object)result.getType());
        Assert.assertEquals((Object)userPortalConfig.getName(), (Object)result.getName());
        Assert.assertNotEquals((Object)sitePortalConfig.getPortalLayout(), (Object)result.getPortalLayout());
        Assert.assertEquals((long)sitePortalConfig.getPortalLayout().getChildren().size(), (long)result.getPortalLayout().getChildren().size());
        Assert.assertNotEquals((long)userPortalConfig.getPortalLayout().getChildren().size(), (long)result.getPortalLayout().getChildren().size());
        dynamicPortalLayoutMatcherPlugin = this.mockPlugin(true, false, EXISTING_PATH, matcher);
        try {
            Mockito.reset((Object[])new ConfigurationManager[]{configurationManager});
            Mockito.when((Object)configurationManager.getInputStream((String)Matchers.eq((Object)EXISTING_PATH))).thenReturn((Object)this.getPortalLayoutInputStream());
        }
        catch (Exception e) {
            throw new AssertionError("Error while mocking configurationManager", e);
        }
        dynamicPortalLayoutMatcherPlugin.init(configurationManager);
        Assert.assertNotNull((Object)dynamicPortalLayoutMatcherPlugin.getLayoutTemplate());
        Mockito.when((Object)matcher.matches(SiteKey.user((String)USER_SITE_NAME), PORTAL_SITE_NAME)).thenReturn((Object)true);
        result = dynamicPortalLayoutMatcherPlugin.getPortalConfigWithDynamicLayout(SiteKey.user((String)USER_SITE_NAME), userPortalConfig, sitePortalConfig);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)userPortalConfig.getType(), (Object)result.getType());
        Assert.assertEquals((Object)userPortalConfig.getName(), (Object)result.getName());
        Assert.assertEquals((long)5L, (long)result.getPortalLayout().getChildren().size());
    }

    private InputStream getPortalLayoutInputStream() {
        block9: {
            try {
                if (this.portalLayoutInputStream == null) {
                    try (InputStream is = this.getClass().getResourceAsStream("/org/exoplatform/portal/mop/user/portal/test/portal.xml");){
                        this.portalLayoutInputStream = new ByteArrayInputStream(IOUtil.getStreamContentAsBytes((InputStream)is));
                        break block9;
                    }
                }
                this.portalLayoutInputStream.reset();
            }
            catch (Exception e) {
                throw new AssertionError("Error reading portal layout file content", e);
            }
        }
        return this.portalLayoutInputStream;
    }

    private DynamicPortalLayoutMatcherPlugin mockPlugin(boolean enabled, boolean useCurrentPortalLayout, String layoutTemplatePath, DynamicPortalLayoutMatcher matcher) {
        InitParams params = new InitParams();
        ValueParam enabledParam = new ValueParam();
        enabledParam.setName("enabled");
        enabledParam.setValue(String.valueOf(enabled));
        params.addParameter((Parameter)enabledParam);
        ValueParam useCurrentPortalLayoutParam = new ValueParam();
        useCurrentPortalLayoutParam.setName("useCurrentPortalLayout");
        useCurrentPortalLayoutParam.setValue(String.valueOf(useCurrentPortalLayout));
        params.addParameter((Parameter)useCurrentPortalLayoutParam);
        ValueParam layoutTemplatePathParam = new ValueParam();
        layoutTemplatePathParam.setName("layoutTemplatePath");
        layoutTemplatePathParam.setValue(layoutTemplatePath);
        params.addParameter((Parameter)layoutTemplatePathParam);
        ObjectParameter matcherParam = new ObjectParameter();
        matcherParam.setName("matcher");
        matcherParam.setObject((Object)matcher);
        params.addParameter((Parameter)matcherParam);
        return new DynamicPortalLayoutMatcherPlugin(params);
    }
}

