/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao;

import jakarta.persistence.EntityTransaction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.portal.jdbc.entity.ContainerEntity;
import org.exoplatform.portal.mop.dao.AbstractDAOTest;
import org.exoplatform.portal.mop.dao.ContainerDAO;

public class ContainerDAOTest
extends AbstractDAOTest {
    private ContainerDAO containerDAO;
    private EntityTransaction transaction;

    @Override
    protected void setUp() throws Exception {
        this.begin();
        super.setUp();
        this.containerDAO = (ContainerDAO)this.getContainer().getComponentInstanceOfType(ContainerDAO.class);
        EntityManagerService managerService = (EntityManagerService)this.getContainer().getComponentInstanceOfType(EntityManagerService.class);
        this.transaction = managerService.getEntityManager().getTransaction();
        this.transaction.begin();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.transaction.isActive()) {
            this.transaction.rollback();
        }
        super.tearDown();
        this.end();
    }

    public void testCreateContainer() {
        ContainerEntity entity = this.createInstance("testContainer", "testDesc");
        this.containerDAO.create((Object)entity);
        this.restartTransaction();
        ContainerEntity result = (ContainerEntity)this.containerDAO.find((Serializable)entity.getId());
        ContainerDAOTest.assertNotNull((Object)result);
        this.assertContainer(entity, result);
    }

    public void testFindByIds() {
        ContainerEntity entity1 = this.createInstance("testContainer1", "testDesc1");
        this.containerDAO.create((Object)entity1);
        ContainerEntity entity2 = this.createInstance("testContainer2", "testDesc2");
        this.containerDAO.create((Object)entity2);
        this.restartTransaction();
        List results = this.containerDAO.findByIds(Arrays.asList(entity1.getId(), entity2.getId()));
        ContainerDAOTest.assertEquals((int)2, (int)results.size());
    }

    private ContainerEntity createInstance(String name, String description) {
        ContainerEntity entity = new ContainerEntity();
        entity.setContainerBody("testBody");
        entity.setDescription(description);
        entity.setFactoryId("testFactoriId");
        entity.setHeight("testHeight");
        entity.setIcon("testIcon");
        entity.setName(name);
        entity.setProperties("testProps");
        entity.setTemplate("testTemplate");
        entity.setTitle("testTitle");
        entity.setWidth("testWidth");
        return entity;
    }

    private void assertContainer(ContainerEntity expected, ContainerEntity result) {
        ContainerDAOTest.assertEquals((String)expected.getContainerBody(), (String)result.getContainerBody());
        ContainerDAOTest.assertEquals((String)expected.getDescription(), (String)result.getDescription());
        ContainerDAOTest.assertEquals((String)expected.getFactoryId(), (String)result.getFactoryId());
        ContainerDAOTest.assertEquals((String)expected.getHeight(), (String)result.getHeight());
        ContainerDAOTest.assertEquals((String)expected.getIcon(), (String)result.getIcon());
        ContainerDAOTest.assertEquals((Object)expected.getId(), (Object)result.getId());
        ContainerDAOTest.assertEquals((String)expected.getName(), (String)result.getName());
        ContainerDAOTest.assertEquals((String)expected.getProperties(), (String)result.getProperties());
        ContainerDAOTest.assertEquals((String)expected.getTemplate(), (String)result.getTemplate());
        ContainerDAOTest.assertEquals((String)expected.getTitle(), (String)result.getTitle());
        ContainerDAOTest.assertEquals((String)expected.getWidth(), (String)result.getWidth());
    }
}

