/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao.mock;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.jpa.mock.AbstractInMemoryDAO;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.services.organization.mock.InMemoryListAccess;

public class InMemoryPageDAO
extends AbstractInMemoryDAO<PageEntity>
implements PageDAO {
    public PageEntity findByKey(PageKey pageKey) {
        return this.entities.values().stream().filter(page -> StringUtils.equals((CharSequence)pageKey.getName(), (CharSequence)page.getName()) && StringUtils.equals((CharSequence)pageKey.getSite().getName(), (CharSequence)page.getOwnerId()) && pageKey.getSite().getType().equals((Object)page.getOwnerType())).findFirst().orElse(null);
    }

    public InMemoryListAccess<PageKey> findByQuery(SiteType siteType, String siteName, String name, int offset, int limit) {
        Stream<PageKey> pagesStream = this.entities.values().stream().filter(page -> {
            if (StringUtils.isNotBlank((CharSequence)siteName) && !StringUtils.equals((CharSequence)siteName, (CharSequence)page.getOwnerId())) {
                return false;
            }
            if (siteType != null && siteType != page.getOwnerType()) {
                return false;
            }
            return name == null || page.getDisplayName() != null && (StringUtils.contains((CharSequence)page.getDisplayName().toLowerCase(), (CharSequence)name.toLowerCase()) || StringUtils.contains((CharSequence)page.getName().toLowerCase(), (CharSequence)name.toLowerCase()));
        }).map(entity -> new PageKey(entity.getOwnerType(), entity.getOwnerId(), entity.getName()));
        if (limit > 0) {
            pagesStream = pagesStream.limit((long)offset + (long)limit);
            List<Object> result = pagesStream.toList();
            if (offset > 0) {
                result = result.size() > offset ? result.subList(offset, result.size()) : Collections.emptyList();
            }
            return new InMemoryListAccess(result, (Object[])new PageKey[0]);
        }
        List<PageKey> result = pagesStream.toList();
        return new InMemoryListAccess(result, (Object[])new PageKey[result.size()]);
    }

    public void deleteByOwner(long ownerId) {
        List<PageEntity> ownerPages = this.entities.values().stream().filter(page -> ownerId == page.getOwner().getId()).toList();
        this.deleteAll(ownerPages);
    }
}

