/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao.mock;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.jpa.mock.AbstractInMemoryDAO;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.mop.dao.PermissionDAO;

public class InMemoryPermissionDAO
extends AbstractInMemoryDAO<PermissionEntity>
implements PermissionDAO {
    public List<PermissionEntity> getPermissions(String refType, Long refId, PermissionEntity.TYPE type) {
        return this.entities.values().stream().filter(permission -> StringUtils.equals((CharSequence)refType, (CharSequence)permission.getReferenceType()) && refId.longValue() == permission.getReferenceId().longValue() && type == permission.getType()).toList();
    }

    public int deletePermissions(String refType, Long refId) {
        List<PermissionEntity> permissionList = this.entities.values().stream().filter(permission -> StringUtils.equals((CharSequence)refType, (CharSequence)permission.getReferenceType()) && refId.longValue() == permission.getReferenceId().longValue()).toList();
        this.deleteAll(permissionList);
        return permissionList.size();
    }

    public List<PermissionEntity> savePermissions(String refType, Long refId, PermissionEntity.TYPE type, List<String> permissions) {
        if (refId == null || type == null || refType == null) {
            throw new IllegalArgumentException("refType, refId , type must not be null");
        }
        ArrayList<PermissionEntity> oldPers = new ArrayList<PermissionEntity>(this.getPermissions(refType, refId, type));
        LinkedList<PermissionEntity> results = new LinkedList<PermissionEntity>();
        if (permissions != null) {
            for (String permission : permissions) {
                PermissionEntity entity = new PermissionEntity(refType, refId.longValue(), permission, type);
                int idx = oldPers.indexOf(entity);
                if (idx != -1) {
                    results.add((PermissionEntity)oldPers.get(idx));
                    oldPers.remove(entity);
                    continue;
                }
                this.create(entity);
                results.add(entity);
            }
        }
        this.deleteAll(oldPers);
        return results;
    }
}

