/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao.mock;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.jpa.mock.AbstractInMemoryDAO;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.SiteDAO;

public class InMemorySiteDAO
extends AbstractInMemoryDAO<SiteEntity>
implements SiteDAO {
    public SiteEntity findByKey(SiteKey siteKey) {
        return this.entities.values().stream().filter(site -> site.getSiteType() == siteKey.getType() && StringUtils.equals((CharSequence)site.getName(), (CharSequence)siteKey.getName())).findFirst().orElse(null);
    }

    public List<SiteEntity> findByType(SiteType siteType) {
        return this.entities.values().stream().filter(site -> site.getSiteType() == siteType).toList();
    }

    public List<SiteKey> findSiteKey(SiteType siteType) {
        return this.entities.values().stream().filter(site -> site.getSiteType() == siteType).map(site -> new SiteKey(siteType, site.getName())).toList();
    }

    public List<String> findPortalSites(int offset, int limit) {
        return this.findSiteKey(SiteType.PORTAL).stream().skip(offset).limit(this.limit(limit)).map(SiteKey::getName).toList();
    }

    public List<String> findUserSites(int offset, int limit) {
        return this.findSiteKey(SiteType.USER).stream().skip(offset).limit(this.limit(limit)).map(SiteKey::getName).toList();
    }

    public List<String> findGroupSites(int offset, int limit) {
        return this.findSiteKey(SiteType.GROUP).stream().filter(key -> !key.getName().startsWith("/spaces/")).skip(offset).limit(this.limit(limit)).map(SiteKey::getName).toList();
    }

    public List<String> findSpaceSites(int offset, int limit) {
        return this.findSiteKey(SiteType.GROUP).stream().filter(key -> key.getName().startsWith("/spaces/")).skip(offset).limit(this.limit(limit)).map(SiteKey::getName).toList();
    }

    public List<SiteKey> findSitesKeys(SiteFilter filter) {
        List<Object> res = this.entities.values().stream().toList();
        if (filter.isFilterByDisplayed()) {
            res = res.stream().filter(siteEntity -> siteEntity.isDisplayed() == filter.isDisplayed()).toList();
        }
        if (filter.getSiteType() != null) {
            res = res.stream().filter(siteEntity -> siteEntity.getSiteType() == filter.getSiteType()).toList();
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getExcludedSiteName())) {
            res = res.stream().filter(siteEntity -> !siteEntity.getName().equals(filter.getExcludedSiteName())).toList();
        }
        if (filter.isSortByDisplayOrder()) {
            res = res.stream().sorted(Comparator.comparingInt(SiteEntity::getDisplayOrder)).toList();
        }
        return res.stream().map(site -> new SiteKey(site.getSiteType(), site.getName())).toList();
    }

    private int limit(int limit) {
        return limit > 0 ? limit : Integer.MAX_VALUE;
    }
}

