/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.rest;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.portal.config.AbstractConfigTest;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.DependencySupplier;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;
import org.exoplatform.services.rest.tools.ResourceLauncher;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.settings.rest.SettingResource;
import org.json.JSONObject;

public class SettingResourceTest
extends AbstractConfigTest {
    protected ProviderBinder providers;
    protected ResourceBinder binder;
    protected RequestHandlerImpl requestHandler;
    protected ResourceLauncher launcher;
    private SettingService settingService;

    @Override
    public void setUp() throws Exception {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        super.setUp();
        this.binder = (ResourceBinder)this.getContainer().getComponentInstanceOfType(ResourceBinder.class);
        this.requestHandler = (RequestHandlerImpl)this.getContainer().getComponentInstanceOfType(RequestHandlerImpl.class);
        this.launcher = new ResourceLauncher((RequestHandler)this.requestHandler);
        DependencySupplier dependencySupplier = (DependencySupplier)this.getContainer().getComponentInstanceOfType(DependencySupplier.class);
        this.settingService = (SettingService)this.getContainer().getComponentInstanceOfType(SettingService.class);
        ProviderBinder.setInstance((ProviderBinder)new ProviderBinder());
        this.providers = ProviderBinder.getInstance();
        this.binder.clear();
        ApplicationContextImpl.setCurrent((ApplicationContext)new ApplicationContextImpl(null, null, this.providers, dependencySupplier));
        this.binder.addResource(SettingResource.class, null);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Arrays.asList(Context.GLOBAL, Context.USER).stream().forEach(context -> {
            Map settings = this.settingService.getSettingsByContext(context);
            settings.forEach((scope, scopeSettings) -> scopeSettings.keySet().forEach(settingKey -> this.settingService.remove(context, scope, settingKey)));
        });
    }

    protected void startSessionAs(String user, Collection<MembershipEntry> memberships) {
        Identity identity = new Identity(user, memberships);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
    }

    public void testReturnSettingWhenSuperUserGetsGlobalSetting() throws Exception {
        this.startSessionAs("root", new HashSet<MembershipEntry>());
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "testKey", new SettingValue((Object)"testValue"));
        ByteArrayContainerResponseWriter responseWriter = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("GET", "/v1/settings/GLOBAL/GLOBAL/testKey", "", null, null, (ContainerResponseWriter)responseWriter, null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)200, (int)resp.getStatus());
        JSONObject jsonObject = new JSONObject(new String(responseWriter.getBody()));
        SettingResourceTest.assertNotNull((Object)jsonObject);
        SettingResourceTest.assertEquals((int)4, (int)jsonObject.length());
        JSONObject context = (JSONObject)jsonObject.get("context");
        SettingResourceTest.assertEquals((Object)"GLOBAL", (Object)context.get("name"));
        SettingResourceTest.assertEquals((Object)"GLOBAL", (Object)context.get("id"));
        JSONObject scope = (JSONObject)jsonObject.get("scope");
        SettingResourceTest.assertEquals((Object)"GLOBAL", (Object)scope.get("name"));
        SettingResourceTest.assertEquals((Object)JSONObject.NULL, (Object)scope.get("id"));
        SettingResourceTest.assertEquals((String)"testKey", (String)((String)jsonObject.get("key")));
        SettingResourceTest.assertEquals((String)"testValue", (String)((String)jsonObject.get("value")));
    }

    public void testDoNotReturnSettingWhenUserGetsGlobalSetting() throws Exception {
        this.startSessionAs("john", new HashSet<MembershipEntry>());
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "testKey", new SettingValue((Object)"testValue"));
        ByteArrayContainerResponseWriter responseWriter = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("GET", "/v1/settings/GLOBAL/GLOBAL/testKey", "", null, null, (ContainerResponseWriter)responseWriter, null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)401, (int)resp.getStatus());
    }

    public void testReturnSettingWhenUserGetsOwnUserSetting() throws Exception {
        this.startSessionAs("john", Arrays.asList(new MembershipEntry("/platform/users", "member")));
        this.settingService.set(Context.USER.id("john"), Scope.GLOBAL, "testJohnKey", new SettingValue((Object)"testJohnValue"));
        ByteArrayContainerResponseWriter responseWriter = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("GET", "/v1/settings/USER/GLOBAL/testJohnKey", "", null, null, (ContainerResponseWriter)responseWriter, null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)200, (int)resp.getStatus());
        JSONObject jsonObject = new JSONObject(new String(responseWriter.getBody()));
        SettingResourceTest.assertNotNull((Object)jsonObject);
        SettingResourceTest.assertEquals((int)4, (int)jsonObject.length());
        JSONObject context = (JSONObject)jsonObject.get("context");
        SettingResourceTest.assertEquals((Object)"USER", (Object)context.get("name"));
        SettingResourceTest.assertEquals((Object)"john", (Object)context.get("id"));
        JSONObject scope = (JSONObject)jsonObject.get("scope");
        SettingResourceTest.assertEquals((Object)"GLOBAL", (Object)scope.get("name"));
        SettingResourceTest.assertEquals((Object)JSONObject.NULL, (Object)scope.get("id"));
        SettingResourceTest.assertEquals((String)"testJohnKey", (String)((String)jsonObject.get("key")));
        SettingResourceTest.assertEquals((String)"testJohnValue", (String)((String)jsonObject.get("value")));
    }

    public void testNotReturnSettingWhenUserGetsOtherUserSetting() throws Exception {
        this.startSessionAs("john", Arrays.asList(new MembershipEntry("/platform/users", "member")));
        this.settingService.set(Context.USER.id("mary"), Scope.GLOBAL, "testMaryKey", new SettingValue((Object)"testMaryValue"));
        ByteArrayContainerResponseWriter responseWriter = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("GET", "/v1/settings/USER,mary/GLOBAL/testMaryKey", "", null, null, (ContainerResponseWriter)responseWriter, null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)401, (int)resp.getStatus());
    }

    public void testReturnScopeSettingWhenSuperUserGetsScopeSetting() throws Exception {
        this.startSessionAs("root", new HashSet<MembershipEntry>());
        this.settingService.set(Context.GLOBAL, Scope.SPACE.id("MySpace"), "testMySpaceKey", new SettingValue((Object)"testMySpaceValue"));
        ByteArrayContainerResponseWriter responseWriter = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("GET", "/v1/settings/GLOBAL/SPACE,MySpace/testMySpaceKey", "", null, null, (ContainerResponseWriter)responseWriter, null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)200, (int)resp.getStatus());
        JSONObject jsonObject = new JSONObject(new String(responseWriter.getBody()));
        SettingResourceTest.assertNotNull((Object)jsonObject);
        SettingResourceTest.assertEquals((int)4, (int)jsonObject.length());
        JSONObject context = (JSONObject)jsonObject.get("context");
        SettingResourceTest.assertEquals((Object)"GLOBAL", (Object)context.get("name"));
        SettingResourceTest.assertEquals((Object)"GLOBAL", (Object)context.get("id"));
        JSONObject scope = (JSONObject)jsonObject.get("scope");
        SettingResourceTest.assertEquals((Object)"SPACE", (Object)scope.get("name"));
        SettingResourceTest.assertEquals((Object)"MySpace", (Object)scope.get("id"));
        SettingResourceTest.assertEquals((String)"testMySpaceKey", (String)((String)jsonObject.get("key")));
        SettingResourceTest.assertEquals((String)"testMySpaceValue", (String)((String)jsonObject.get("value")));
    }

    public void testNotReturnSettingWhenSuperUserGetsNonExistingSetting() throws Exception {
        this.startSessionAs("root", new HashSet<MembershipEntry>());
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "testKey", new SettingValue((Object)"testValue"));
        ByteArrayContainerResponseWriter responseWriter = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("GET", "/v1/settings/GLOBAL/GLOBAL/nonExistingSettingKey", "", null, null, (ContainerResponseWriter)responseWriter, null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)404, (int)resp.getStatus());
    }

    public void testNotReturnSettingWhenSuperUserGetsExistingSettingWithWrongScope() throws Exception {
        this.startSessionAs("root", new HashSet<MembershipEntry>());
        this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id("wiki"), "testWikiKey", new SettingValue((Object)"testWikiValue"));
        ByteArrayContainerResponseWriter responseWriter = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("GET", "/v1/settings/GLOBAL/APPLICATION,calendar/testWikiKey", "", null, null, (ContainerResponseWriter)responseWriter, null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)404, (int)resp.getStatus());
    }

    public void testNotReturnSettingWhenSuperUserGetsSettingWithWrongFormat() throws Exception {
        this.startSessionAs("root", new HashSet<MembershipEntry>());
        this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id("wiki"), "testWikiKey", new SettingValue((Object)"testWikiValue"));
        ByteArrayContainerResponseWriter responseWriter = new ByteArrayContainerResponseWriter();
        ContainerResponse resp = this.launcher.service("GET", "/v1/settings/GLOBAL/APPLICATION:wiki/testWikiKey", "", null, null, (ContainerResponseWriter)responseWriter, null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)404, (int)resp.getStatus());
    }

    public void testSettingCreatedWhenSuperUserSetsGlobalSetting() throws Exception {
        this.startSessionAs("root", new HashSet<MembershipEntry>());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"content-type", (Object)"application/json");
        ContainerResponse resp = this.launcher.service("PUT", "/v1/settings/GLOBAL/GLOBAL/testKey", "", (Map)headers, "{\"value\":\"testValue\"}".getBytes(), null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)200, (int)resp.getStatus());
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "testKey");
        SettingResourceTest.assertNotNull((Object)settingValue);
        SettingResourceTest.assertNotNull((Object)settingValue.getValue());
        SettingResourceTest.assertEquals((String)settingValue.getValue().toString(), (String)"testValue");
    }

    public void testSettingNotCreatedWhenUserSetsGlobalSetting() throws Exception {
        this.startSessionAs("john", Arrays.asList(new MembershipEntry("/platform/users", "member")));
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"content-type", (Object)"application/json");
        ContainerResponse resp = this.launcher.service("PUT", "/v1/settings/GLOBAL/GLOBAL/testJohnKey", "", (Map)headers, "{\"value\":\"testJohnValue\"}".getBytes(), null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)401, (int)resp.getStatus());
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "testJohnKey");
        SettingResourceTest.assertNull((Object)settingValue);
    }

    public void testSettingCreatedWhenUserSetsOwnUserSetting() throws Exception {
        this.startSessionAs("john", Arrays.asList(new MembershipEntry("/platform/users", "member")));
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"content-type", (Object)"application/json");
        ContainerResponse resp = this.launcher.service("PUT", "/v1/settings/USER/GLOBAL/testJohnKey", "", (Map)headers, "{\"value\":\"testJohnValue\"}".getBytes(), null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)200, (int)resp.getStatus());
        SettingValue settingValue = this.settingService.get(Context.USER, Scope.GLOBAL, "testJohnKey");
        SettingResourceTest.assertNotNull((Object)settingValue);
        SettingResourceTest.assertNotNull((Object)settingValue.getValue());
        SettingResourceTest.assertEquals((String)settingValue.getValue().toString(), (String)"testJohnValue");
    }

    public void testSettingNotCreatedWhenUserSetsOtherUserSetting() throws Exception {
        this.startSessionAs("john", Arrays.asList(new MembershipEntry("/platform/users", "member")));
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"content-type", (Object)"application/json");
        ContainerResponse resp = this.launcher.service("PUT", "/v1/settings/USER,mary/GLOBAL/testJohnKey", "", (Map)headers, "{\"value\":\"testJohnValue\"}".getBytes(), null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)401, (int)resp.getStatus());
        SettingValue settingValue = this.settingService.get(Context.USER.id("mary"), Scope.GLOBAL, "testJohnKey");
        SettingResourceTest.assertNull((Object)settingValue);
    }

    public void testSettingCreatedWhenSuperUserSetsScopeSetting() throws Exception {
        this.startSessionAs("root", new HashSet<MembershipEntry>());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"content-type", (Object)"application/json");
        ContainerResponse resp = this.launcher.service("PUT", "/v1/settings/GLOBAL/SPACE,MySpace/testMySpaceKey", "", (Map)headers, "{\"value\":\"testMySpaceValue\"}".getBytes(), null);
        SettingResourceTest.assertNotNull((Object)resp);
        SettingResourceTest.assertEquals((int)200, (int)resp.getStatus());
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.SPACE.id("MySpace"), "testMySpaceKey");
        SettingResourceTest.assertNotNull((Object)settingValue);
        SettingResourceTest.assertNotNull((Object)settingValue.getValue());
        SettingResourceTest.assertEquals((String)settingValue.getValue().toString(), (String)"testMySpaceValue");
    }
}

