/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.rest.UserRestResourcesV1;
import org.exoplatform.portal.rest.services.BaseRestServicesTestCase;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.exoplatform.web.login.recovery.ChangePasswordConnector;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.json.JSONObject;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class UserRestResourcesTest
extends BaseRestServicesTestCase {
    private static final String USER_1 = "testuser1";
    private static final String USER_2 = "testuser2";
    private UserHandler userHandler;
    private ChangePasswordConnector changePasswordConnector;
    private UserACL userACL;

    @Override
    protected Class<?> getComponentClass() {
        return UserRestResourcesV1.class;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        PasswordRecoveryService passwordRecoveryService = (PasswordRecoveryService)Mockito.mock(PasswordRecoveryService.class);
        this.changePasswordConnector = (ChangePasswordConnector)Mockito.mock(ChangePasswordConnector.class);
        ((ChangePasswordConnector)Mockito.doNothing().when((Object)this.changePasswordConnector)).changePassword((String)Mockito.any(), (String)Mockito.any());
        Mockito.when((Object)passwordRecoveryService.allowChangePassword((String)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)passwordRecoveryService.getActiveChangePasswordConnector()).thenReturn((Object)this.changePasswordConnector);
        this.getContainer().unregisterComponent(PasswordRecoveryService.class);
        this.getContainer().registerComponentInstance(PasswordRecoveryService.class, (Object)passwordRecoveryService);
        OrganizationService organizationService = (OrganizationService)Mockito.mock(OrganizationService.class);
        this.userHandler = (UserHandler)Mockito.mock(UserHandler.class);
        this.userACL = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.userHandler.findUserByName((String)Mockito.eq((Object)USER_2), (UserStatus)Mockito.any(UserStatus.class))).thenReturn(null);
        UserImpl user = new UserImpl(USER_1);
        Mockito.when((Object)this.userHandler.findUserByName((String)Mockito.eq((Object)USER_1), (UserStatus)Mockito.any(UserStatus.class))).thenReturn((Object)user);
        this.getContainer().unregisterComponent(OrganizationService.class);
        this.getContainer().unregisterComponent(UserACL.class);
        this.getContainer().registerComponentInstance((Object)"org.exoplatform.services.organization.OrganizationService", (Object)organizationService);
        this.getContainer().registerComponentInstance((Object)"org.exoplatform.portal.config.UserACL", (Object)this.userACL);
        ResourceBundleService resourceBundleService = (ResourceBundleService)this.container.getComponentInstanceOfType(ResourceBundleService.class);
        if (resourceBundleService == null) {
            resourceBundleService = (ResourceBundleService)Mockito.mock(ResourceBundleService.class);
            this.container.registerComponentInstance((Object)resourceBundleService);
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.getContainer().unregisterComponent((Object)"org.exoplatform.services.organization.OrganizationService");
        this.getContainer().unregisterComponent((Object)"org.exoplatform.portal.config.UserACL");
        super.tearDown();
    }

    public void testUnauthorizedNotSameUser() throws Exception {
        String path = this.getChangePasswordPath(USER_1);
        String currentPassword = "currentPassword";
        String newPassword = "newPassword";
        MockHttpServletRequest httpRequest = this.getChangePasswordRequest(path, currentPassword, newPassword);
        EnvironmentContext envctx = new EnvironmentContext();
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startUserSession(USER_2);
        ContainerResponse resp = this.launcher.service("PATCH", path, "", this.getChangePasswordHeaders(), this.getChangePasswordData(currentPassword, newPassword), envctx);
        UserRestResourcesTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)401, (int)resp.getStatus());
    }

    public void testAdminAuthorizedToChangePassword() throws Exception {
        String path = this.getChangePasswordPath(USER_1);
        String currentPassword = "currentPassword";
        String newPassword = "newPassword1";
        MockHttpServletRequest httpRequest = this.getChangePasswordRequest(path, currentPassword, newPassword);
        EnvironmentContext envctx = new EnvironmentContext();
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startUserSession(USER_2);
        Mockito.when((Object)this.userACL.isAdministrator(ConversationState.getCurrent().getIdentity())).thenReturn((Object)true);
        ContainerResponse resp = this.launcher.service("PATCH", path, "", this.getChangePasswordHeaders(), this.getChangePasswordData(currentPassword, newPassword), envctx);
        UserRestResourcesTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)204, (int)resp.getStatus());
        UserRestResourcesTest.assertNull((Object)resp.getEntity());
    }

    public void testChangePasswordUserNotFoundError() throws Exception {
        String path = this.getChangePasswordPath(USER_2);
        String currentPassword = "currentPassword";
        String newPassword = "newPassword";
        MockHttpServletRequest httpRequest = this.getChangePasswordRequest(path, currentPassword, newPassword);
        EnvironmentContext envctx = new EnvironmentContext();
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startUserSession(USER_2);
        Mockito.when((Object)this.userACL.isAdministrator(ConversationState.getCurrent().getIdentity())).thenReturn((Object)true);
        ContainerResponse resp = this.launcher.service("PATCH", path, "", this.getChangePasswordHeaders(), this.getChangePasswordData(currentPassword, newPassword), envctx);
        UserRestResourcesTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)500, (int)resp.getStatus());
        Object entity = resp.getEntity();
        UserRestResourcesTest.assertNotNull((Object)entity);
        UserRestResourcesTest.assertTrue((boolean)(entity instanceof String));
        String errorMessage = (String)entity;
        UserRestResourcesTest.assertEquals((String)"USER_NOT_FOUND", (String)errorMessage);
    }

    public void testSameUserWrongPassword() throws Exception {
        String path = this.getChangePasswordPath(USER_1);
        String currentPassword = "currentPassword";
        String newPassword = "newPassword";
        MockHttpServletRequest httpRequest = this.getChangePasswordRequest(path, currentPassword, newPassword);
        EnvironmentContext envctx = new EnvironmentContext();
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startUserSession(USER_1);
        ContainerResponse resp = this.launcher.service("PATCH", path, "", this.getChangePasswordHeaders(), this.getChangePasswordData(currentPassword, newPassword), envctx);
        UserRestResourcesTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)500, (int)resp.getStatus());
        Object entity = resp.getEntity();
        UserRestResourcesTest.assertNotNull((Object)entity);
        UserRestResourcesTest.assertTrue((boolean)(entity instanceof String));
        String errorMessage = (String)entity;
        UserRestResourcesTest.assertEquals((String)"WRONG_USER_PASSWORD", (String)errorMessage);
    }

    public void testSameUserAuthorizedToChangePassword() throws Exception {
        String path = this.getChangePasswordPath(USER_1);
        String currentPassword = "currentPassword";
        String newPassword = "newPassword1";
        MockHttpServletRequest httpRequest = this.getChangePasswordRequest(path, currentPassword, newPassword);
        EnvironmentContext envctx = new EnvironmentContext();
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        this.startUserSession(USER_1);
        Mockito.when((Object)this.userHandler.authenticate(USER_1, currentPassword)).thenReturn((Object)true);
        ContainerResponse resp = this.launcher.service("PATCH", path, "", this.getChangePasswordHeaders(), this.getChangePasswordData(currentPassword, newPassword), envctx);
        UserRestResourcesTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)204, (int)resp.getStatus());
    }

    public void testIsInternalUserAllowedToChangePassword() throws Exception {
        this.startUserSession(USER_1);
        ContainerResponse resp = this.launcher.service("GET", "/v1/users/isSynchronizedUserAllowedToChangePassword", "", null, null, null);
        UserRestResourcesTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)200, (int)resp.getStatus());
        UserRestResourcesTest.assertTrue((boolean)String.valueOf(resp.getEntity()).contains("true"));
        UserRestResourcesTest.assertNull((Object)System.getProperty("exo.portal.allow.change.external.password"));
        System.setProperty("exo.portal.allow.change.external.password", "true");
        resp = this.launcher.service("GET", "/v1/users/isSynchronizedUserAllowedToChangePassword", "", null, null, null);
        UserRestResourcesTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)200, (int)resp.getStatus());
        UserRestResourcesTest.assertTrue((boolean)String.valueOf(resp.getEntity()).contains("true"));
        System.setProperty("exo.portal.allow.change.external.password", "false");
        resp = this.launcher.service("GET", "/v1/users/isSynchronizedUserAllowedToChangePassword", "", null, null, null);
        UserRestResourcesTest.assertEquals((String)String.valueOf(resp.getEntity()), (int)200, (int)resp.getStatus());
        UserRestResourcesTest.assertTrue((boolean)String.valueOf(resp.getEntity()).contains("true"));
    }

    public void testCreateUser() throws Exception {
        Mockito.when((Object)this.userHandler.findUserByName((String)Mockito.eq((Object)USER_2), (UserStatus)Mockito.any())).thenReturn(null);
        ListAccess listAccess = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)this.userHandler.findUsersByQuery((Query)Mockito.any(), (UserStatus)Mockito.any())).thenReturn((Object)listAccess);
        Mockito.when((Object)listAccess.getSize()).thenReturn((Object)0);
        UserImpl user = new UserImpl(USER_2);
        Mockito.when((Object)this.userHandler.createUserInstance((String)Mockito.eq((Object)USER_2))).thenReturn((Object)user);
        this.startUserSession(USER_1);
        JSONObject data = new JSONObject();
        ContainerResponse response = this.getResponse("POST", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((String)response.getEntity().toString(), (int)400, (int)response.getStatus());
        data.put("userName", (Object)"");
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"password");
        data.put("email", (Object)"testuser2@example.com");
        response = this.getResponse("POST", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((String)response.getEntity().toString(), (int)400, (int)response.getStatus());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)"");
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"password");
        data.put("email", (Object)"testuser2@example.com");
        response = this.getResponse("POST", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((String)response.getEntity().toString(), (int)400, (int)response.getStatus());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)"");
        data.put("password", (Object)"password");
        data.put("email", (Object)"testuser2@example.com");
        response = this.getResponse("POST", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((String)response.getEntity().toString(), (int)400, (int)response.getStatus());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"");
        data.put("email", (Object)"testuser2@example.com");
        response = this.getResponse("POST", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((String)response.getEntity().toString(), (int)400, (int)response.getStatus());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"password");
        data.put("email", (Object)"");
        response = this.getResponse("POST", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((String)response.getEntity().toString(), (int)400, (int)response.getStatus());
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atMost((int)0))).createUser((User)Mockito.any(User.class), Mockito.anyBoolean());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"newPassword1");
        data.put("email", (Object)"testuser2@example.com");
        response = this.getResponse("POST", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atLeast((int)1))).createUser((User)Mockito.eq((Object)user), Mockito.eq((boolean)true));
    }

    public void testUpdateUser() throws Exception {
        Mockito.when((Object)this.userHandler.findUserByName((String)Mockito.eq((Object)USER_2), (UserStatus)Mockito.any())).thenReturn(null);
        ListAccess listAccess = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)this.userHandler.findUsersByQuery((Query)Mockito.any(), (UserStatus)Mockito.any())).thenReturn((Object)listAccess);
        Mockito.when((Object)listAccess.getSize()).thenReturn((Object)0);
        String email2 = "testuser2@example.com";
        UserImpl user2 = new UserImpl(USER_2);
        user2.setEmail(email2);
        user2.setFirstName(USER_2);
        user2.setLastName(USER_2);
        user2.setEnabled(Boolean.valueOf(false));
        String email1 = "testuser1@example.com";
        UserImpl user1 = new UserImpl(USER_1);
        user1.setEmail(email1);
        user1.setFirstName(USER_1);
        user1.setLastName(USER_1);
        user1.setEnabled(Boolean.valueOf(true));
        this.startUserSession(USER_1);
        Mockito.when((Object)this.userACL.isAdministrator(ConversationState.getCurrent().getIdentity())).thenReturn((Object)true);
        JSONObject data = new JSONObject();
        ContainerResponse response = this.getResponse("PUT", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"");
        data.put("email", (Object)email2);
        response = this.getResponse("PUT", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        Mockito.when((Object)this.userHandler.findUserByName((String)Mockito.eq((Object)USER_2), (UserStatus)Mockito.any())).thenReturn((Object)user2);
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)"");
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"password");
        data.put("email", (Object)email2);
        response = this.getResponse("PUT", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((String)response.getEntity().toString(), (int)400, (int)response.getStatus());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)"");
        data.put("password", (Object)"password");
        data.put("email", (Object)email2);
        response = this.getResponse("PUT", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((String)response.getEntity().toString(), (int)400, (int)response.getStatus());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"");
        data.put("email", (Object)email2);
        response = this.getResponse("PUT", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        Mockito.when((Object)this.userHandler.findUserByName((String)Mockito.eq((Object)USER_1), (UserStatus)Mockito.any())).thenReturn((Object)user1);
        data.put("userName", (Object)USER_1);
        data.put("lastName", (Object)USER_1);
        data.put("firstName", (Object)USER_1);
        data.put("password", (Object)"");
        data.put("enabled", false);
        data.put("email", (Object)email1);
        response = this.getResponse("PUT", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((String)"SelfDisable", (String)response.getEntity().toString());
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atMost((int)0))).saveUser((User)Mockito.any(User.class), Mockito.anyBoolean());
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atMost((int)0))).setEnabled(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyBoolean());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"newPassword1");
        data.put("email", (Object)email2);
        response = this.getResponse("PUT", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.times((int)0))).saveUser((User)user2, true);
        ((ChangePasswordConnector)Mockito.verify((Object)this.changePasswordConnector, (VerificationMode)Mockito.times((int)1))).changePassword(USER_2, "newPassword1");
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atMost((int)0))).setEnabled(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyBoolean());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"");
        data.put("email", (Object)email2);
        data.put("enabled", true);
        response = this.getResponse("PUT", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atMost((int)1))).saveUser((User)Mockito.eq((Object)user2), Mockito.eq((boolean)true));
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atLeast((int)1))).setEnabled(Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyBoolean());
        user2.setEnabled(Boolean.valueOf(true));
        Mockito.when((Object)this.userACL.getSuperUser()).thenReturn((Object)USER_2);
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"");
        data.put("enabled", false);
        data.put("email", (Object)email2);
        response = this.getResponse("PUT", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((String)"DisableSuperUser", (String)response.getEntity().toString());
        data.put("userName", (Object)USER_2);
        data.put("lastName", (Object)USER_2);
        data.put("firstName", (Object)USER_2);
        data.put("password", (Object)"");
        data.put("enabled", true);
        data.put("email", (Object)email2);
        response = this.getResponse("PUT", "/v1/users", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        user2.setDisplayName("testuser2 testuser2");
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atMost((int)1))).saveUser((User)Mockito.eq((Object)user2), Mockito.eq((boolean)true));
    }

    public void testDeleteUser() throws Exception {
        String email2 = "testuser2@example.com";
        UserImpl user2 = new UserImpl(USER_2);
        user2.setEmail(email2);
        user2.setFirstName(USER_2);
        user2.setLastName(USER_2);
        user2.setEnabled(Boolean.valueOf(false));
        Mockito.when((Object)this.userHandler.findUserByName((String)Mockito.eq((Object)USER_2), (UserStatus)Mockito.any())).thenReturn((Object)user2);
        String email1 = "testuser1@example.com";
        UserImpl user1 = new UserImpl(USER_1);
        user1.setEmail(email1);
        user1.setFirstName(USER_1);
        user1.setLastName(USER_1);
        user1.setEnabled(Boolean.valueOf(true));
        Mockito.when((Object)this.userHandler.findUserByName((String)Mockito.eq((Object)USER_1), (UserStatus)Mockito.any())).thenReturn((Object)user1);
        this.startUserSession(USER_1);
        ContainerResponse response = this.launcher.service("DELETE", "/v1/users/NOT_FOUND", "", null, null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atMost((int)0))).removeUser(Mockito.anyString(), Mockito.anyBoolean());
        response = this.launcher.service("DELETE", "/v1/users/testuser1", "", null, null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        UserRestResourcesTest.assertEquals((Object)"SelfDelete", (Object)response.getEntity());
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atMost((int)0))).removeUser(Mockito.anyString(), Mockito.anyBoolean());
        response = this.launcher.service("DELETE", "/v1/users/testuser2", "", null, null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        ((UserHandler)Mockito.verify((Object)this.userHandler, (VerificationMode)Mockito.atLeastOnce())).removeUser(Mockito.anyString(), Mockito.anyBoolean());
        Mockito.when((Object)this.userACL.getSuperUser()).thenReturn((Object)USER_2);
        response = this.launcher.service("DELETE", "/v1/users/testuser2", "", null, null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        UserRestResourcesTest.assertEquals((Object)"DeleteSuperUser", (Object)response.getEntity());
    }

    private MockHttpServletRequest getChangePasswordRequest(String path, String currentPassword, String newPassword) {
        byte[] formData = this.getChangePasswordData(currentPassword, newPassword);
        ByteArrayInputStream dataInputStream = new ByteArrayInputStream(formData);
        return new MockHttpServletRequest(path, (InputStream)dataInputStream, dataInputStream.available(), "PATCH", this.getChangePasswordHeaders());
    }

    private byte[] getChangePasswordData(String currentPassword, String newPassword) {
        return ("currentPassword=" + currentPassword + "&newPassword=" + newPassword).getBytes();
    }

    private MultivaluedMap<String, String> getChangePasswordHeaders() {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        return headers;
    }

    private String getChangePasswordPath(String username) {
        return "/v1/users/" + username + "/changePassword";
    }
}

