/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.Arrays;
import org.exoplatform.portal.config.AbstractConfigTest;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.exoplatform.portal.jdbc.entity.ContainerEntity;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.jdbc.entity.WindowEntity;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.dao.ContainerDAO;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.dao.WindowDAO;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class TestPageService
extends AbstractConfigTest {
    private PageStorage pageService;
    private SiteDAO siteDAO;
    private PageDAO pageDAO;
    private ContainerDAO containerDAO;
    private WindowDAO windowDAO;

    @Override
    protected void setUp() throws Exception {
        this.begin();
        super.setUp();
        this.pageService = (PageStorage)this.getContainer().getComponentInstanceOfType(PageStorage.class);
        this.pageDAO = (PageDAO)this.getContainer().getComponentInstanceOfType(PageDAO.class);
        this.containerDAO = (ContainerDAO)this.getContainer().getComponentInstanceOfType(ContainerDAO.class);
        this.windowDAO = (WindowDAO)this.getContainer().getComponentInstanceOfType(WindowDAO.class);
        this.siteDAO = (SiteDAO)this.getContainer().getComponentInstanceOfType(SiteDAO.class);
    }

    @Override
    protected void tearDown() throws Exception {
        QueryResult results = this.pageService.findPages(0, -1, null, null, null, null);
        for (PageContext page : results) {
            this.pageService.destroyPage(page.getKey());
        }
        this.siteDAO.deleteAll();
        super.tearDown();
        this.end();
    }

    public void testClonePage() throws Exception {
        WindowEntity app1 = this.createWindow("win1");
        this.windowDAO.create((Object)app1);
        WindowEntity app2 = this.createWindow("win2");
        this.windowDAO.create((Object)app2);
        ContainerEntity container = this.createContainer("cont1");
        container.setChildren(Arrays.asList(app2));
        this.containerDAO.create((Object)container);
        this.getOrCreateSite(SiteKey.portal((String)"srcPortal"));
        this.getOrCreateSite(SiteKey.portal((String)"targetPortal"));
        PageKey srcKey = new PageKey(SiteKey.portal((String)"srcPortal"), "srcName");
        PageEntity src = this.createPage(srcKey);
        src.setChildren(Arrays.asList(container, app1));
        src.setPageBody(((JSONArray)src.toJSON().get((Object)"children")).toJSONString());
        this.pageDAO.create((Object)src);
        this.restartTransaction();
        PageKey dstKey = new PageKey(SiteKey.portal((String)"targetPortal"), "targetName");
        this.pageService.clone(srcKey, dstKey);
        PageEntity result = this.pageDAO.findByKey(dstKey);
        TestPageService.assertNotNull((Object)result);
        JSONParser parser = new JSONParser();
        JSONArray children = (JSONArray)parser.parse(result.getPageBody());
        TestPageService.assertEquals((int)2, (int)children.size());
        JSONObject cont = (JSONObject)children.get(0);
        TestPageService.assertEquals((Object)ComponentEntity.TYPE.CONTAINER.name(), (Object)cont.get((Object)"type"));
    }

    private WindowEntity createWindow(String title) {
        WindowEntity window = new WindowEntity();
        window.setTitle(title);
        return window;
    }

    private ContainerEntity createContainer(String name) {
        ContainerEntity container = new ContainerEntity();
        container.setName(name);
        return container;
    }

    private PageEntity createPage(PageKey srcKey) {
        PageEntity page = new PageEntity();
        page.setName(srcKey.getName());
        page.setOwner(this.getOrCreateSite(srcKey.getSite()));
        return page;
    }

    private SiteEntity getOrCreateSite(SiteKey siteKey) {
        SiteEntity siteEntity = this.siteDAO.findByKey(siteKey);
        if (siteEntity == null) {
            siteEntity = new SiteEntity();
            siteEntity.setSiteType(siteKey.getType());
            siteEntity.setName(siteKey.getName());
            this.siteDAO.create((Object)siteEntity);
        }
        return siteEntity;
    }
}

