/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.branding;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.model.Branding;
import org.exoplatform.portal.branding.model.BrandingFile;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/v1/platform/branding")
@Tag(name="/v1/platform/branding", description="Managing branding information")
public class BrandingRestResourcesV1
implements ResourceContainer {
    private static final String IMAGE_MIME_TYPE = "image/png";
    private static final int CACHE_IN_SECONDS = 31536000;
    private static final int CACHE_IN_MILLI_SECONDS = 1471228928;
    private BrandingService brandingService;

    public BrandingRestResourcesV1(BrandingService brandingService) {
        this.brandingService = brandingService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get Branding information", description="Get Branding information", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getBrandingInformation() {
        Branding brandingInformation = this.brandingService.getBrandingInformation(false);
        return Response.ok((Object)brandingInformation).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/default")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Get default theme style", description="Get default theme style", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getDefaultBrandingThemeStyle() {
        Map defaultThemeStyle = this.brandingService.getDefaultThemeStyle();
        return Response.ok((Object)defaultThemeStyle).build();
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Branding information", description="Update Branding information", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Branding information updated")})
    public Response updateBrandingInformation(Branding branding) {
        this.brandingService.updateBrandingInformation(branding);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/logo")
    @Produces(value={"image/png"})
    @Operation(summary="Get Branding logo", description="Get Branding logo", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Branding logo retrieved"), @ApiResponse(responseCode="404", description="Branding logo not found"), @ApiResponse(responseCode="500", description="Server error when retrieving branding logo")})
    public Response getBrandingLogo(@Context Request request, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        return this.getBrandingFileResponse((BrandingFile)this.brandingService.getLogo(), request, version);
    }

    @GET
    @Path(value="/pageBackground")
    @Produces(value={"image/png"})
    @Operation(summary="Get Default Page Background image", description="Get Default Page Background image", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fullfilled"), @ApiResponse(responseCode="404", description="Object not found")})
    public Response getPageBackground(@Context Request request, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        return this.getBrandingFileResponse((BrandingFile)this.brandingService.getPageBackground(), request, version);
    }

    @GET
    @Path(value="/topBarBackground")
    @Produces(value={"image/png"})
    @Operation(summary="Get Default top bar Background image", description="Get Default top bar Background image", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fullfilled"), @ApiResponse(responseCode="404", description="Object not found")})
    public Response getTopBarBackground(@Context Request request, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        return this.getBrandingFileResponse((BrandingFile)this.brandingService.getTopBarBackground(), request, version);
    }

    @GET
    @Path(value="/sideBarBackground")
    @Produces(value={"image/png"})
    @Operation(summary="Get Default sidebar Background image", description="Get Default sidebar Background image", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fullfilled"), @ApiResponse(responseCode="404", description="Object not found")})
    public Response getSideBarBackground(@Context Request request, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        return this.getBrandingFileResponse((BrandingFile)this.brandingService.getSideBarBackground(), request, version);
    }

    @GET
    @Path(value="/drawerBackground")
    @Produces(value={"image/png"})
    @Operation(summary="Get Default drawer Background image", description="Get Default drawer Background image", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fullfilled"), @ApiResponse(responseCode="404", description="Object not found")})
    public Response getDrawerBackground(@Context Request request, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        return this.getBrandingFileResponse((BrandingFile)this.brandingService.getDrawerBackground(), request, version);
    }

    @GET
    @Path(value="/favicon")
    @Produces(value={"image/png"})
    @Operation(summary="Get Branding favicon", description="Get Branding favicon", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Branding favicon retrieved"), @ApiResponse(responseCode="404", description="Branding favicon not found"), @ApiResponse(responseCode="500", description="Server error when retrieving branding favicon")})
    public Response getBrandingFavicon(@Context Request request, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        return this.getBrandingFileResponse((BrandingFile)this.brandingService.getFavicon(), request, version);
    }

    @GET
    @Path(value="/loginBackground")
    @Produces(value={"image/png"})
    @Operation(summary="Get authentication pages left panel background", description="Get authentication pages left panel background", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fullfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Server error when retrieving resource")})
    public Response getLoginBackground(@Context Request request, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        return this.getBrandingFileResponse((BrandingFile)this.brandingService.getLoginBackground(), request, version);
    }

    @GET
    @Path(value="/css")
    @Operation(summary="Get Branding CSS content", description="Get Branding CSS content", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Branding css retrieved"), @ApiResponse(responseCode="304", description="Branding css not modified"), @ApiResponse(responseCode="500", description="Server error when retrieving branding css")})
    public Response getBrandingCSS(@Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String lastModified) {
        long lastUpdated = this.brandingService.getLastUpdatedTime();
        EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null || StringUtils.isBlank((CharSequence)lastModified)) {
            String themeCSS = this.brandingService.getThemeCSSContent();
            builder = Response.ok((Object)themeCSS, (String)"text/css");
            builder.tag(eTag);
            CacheControl cc = new CacheControl();
            cc.setMaxAge(86400);
            builder.type("text/css");
            builder.lastModified(new Date(lastUpdated));
            if (StringUtils.isNotBlank((CharSequence)lastModified)) {
                builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
            }
            builder.cacheControl(cc);
        }
        return builder.build();
    }

    private Response getBrandingFileResponse(BrandingFile iconFile, Request request, String version) {
        if (iconFile == null || iconFile.getData() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        long lastUpdated = iconFile.getUpdatedDate();
        EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null || StringUtils.isBlank((CharSequence)version)) {
            ByteArrayInputStream stream = new ByteArrayInputStream(iconFile.getData());
            builder = Response.ok((Object)stream, (String)IMAGE_MIME_TYPE);
            if (StringUtils.isNotBlank((CharSequence)version)) {
                builder.tag(eTag);
                builder.lastModified(new Date(lastUpdated));
                builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
                CacheControl cc = new CacheControl();
                cc.setMaxAge(31536000);
                builder.cacheControl(cc);
            }
        }
        return builder.build();
    }
}

