/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.rest;

import java.util.Arrays;
import java.util.Collection;
import org.exoplatform.portal.rest.MembershipTypeRestResourcesV1;
import org.exoplatform.portal.rest.services.BaseRestServicesTestCase;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.json.JSONObject;
import org.mockito.Mockito;

public class MembershipTypeRestResourcesTest
extends BaseRestServicesTestCase {
    private static final String MANDATORY_MS_TYPE = "manager";
    private static final String MEMBERSHIP_TYPE_1 = "mt1";
    private static final String MEMBERSHIP_TYPE_2 = "mt2";
    private static final String MEMBERSHIP_TYPE_3 = "mt3";
    private static final String MEMBERSHIP_TYPE_4 = "mt";
    private static final String MEMBERSHIP_TYPE_5 = "aaaaaa aaaaaaaaaaaa aaaaaaaaaaa";
    private static final String MEMBERSHIP_TYPE_6 = "mt6";
    private static final String MEMBERSHIP_TYPE_7 = "mt7";

    @Override
    protected Class<?> getComponentClass() {
        return MembershipTypeRestResourcesV1.class;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        OrganizationService organizationService = (OrganizationService)Mockito.mock(OrganizationService.class);
        MembershipTypeHandler membershipTypeHandler = (MembershipTypeHandler)Mockito.mock(MembershipTypeHandler.class);
        Mockito.when((Object)organizationService.getMembershipTypeHandler()).thenReturn((Object)membershipTypeHandler);
        MembershipTypeImpl membershipType1 = new MembershipTypeImpl(MEMBERSHIP_TYPE_1, null, MEMBERSHIP_TYPE_1);
        Mockito.when((Object)membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_1)).thenReturn((Object)membershipType1);
        MembershipTypeImpl membershipType2 = new MembershipTypeImpl(MEMBERSHIP_TYPE_2, null, MEMBERSHIP_TYPE_2);
        Mockito.when((Object)membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_2)).thenReturn((Object)membershipType2);
        Mockito.when((Object)membershipTypeHandler.findMembershipTypes()).thenReturn(Arrays.asList(membershipType1, membershipType2));
        this.getContainer().unregisterComponent(OrganizationService.class);
        this.getContainer().registerComponentInstance((Object)"org.exoplatform.services.organization.OrganizationService", (Object)organizationService);
        this.startUserSession("testuser");
    }

    @Override
    public void tearDown() throws Exception {
        this.getContainer().unregisterComponent((Object)"org.exoplatform.services.organization.OrganizationService");
        super.tearDown();
    }

    public void testCreateMembershipType() throws Exception {
        JSONObject data = new JSONObject();
        ContainerResponse response = this.getResponse("POST", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response.getEntity());
        data.put("name", (Object)MEMBERSHIP_TYPE_1);
        response = this.getResponse("POST", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response.getEntity());
        data.put("name", (Object)"NEW_MEMBERSHIP_TYPE");
        response = this.getResponse("POST", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        data.put("name", (Object)MEMBERSHIP_TYPE_3);
        data.put("description", (Object)"desc");
        response = this.getResponse("POST", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        data.put("name", (Object)MEMBERSHIP_TYPE_4);
        data.put("description", (Object)"desc");
        response = this.getResponse("POST", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        data.put("name", (Object)MEMBERSHIP_TYPE_5);
        data.put("description", (Object)"desc");
        response = this.getResponse("POST", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        data.put("name", (Object)MEMBERSHIP_TYPE_6);
        data.put("description", (Object)"de");
        response = this.getResponse("POST", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        String desc = "aaaaaa aaaaaaaaaaaa aaaaaaaaaa aaaaaaaaaaaaaaa aaaaaaaaaaaaaaa aaaaaaaaaaaa aaaaaaaaaaaaa aaaaaaaaaaaaaaaaa aaaaaaaaaaa aaaaaaaa aaa aa aaa aaa aaaaa aaa aaaa aaaaa aaaaaaaaaa aaaaaaaaaaaa aaaaaaaaaaaaa aaaa aaaaaa aaaa aaaaa aaaaaa aaaaaaaaaaa aaaaaaaaaa a";
        data.put("name", (Object)MEMBERSHIP_TYPE_7);
        data.put("description", (Object)desc);
        response = this.getResponse("POST", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
    }

    public void testUpdateMembershipType() throws Exception {
        JSONObject data = new JSONObject();
        ContainerResponse response = this.getResponse("PUT", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response.getEntity());
        data.put("name", (Object)"NOT_EXISTING");
        response = this.getResponse("PUT", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        data.put("name", (Object)MEMBERSHIP_TYPE_1);
        response = this.getResponse("PUT", "/v1/membershipTypes", data.toString());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testDeleteMembershipType() throws Exception {
        ContainerResponse response = this.launcher.service("DELETE", "/v1/membershipTypes/NOT_EXISTING", "", null, null, null);
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        response = this.launcher.service("DELETE", "/v1/membershipTypes/manager", "", null, null, null);
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        MembershipTypeRestResourcesTest.assertEquals((Object)"MandatoryMembershipType", (Object)response.getEntity());
        response = this.launcher.service("DELETE", "/v1/membershipTypes/mt1", "", null, null, null);
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testGetMembershipTypes() throws Exception {
        ContainerResponse response = this.launcher.service("GET", "/v1/membershipTypes", "", null, null, null);
        MembershipTypeRestResourcesTest.assertNotNull((Object)response);
        MembershipTypeRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        MembershipTypeRestResourcesTest.assertNotNull((Object)response.getEntity());
        MembershipTypeRestResourcesTest.assertTrue((boolean)(response.getEntity() instanceof Collection));
        Collection membershipTypes = (Collection)response.getEntity();
        MembershipTypeRestResourcesTest.assertEquals((int)2, (int)membershipTypes.size());
    }
}

