/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.AbstractConfigTest;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.dao.DescriptionDAO;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.gatein.common.util.Tools;

public class TestDescriptionService
extends AbstractConfigTest {
    private DescriptionStorage service;
    private DescriptionDAO descDAO;
    private String id = "testId";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        PortalContainer container = PortalContainer.getInstance();
        this.service = (DescriptionStorage)container.getComponentInstanceOfType(DescriptionStorage.class);
        this.descDAO = (DescriptionDAO)this.getContainer().getComponentInstanceOfType(DescriptionDAO.class);
        this.begin();
    }

    @Override
    protected void tearDown() throws Exception {
        this.descDAO.deleteAll();
        super.tearDown();
        this.end();
    }

    public void testResolveNoDescription() throws Exception {
        TestDescriptionService.assertEquals(null, (Object)this.service.resolveDescription("notExists", null, Locale.ENGLISH));
    }

    public void testResolveLocalizedDescription() throws Exception {
        HashMap<Locale, State> descriptions = new HashMap<Locale, State>();
        descriptions.put(Locale.ENGLISH, new State("name_en", null));
        descriptions.put(Locale.UK, new State("name_en_GB", null));
        this.service.setDescriptions(this.id, descriptions);
        TestDescriptionService.assertEquals(null, (Object)this.service.resolveDescription(this.id, null, Locale.GERMAN));
        TestDescriptionService.assertEquals(null, (Object)this.service.resolveDescription(this.id, null, new Locale("", "GB")));
        TestDescriptionService.assertEquals((Object)new State("name_en", null), (Object)this.service.resolveDescription(this.id, Locale.ENGLISH, Locale.GERMAN));
        TestDescriptionService.assertEquals((Object)new State("name_en_GB", null), (Object)this.service.resolveDescription(this.id, Locale.UK, Locale.GERMAN));
        TestDescriptionService.assertEquals((Object)new State("name_en", null), (Object)this.service.resolveDescription(this.id, Locale.US, Locale.GERMAN));
        TestDescriptionService.assertEquals((Object)new State("name_en", null), (Object)this.service.resolveDescription(this.id, null, Locale.ENGLISH));
        TestDescriptionService.assertEquals((Object)new State("name_en", null), (Object)this.service.resolveDescription(this.id, null, Locale.US));
        TestDescriptionService.assertEquals((Object)new State("name_en_GB", null), (Object)this.service.resolveDescription(this.id, null, Locale.UK));
    }

    public void testResolveDescription() throws Exception {
        HashMap<Locale, State> descriptions = new HashMap<Locale, State>();
        descriptions.put(Locale.ENGLISH, new State("name_en", null));
        descriptions.put(Locale.UK, new State("name_en_GB", null));
        this.service.setDescription(this.id, new State("name", null));
        this.service.setDescriptions(this.id, descriptions);
        TestDescriptionService.assertEquals(null, (Object)this.service.resolveDescription(this.id, null, Locale.GERMAN));
        TestDescriptionService.assertEquals((Object)new State("name_en", null), (Object)this.service.resolveDescription(this.id, Locale.ENGLISH, Locale.GERMAN));
        TestDescriptionService.assertEquals((Object)new State("name_en_GB", null), (Object)this.service.resolveDescription(this.id, Locale.UK, Locale.GERMAN));
        TestDescriptionService.assertEquals((Object)new State("name_en", null), (Object)this.service.resolveDescription(this.id, Locale.US, Locale.GERMAN));
        TestDescriptionService.assertEquals((Object)new State("name_en", null), (Object)this.service.resolveDescription(this.id, null, Locale.ENGLISH));
        TestDescriptionService.assertEquals((Object)new State("name_en", null), (Object)this.service.resolveDescription(this.id, null, Locale.US));
        TestDescriptionService.assertEquals((Object)new State("name_en_GB", null), (Object)this.service.resolveDescription(this.id, null, Locale.UK));
    }

    public void testGetDefaultDescription() throws Exception {
        this.service.setDescription(this.id, new State("foo_name", null));
        TestDescriptionService.assertEquals((Object)new State("foo_name", null), (Object)this.service.getDescription(this.id));
    }

    public void testRemoveDefaultDescription() throws Exception {
        this.service.setDescription(this.id, new State("foo_name", null));
        TestDescriptionService.assertEquals((Object)new State("foo_name", null), (Object)this.service.getDescription(this.id));
        this.service.setDescription(this.id, null);
        TestDescriptionService.assertNull((Object)this.service.getDescription(this.id));
    }

    public void testSetLocalizedDescription() throws Exception {
        this.service.setDescription(this.id, Locale.ENGLISH, new State("foo_english", null));
        TestDescriptionService.assertEquals((Object)new State("foo_english", null), (Object)this.service.getDescription(this.id, Locale.ENGLISH));
    }

    public void testSetInvalidLocaleDescription() throws Exception {
        try {
            this.service.setDescription(this.id, new Locale("", "GB"), new State("foo_invalid", null));
            TestDescriptionService.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.service.setDescription(this.id, new Locale("en", "GB", "variant"), new State("foo_invalid", null));
            TestDescriptionService.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddLocalizedDescription() throws Exception {
        this.service.setDescription(this.id, Locale.ENGLISH, new State("add_english", null));
        this.service.setDescription(this.id, Locale.FRENCH, new State("add_french", null));
        State desc = this.service.getDescription(this.id, Locale.ENGLISH);
        TestDescriptionService.assertNotNull((Object)desc);
        TestDescriptionService.assertEquals((String)"add_english", (String)desc.getName());
        desc = this.service.getDescription(this.id, Locale.FRENCH);
        TestDescriptionService.assertNotNull((Object)desc);
        TestDescriptionService.assertEquals((String)"add_french", (String)desc.getName());
    }

    public void testGetDescriptions() throws Exception {
        TestDescriptionService.assertNull((Object)this.service.getDescriptions(this.id));
        HashMap<Locale, State> descriptions = new HashMap<Locale, State>();
        descriptions.put(Locale.ENGLISH, new State("foo_english", null));
        descriptions.put(Locale.FRENCH, new State("foo_french", null));
        this.service.setDescriptions(this.id, descriptions);
        Map description = this.service.getDescriptions(this.id);
        TestDescriptionService.assertEquals((Object)Tools.toSet((Object[])new Locale[]{Locale.ENGLISH, Locale.FRENCH}), description.keySet());
        TestDescriptionService.assertEquals((Object)new State("foo_english", null), description.get(Locale.ENGLISH));
        TestDescriptionService.assertEquals((Object)new State("foo_french", null), description.get(Locale.FRENCH));
    }

    public void testSetDescriptions() throws Exception {
        TestDescriptionService.assertNull((Object)this.service.getDescriptions(this.id));
        Map<Locale, State> description = new HashMap<Locale, State>();
        description.put(Locale.ENGLISH, new State("bar_english", null));
        description.put(Locale.FRENCH, new State("bar_french", null));
        this.service.setDescriptions(this.id, description);
        description = this.service.getDescriptions(this.id);
        TestDescriptionService.assertEquals((Object)Tools.toSet((Object[])new Locale[]{Locale.ENGLISH, Locale.FRENCH}), description.keySet());
        TestDescriptionService.assertEquals((Object)new State("bar_english", null), description.get(Locale.ENGLISH));
        TestDescriptionService.assertEquals((Object)new State("bar_french", null), description.get(Locale.FRENCH));
        description = new HashMap();
        description.put(Locale.ENGLISH, new State("bar_english_2", null));
        this.service.setDescriptions(this.id, description);
        description = this.service.getDescriptions(this.id);
        TestDescriptionService.assertEquals((Object)Tools.toSet((Object[])new Locale[]{Locale.ENGLISH}), description.keySet());
        TestDescriptionService.assertEquals((Object)new State("bar_english_2", null), description.get(Locale.ENGLISH));
    }

    public void testSetInvalidLocaleDescriptions() throws Exception {
        try {
            this.service.setDescriptions(this.id, Collections.singletonMap(new Locale("", "GB"), new State("bar_invalid", null)));
            TestDescriptionService.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.service.setDescriptions(this.id, Collections.singletonMap(new Locale("en", "GB", "variant"), new State("bar_invalid", null)));
            TestDescriptionService.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

