/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.NewPortalConfigListener;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.services.resources.LocaleConfigService;
import org.mockito.Mockito;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration.xml")})
public class TestNavigationInsertAtIndex
extends AbstractKernelTest {
    protected NavigationService navigationService;
    protected NewPortalConfigListener newPortalConfigListener;

    protected void setUp() throws Exception {
        super.setUp();
        PortalContainer container = PortalContainer.getInstance();
        this.navigationService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.begin();
    }

    protected void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    public void testInsertNavigationAtIndex() throws Exception {
        this.importSiteNavigation("jar:/org/exoplatform/portal/config/conf");
        this.importSiteNavigation("jar:/org/exoplatform/portal/config/conf/portal/portal1/insertAt1");
        this.importSiteNavigation("jar:/org/exoplatform/portal/config/conf/portal/portal1/insertAt2");
        this.importSiteNavigation("jar:/org/exoplatform/portal/config/conf/portal/portal1/insertAt3");
        SiteKey siteKey = SiteKey.portal((String)"portal1");
        NodeContext rootNode = this.navigationService.loadNode(siteKey);
        TestNavigationInsertAtIndex.assertNotNull((Object)rootNode);
        TestNavigationInsertAtIndex.assertEquals((int)4, (int)rootNode.getSize());
        TestNavigationInsertAtIndex.assertEquals((String)"a", (String)((NodeContext)rootNode.get(0)).getName());
        TestNavigationInsertAtIndex.assertEquals((String)"b", (String)((NodeContext)rootNode.get(1)).getName());
        TestNavigationInsertAtIndex.assertEquals((String)"h", (String)((NodeContext)rootNode.get(2)).getName());
        TestNavigationInsertAtIndex.assertEquals((String)"c", (String)((NodeContext)rootNode.get(3)).getName());
        TestNavigationInsertAtIndex.assertEquals((String)"h", (String)((NodeContext)((NodeContext)((NodeContext)rootNode.get(3)).get(0)).get(0)).getName());
        TestNavigationInsertAtIndex.assertEquals((String)"h", (String)((NodeContext)((NodeContext)rootNode.get(0)).get(0)).getName());
    }

    private void importSiteNavigation(String location) throws Exception {
        InitParams initParams = (InitParams)Mockito.mock(InitParams.class);
        ValueParam valueParam = new ValueParam();
        valueParam.setName("meta.portal");
        valueParam.setValue("classic");
        Mockito.when((Object)initParams.getValueParam("meta.portal")).thenReturn((Object)valueParam);
        NewPortalConfig newPortalConfig = new NewPortalConfig();
        newPortalConfig.setImportMode("insert");
        newPortalConfig.setLocation(location);
        newPortalConfig.setOverrideMode(true);
        newPortalConfig.setOwnerType("portal");
        newPortalConfig.setPredefinedOwner(new HashSet<String>(Arrays.asList("portal1")));
        Mockito.when((Object)initParams.getObjectParamValues(NewPortalConfig.class)).thenReturn(Collections.singletonList(newPortalConfig));
        new NewPortalConfigListener((UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class), (LayoutService)ExoContainerContext.getService(LayoutService.class), (ConfigurationManager)ExoContainerContext.getService(ConfigurationManager.class), initParams, this.navigationService, (DescriptionStorage)ExoContainerContext.getService(DescriptionStorage.class), (UserACL)ExoContainerContext.getService(UserACL.class), (LocaleConfigService)ExoContainerContext.getService(LocaleConfigService.class)).run();
    }
}

