/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao.mock;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.jpa.mock.AbstractInMemoryDAO;
import org.exoplatform.portal.jdbc.entity.DescriptionEntity;
import org.exoplatform.portal.jdbc.entity.DescriptionState;
import org.exoplatform.portal.mop.dao.DescriptionDAO;

public class InMemoryDescriptionDAO
extends AbstractInMemoryDAO<DescriptionEntity>
implements DescriptionDAO {
    public DescriptionEntity getByRefId(String refId) {
        return this.entities.values().stream().filter(description -> StringUtils.equals((CharSequence)refId, (CharSequence)description.getReferenceId())).findFirst().orElse(null);
    }

    public int deleteByRefId(String refId) {
        DescriptionEntity entity = this.getByRefId(refId);
        this.delete(entity);
        return entity == null ? 0 : 1;
    }

    public DescriptionEntity saveDescriptions(String refId, Map<String, DescriptionState> states) {
        if (refId == null) {
            throw new IllegalArgumentException("refId , states must not be null");
        }
        DescriptionEntity entity = this.getOrCreate(refId);
        entity.setLocalized(states);
        if (entity.getId() == null) {
            this.create(entity);
        } else {
            this.update(entity);
        }
        return entity;
    }

    public DescriptionEntity saveDescription(String refId, DescriptionState state) {
        if (refId == null) {
            throw new IllegalArgumentException("refId , states must not be null");
        }
        DescriptionEntity entity = this.getOrCreate(refId);
        entity.setState(state);
        if (entity.getId() == null) {
            this.create(entity);
        } else {
            this.update(entity);
        }
        return entity;
    }

    private DescriptionEntity getOrCreate(String refId) {
        DescriptionEntity entity = this.getByRefId(refId);
        if (entity == null) {
            entity = new DescriptionEntity();
            entity.setReferenceId(refId);
        }
        return entity;
    }
}

