/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PersistentApplicationState;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.storage.SiteStorage;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.junit.Assert;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/mop/navigation/configuration.xml")})
public class TestDataStorage
extends AbstractKernelTest {
    private LayoutService storage_;
    private SiteStorage modelStorage;
    private PageStorage pageService;
    private NavigationService navService;
    private LinkedList<Event> events;
    private ListenerService listenerService;
    private OrganizationService org;

    public TestDataStorage(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        Listener listener = new Listener(){

            public void onEvent(Event event) throws Exception {
                TestDataStorage.this.events.add(event);
            }
        };
        super.setUp();
        PortalContainer container = PortalContainer.getInstance();
        this.storage_ = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
        this.pageService = (PageStorage)container.getComponentInstanceOfType(PageStorage.class);
        this.navService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.modelStorage = (SiteStorage)container.getComponentInstanceOfType(SiteStorage.class);
        this.events = new LinkedList();
        this.listenerService = (ListenerService)container.getComponentInstanceOfType(ListenerService.class);
        this.org = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        this.listenerService.addListener("org.exoplatform.portal.mop.page.page_created", (ListenerBase)listener);
        this.listenerService.addListener("org.exoplatform.portal.mop.page.page_destroyed", (ListenerBase)listener);
        this.listenerService.addListener(LayoutService.PAGE_UPDATED, (ListenerBase)listener);
        this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_created", (ListenerBase)listener);
        this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_destroyed", (ListenerBase)listener);
        this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_updated", (ListenerBase)listener);
        this.listenerService.addListener(LayoutService.PORTAL_CONFIG_CREATED, (ListenerBase)listener);
        this.listenerService.addListener(LayoutService.PORTAL_CONFIG_UPDATED, (ListenerBase)listener);
        this.listenerService.addListener(LayoutService.PORTAL_CONFIG_REMOVED, (ListenerBase)listener);
        this.begin();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.end();
    }

    private void assertPageFound(int offset, int limit, SiteType siteType, String siteName, String pageName, String title, String expectedPage) {
        QueryResult res = this.pageService.findPages(offset, limit, siteType, siteName, pageName, title);
        TestDataStorage.assertEquals((int)1, (int)res.getSize());
        TestDataStorage.assertEquals((String)expectedPage, (String)((PageContext)res.iterator().next()).getKey().format());
    }

    private void assertPageNotFound(int offset, int limit, SiteType siteType, String siteName, String pageName, String title) {
        QueryResult res = this.pageService.findPages(offset, limit, siteType, siteName, pageName, title);
        TestDataStorage.assertEquals((int)0, (int)res.getSize());
    }

    public void testCreatePortal() throws Exception {
        String label = "portal_foo";
        String description = "This is new portal for testing";
        PortalConfig portal = new PortalConfig();
        portal.setType("portal");
        portal.setName("foo1");
        portal.setLocale("en");
        portal.setLabel(label);
        portal.setDescription(description);
        portal.setAccessPermissions(new String[]{"Everyone"});
        this.storage_.create(portal);
        TestDataStorage.assertEquals((int)1, (int)this.events.size());
        portal = this.storage_.getPortalConfig(portal.getName());
        TestDataStorage.assertNotNull((Object)portal);
        TestDataStorage.assertEquals((String)"portal", (String)portal.getType());
        TestDataStorage.assertEquals((String)"foo1", (String)portal.getName());
        TestDataStorage.assertEquals((String)label, (String)portal.getLabel());
        TestDataStorage.assertEquals((String)description, (String)portal.getDescription());
        long siteId = Long.parseLong(portal.getStorageId().split("_")[1]);
        PortalConfig portal1 = this.storage_.getPortalConfig(siteId);
        TestDataStorage.assertNotNull((Object)portal1);
        TestDataStorage.assertEquals((String)portal1.getStorageId(), (String)portal.getStorageId());
        TestDataStorage.assertEquals((String)"portal", (String)portal1.getType());
        TestDataStorage.assertEquals((String)"foo1", (String)portal1.getName());
        TestDataStorage.assertEquals((String)label, (String)portal1.getLabel());
        TestDataStorage.assertEquals((String)description, (String)portal1.getDescription());
    }

    public void testRemovePortal() {
        PortalConfig portal = new PortalConfig();
        portal.setType("portal");
        portal.setName("foo85");
        portal.setLocale("en");
        portal.setAccessPermissions(new String[]{"Everyone"});
        this.storage_.create(portal);
        portal = this.storage_.getPortalConfig(portal.getName());
        TestDataStorage.assertNotNull((Object)portal);
        TestDataStorage.assertEquals((String)"portal", (String)portal.getType());
        TestDataStorage.assertEquals((String)"foo85", (String)portal.getName());
        this.storage_.remove(portal);
        portal = this.storage_.getPortalConfig(portal.getName());
        TestDataStorage.assertNull((Object)portal);
    }

    public void testRemovePortalWhenNotRemovable() {
        String name = "foo89";
        PortalConfig portal = new PortalConfig();
        portal.setType("portal");
        portal.setName(name);
        portal.setLocale("en");
        portal.setAccessPermissions(new String[]{"Everyone"});
        portal.setRemovable(false);
        this.storage_.create(portal);
        portal = this.storage_.getPortalConfig(portal.getName());
        TestDataStorage.assertNotNull((Object)portal);
        TestDataStorage.assertEquals((String)"portal", (String)portal.getType());
        TestDataStorage.assertEquals((String)name, (String)portal.getName());
        Assert.assertThrows(IllegalStateException.class, () -> this.storage_.remove(this.storage_.getPortalConfig(SiteKey.portal((String)name))));
        portal = this.storage_.getPortalConfig(portal.getName());
        TestDataStorage.assertNotNull((Object)portal);
        portal.setRemovable(true);
        this.storage_.save(portal);
        this.storage_.remove(portal);
        portal = this.storage_.getPortalConfig(portal.getName());
        TestDataStorage.assertNull((Object)portal);
    }

    public void testPortalConfigSave() throws Exception {
        PortalConfig portal = this.storage_.getPortalConfig("portal", "test");
        TestDataStorage.assertNotNull((Object)portal);
        portal.setLocale("vietnam");
        this.storage_.save(portal);
        TestDataStorage.assertEquals((int)1, (int)this.events.size());
        portal = this.storage_.getPortalConfig("portal", "test");
        TestDataStorage.assertNotNull((Object)portal);
        TestDataStorage.assertEquals((String)"vietnam", (String)portal.getLocale());
    }

    public void testPortalConfigRemove() throws Exception {
        String siteName = "testPortalToRemove";
        this.createSite(SiteType.PORTAL, siteName);
        this.restartTransaction();
        PortalConfig portal = this.storage_.getPortalConfig("portal", siteName);
        TestDataStorage.assertNotNull((Object)portal);
        this.storage_.remove(portal);
        TestDataStorage.assertEquals((long)1L, (long)this.events.stream().filter(event -> event.getEventName().equals(LayoutService.PORTAL_CONFIG_REMOVED)).count());
        TestDataStorage.assertNull((Object)this.storage_.getPortalConfig("portal", siteName));
        try {
            this.storage_.remove(portal);
            TestDataStorage.fail((String)"was expecting a Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSavePage() throws Exception {
        PortalConfig portal = new PortalConfig();
        portal.setType("portal");
        portal.setName("test2");
        portal.setLocale("en");
        portal.setLabel("Test 2");
        portal.setDescription("Test 2");
        portal.setAccessPermissions(new String[]{"Everyone"});
        this.storage_.create(portal);
        TestDataStorage.assertEquals((int)1, (int)this.events.size());
        String borderColor = "#ff1200";
        String cssClass = "custom-class";
        String height = "20px";
        String width = "30px";
        Page page = new Page();
        page.setOwnerType(PortalConfig.PORTAL_TYPE);
        page.setOwnerId(portal.getName());
        page.setName("foo");
        page.setShowMaxWindow(Boolean.valueOf(false));
        page.setHideSharedLayout(false);
        Container container = new Container();
        container.setTemplate("test");
        container.setHeight(height);
        container.setWidth(width);
        container.setCssClass(cssClass);
        page.setChildren(new ArrayList<Container>(Collections.singletonList(container)));
        Application application = new Application();
        application.setHeight(height);
        application.setWidth(width);
        application.setCssClass(cssClass);
        application.setState((ApplicationState)new TransientApplicationState("test/test", null));
        container.setChildren(new ArrayList<Application>(Collections.singletonList(application)));
        try {
            this.storage_.save(page);
            TestDataStorage.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pageService.savePage(new PageContext(page.getPageKey(), null));
        TestDataStorage.assertEquals((int)2, (int)this.events.size());
        PageContext pageContext = this.pageService.loadPage(page.getPageKey());
        PageState.Builder pageStateBuilder = pageContext.getState().builder().displayName("MyTitle").showMaxWindow(true).hideSharedLayout(true);
        pageContext.setState(pageStateBuilder.build());
        this.pageService.savePage(pageContext);
        Page page2 = this.storage_.getPage(page.getPageId());
        page2.setTitle("MyTitle2");
        this.storage_.save(page2);
        TestDataStorage.assertEquals((int)3, (int)this.events.size());
        this.pageService.save(page.build());
        page2 = this.storage_.getPage(page.getPageId());
        TestDataStorage.assertNotNull((Object)page2);
        TestDataStorage.assertEquals((String)("portal::" + portal.getName() + "::foo"), (String)page2.getPageId());
        TestDataStorage.assertEquals((String)"portal", (String)page2.getOwnerType());
        TestDataStorage.assertEquals((String)portal.getName(), (String)page2.getOwnerId());
        TestDataStorage.assertEquals((String)"foo", (String)page2.getName());
        TestDataStorage.assertEquals((int)1, (int)page2.getChildren().size());
        ModelObject childObject = (ModelObject)page2.getChildren().get(0);
        TestDataStorage.assertEquals((String)height, (String)childObject.getHeight());
        TestDataStorage.assertEquals((String)width, (String)childObject.getWidth());
        TestDataStorage.assertEquals((String)cssClass, (String)childObject.getCssClass());
        childObject = (ModelObject)((Container)childObject).getChildren().get(0);
        TestDataStorage.assertEquals((String)height, (String)childObject.getHeight());
        TestDataStorage.assertEquals((String)width, (String)childObject.getWidth());
        TestDataStorage.assertEquals((String)cssClass.trim(), (String)childObject.getCssClass().trim());
        pageContext = this.pageService.loadPage(page.getPageKey());
        TestDataStorage.assertEquals((String)"MyTitle", (String)pageContext.getState().getDisplayName());
        TestDataStorage.assertEquals((boolean)true, (boolean)pageContext.getState().isShowMaxWindow());
        TestDataStorage.assertEquals((boolean)true, (boolean)pageContext.getState().isHideSharedLayout());
    }

    public void testSaveOutdatedPage() throws Exception {
        PortalConfig portal = new PortalConfig();
        portal.setType("portal");
        portal.setName("test" + new Random().nextInt());
        portal.setLocale("en");
        portal.setLabel("Test Random Site");
        portal.setDescription("Test Random Site");
        portal.setAccessPermissions(new String[]{"Everyone"});
        this.storage_.create(portal);
        Page page = new Page();
        page.setOwnerType(PortalConfig.PORTAL_TYPE);
        page.setOwnerId(portal.getName());
        page.setName("foo");
        Application application = new Application();
        application.setState((ApplicationState)new TransientApplicationState("test/test", null));
        page.setChildren(new ArrayList<Application>(Collections.singletonList(application)));
        this.pageService.savePage(new PageContext(page.getPageKey(), null));
        this.storage_.save(page);
        page = this.storage_.getPage(page.getPageKey());
        application = (Application)page.getChildren().get(0);
        TestDataStorage.assertNotNull((Object)application.getStorageId());
        application.resetStorage();
        TestDataStorage.assertNull((Object)application.getStorageId());
        application.checkStorage();
        page = this.storage_.getPage(page.getPageKey());
        Application storedApplication = (Application)page.getChildren().get(0);
        page.setChildren(new ArrayList());
        this.storage_.save(page);
        Assert.assertThrows(ObjectNotFoundException.class, () -> ((Application)storedApplication).resetStorage());
        Assert.assertThrows(ObjectNotFoundException.class, () -> ((Application)storedApplication).checkStorage());
    }

    public void testChangingPortletThemeInPage() throws Exception {
        Page page = this.storage_.getPage("portal::classic::homepage");
        Application app = (Application)page.getChildren().get(0);
        TestDataStorage.assertEquals((int)1, (int)page.getChildren().size());
        app.setTheme("Theme1");
        this.storage_.save(page);
        page = this.storage_.getPage("portal::classic::homepage");
        app = (Application)page.getChildren().get(0);
        TestDataStorage.assertEquals((String)"Theme1", (String)app.getTheme());
        app.setTheme("Theme2");
        this.storage_.save(page);
        page = this.storage_.getPage("portal::classic::homepage");
        app = (Application)page.getChildren().get(0);
        TestDataStorage.assertEquals((String)"Theme2", (String)app.getTheme());
    }

    public void testWindowMove2() throws Exception {
        Page page = this.storage_.getPage("portal::test::test3");
        Container container = new Container();
        Application application = (Application)page.getChildren().remove(0);
        container.getChildren().add(application);
        page.getChildren().add(container);
        this.storage_.save(page);
        Page page2 = this.storage_.getPage("portal::test::test3");
        TestDataStorage.assertEquals((int)1, (int)page2.getChildren().size());
        Container container2 = (Container)page2.getChildren().get(0);
        TestDataStorage.assertEquals((int)1, (int)page2.getChildren().size());
        Application application2 = (Application)container2.getChildren().get(0);
        TestDataStorage.assertEquals((String)application2.getStorageId(), (String)application.getStorageId());
    }

    public void testWindowMove3() throws Exception {
        TestDataStorage.assertNull((Object)this.storage_.getPage("portal::test::testWindowMove3"));
        Page page = new Page();
        page.setOwnerType(PortalConfig.PORTAL_TYPE);
        page.setOwnerId("test");
        page.setName("testWindowMove3");
        Application app1 = new Application();
        app1.setState((ApplicationState)new TransientApplicationState());
        Application app2 = new Application();
        app2.setState((ApplicationState)new TransientApplicationState());
        Container parentOfApp2 = new Container();
        parentOfApp2.getChildren().add(app2);
        page.getChildren().add(app1);
        page.getChildren().add(parentOfApp2);
        this.pageService.savePage(new PageContext(page.getPageKey(), null));
        this.storage_.save(page);
        Page page2 = this.storage_.getPage("portal::test::testWindowMove3");
        TestDataStorage.assertNotNull((Object)page2);
        TestDataStorage.assertTrue((boolean)(page2.getChildren().get(1) instanceof Container));
        Container container = (Container)page2.getChildren().get(1);
        TestDataStorage.assertTrue((boolean)(container.getChildren().get(0) instanceof Application));
        Application persistedApp2 = (Application)container.getChildren().remove(0);
        Container transientContainer = new Container();
        transientContainer.getChildren().add(persistedApp2);
        page2.getChildren().add(transientContainer);
        this.storage_.save(page2);
        Page page3 = this.storage_.getPage("portal::test::testWindowMove3");
        TestDataStorage.assertEquals((String)container.getStorageId(), (String)((ModelObject)page3.getChildren().get(1)).getStorageId());
        TestDataStorage.assertTrue((boolean)(page3.getChildren().get(2) instanceof Container));
        Container formerTransientCont = (Container)page3.getChildren().get(2);
        TestDataStorage.assertEquals((int)1, (int)formerTransientCont.getChildren().size());
        TestDataStorage.assertTrue((boolean)(formerTransientCont.getChildren().get(0) instanceof Application));
        TestDataStorage.assertEquals((String)persistedApp2.getStorageId(), (String)((ModelObject)formerTransientCont.getChildren().get(0)).getStorageId());
    }

    public void testNullPageReferenceDeletes() throws Exception {
        PortalConfig portal = new PortalConfig();
        portal.setName("foo");
        portal.setLocale("en");
        portal.setAccessPermissions(new String[]{"Everyone"});
        this.storage_.create(portal);
        Page page = new Page();
        page.setOwnerType(PortalConfig.PORTAL_TYPE);
        page.setOwnerId("test");
        page.setName("foo");
        this.pageService.savePage(new PageContext(page.getPageKey(), null));
        NavigationContext nav = new NavigationContext(SiteKey.portal((String)"foo"), new NavigationState(Integer.valueOf(0)));
        this.navService.saveNavigation(nav);
        NodeContext node = this.navService.loadNode(NodeModel.SELF_MODEL, nav, Scope.CHILDREN, null);
        NodeContext test = node.add(null, "testPage");
        test.setState(test.getState().builder().pageRef(page.getPageKey()).build());
        this.navService.saveNode(node, null);
        NodeContext pageNavigationWithPageReference = this.navService.loadNode(NodeModel.SELF_MODEL, nav, Scope.CHILDREN, null);
        TestDataStorage.assertNotNull((String)"Expected page reference should not be null.", (Object)((NodeContext)pageNavigationWithPageReference.get(0)).getState().getPageRef());
        test.setState(test.getState().builder().pageRef(null).build());
        this.navService.saveNode(node, null);
        NodeContext pageNavigationWithoutPageReference = this.navService.loadNode(NodeModel.SELF_MODEL, nav, Scope.CHILDREN, null);
        TestDataStorage.assertNull((String)"Expected page reference should be null.", (Object)((NodeContext)pageNavigationWithoutPageReference.get(0)).getState().getPageRef());
    }

    public void testWindowScopedPortletPreferences() throws Exception {
        Page page = new Page();
        page.setPageId("portal::test::foo");
        TransientApplicationState state = new TransientApplicationState("web/BannerPortlet", new PortletBuilder().add("template", "bar").build());
        Application app = Application.createPortletApplication();
        app.setState((ApplicationState)state);
        page.getChildren().add(app);
        this.pageService.savePage(new PageContext(page.getPageKey(), null));
        this.storage_.save(page);
        page = this.storage_.getPage(page.getPageId());
        app = (Application)page.getChildren().get(0);
        TestDataStorage.assertEquals((String)"web/BannerPortlet", (String)this.storage_.getId(app.getState()));
    }

    public void testPageMerge() throws Exception {
        Page page = this.storage_.getPage("portal::test::test4");
        String app1Id = ((ModelObject)page.getChildren().get(0)).getStorageId();
        Container container = (Container)page.getChildren().get(1);
        String containerId = container.getStorageId();
        String app2Id = ((ModelObject)container.getChildren().get(0)).getStorageId();
        String app3Id = ((ModelObject)container.getChildren().get(1)).getStorageId();
        Application groovyApp = Application.createPortletApplication();
        TransientApplicationState state = new TransientApplicationState("web/GroovyPortlet");
        groovyApp.setState((ApplicationState)state);
        ((Container)page.getChildren().get(1)).getChildren().add(1, groovyApp);
        this.storage_.save(page);
        page = this.storage_.getPage("portal::test::test4");
        TestDataStorage.assertEquals((int)2, (int)page.getChildren().size());
        TestDataStorage.assertEquals((String)app1Id, (String)((ModelObject)page.getChildren().get(0)).getStorageId());
        container = (Container)page.getChildren().get(1);
        TestDataStorage.assertEquals((int)3, (int)container.getChildren().size());
        TestDataStorage.assertEquals((String)containerId, (String)container.getStorageId());
        TestDataStorage.assertEquals((String)app2Id, (String)((ModelObject)container.getChildren().get(0)).getStorageId());
        TestDataStorage.assertNotNull((Object)((ModelObject)container.getChildren().get(0)).getStorageId());
        TestDataStorage.assertEquals((String)app3Id, (String)((ModelObject)container.getChildren().get(2)).getStorageId());
        container.getChildren().remove(1);
        this.storage_.save(page);
        page = this.storage_.getPage("portal::test::test4");
        TestDataStorage.assertEquals((int)2, (int)page.getChildren().size());
        TestDataStorage.assertEquals((String)app1Id, (String)((ModelObject)page.getChildren().get(0)).getStorageId());
        container = (Container)page.getChildren().get(1);
        TestDataStorage.assertEquals((int)2, (int)container.getChildren().size());
        TestDataStorage.assertEquals((String)containerId, (String)container.getStorageId());
        TestDataStorage.assertEquals((String)app2Id, (String)((ModelObject)container.getChildren().get(0)).getStorageId());
        TestDataStorage.assertEquals((String)app3Id, (String)((ModelObject)container.getChildren().get(1)).getStorageId());
    }

    public void testClone() throws Exception {
        Page page = this.storage_.getPage("portal::test::test5");
        TestDataStorage.assertEquals((int)2, (int)page.getChildren().size());
        Application banner1 = (Application)page.getChildren().get(0);
        ApplicationState instanceId = banner1.getState();
        TestDataStorage.assertEquals((String)"web/BannerPortlet", (String)this.storage_.getId(banner1.getState()));
        Portlet pagePrefs = this.storage_.load(instanceId);
        TestDataStorage.assertEquals((Object)new PortletBuilder().add("template", "par:/groovy/groovy/webui/component/UIBannerPortlet.gtmpl").build(), (Object)pagePrefs);
        TestDataStorage.assertEquals((Object)new PortletBuilder().add("template", "par:/groovy/groovy/webui/component/UIBannerPortlet.gtmpl").build(), (Object)pagePrefs);
        this.pageService.clone(PageKey.parse((String)"portal::test::test5"), PageKey.parse((String)"portal::test::_test4"));
        Page clone = this.storage_.getPage("portal::test::_test4");
        TestDataStorage.assertEquals((int)2, (int)clone.getChildren().size());
        banner1 = (Application)clone.getChildren().get(0);
        instanceId = banner1.getState();
        TestDataStorage.assertEquals((String)"web/BannerPortlet", (String)this.storage_.getId(banner1.getState()));
        pagePrefs = this.storage_.load(instanceId);
        TestDataStorage.assertEquals((Object)new PortletBuilder().add("template", "par:/groovy/groovy/webui/component/UIBannerPortlet.gtmpl").build(), (Object)pagePrefs);
        pagePrefs.setValue("template", "foo");
        this.storage_.save(instanceId, pagePrefs);
        pagePrefs = this.storage_.load(instanceId);
        TestDataStorage.assertEquals((Object)new PortletBuilder().add("template", "foo").build(), (Object)pagePrefs);
        Container container = (Container)clone.getChildren().get(1);
        TestDataStorage.assertEquals((int)2, (int)container.getChildren().size());
        Page srcPage = this.storage_.getPage("portal::test::test4");
        PageContext srcPageContext = this.pageService.loadPage(srcPage.getPageKey());
        srcPageContext.setState(srcPageContext.getState().builder().editPermission("Administrator").build());
        this.pageService.savePage(srcPageContext);
        Application portlet = (Application)srcPage.getChildren().get(0);
        portlet.setDescription("NewPortlet");
        ArrayList modelObject = srcPage.getChildren();
        modelObject.set(0, portlet);
        srcPage.setChildren(modelObject);
        this.storage_.save(srcPage);
        PageKey dstKey = PageKey.parse((String)(srcPage.getOwnerType() + "::" + srcPage.getOwnerId() + "::_PageTest1234"));
        PageContext dstPageContext = this.pageService.clone(srcPageContext.getKey(), dstKey);
        Page dstPage = this.storage_.getPage(dstKey.format());
        Application portlet1 = (Application)dstPage.getChildren().get(0);
        TestDataStorage.assertNotNull((Object)dstPageContext.getState().getEditPermission());
        TestDataStorage.assertEquals((String)srcPageContext.getState().getEditPermission(), (String)dstPageContext.getState().getEditPermission());
        TestDataStorage.assertNotNull((Object)portlet1.getDescription());
        TestDataStorage.assertEquals((String)portlet.getDescription(), (String)portlet1.getDescription());
    }

    public void testSiteScopedPreferences() throws Exception {
        Page page = this.storage_.getPage("portal::test::test4");
        Application app = (Application)page.getChildren().get(0);
        PersistentApplicationState state = (PersistentApplicationState)app.getState();
        Portlet prefs = this.storage_.load((ApplicationState)state);
        prefs.setValue("template", "someanothervalue");
        this.storage_.save((ApplicationState)state, prefs);
        prefs = this.storage_.load((ApplicationState)state);
        TestDataStorage.assertNotNull((Object)prefs);
        TestDataStorage.assertEquals((Object)new PortletBuilder().add("template", "someanothervalue").build(), (Object)prefs);
    }

    public void testNullPreferenceValue() throws Exception {
        Page page = this.storage_.getPage("portal::test::test4");
        Application app = (Application)page.getChildren().get(0);
        PersistentApplicationState state = (PersistentApplicationState)app.getState();
        Portlet prefs = new Portlet();
        prefs.setValue("template", "initialvalue");
        this.storage_.save((ApplicationState)state, prefs);
        prefs.setValue("template", null);
        this.storage_.save((ApplicationState)state, prefs);
        prefs = this.storage_.load((ApplicationState)state);
        TestDataStorage.assertNotNull((Object)prefs);
        TestDataStorage.assertEquals((Object)new PortletBuilder().add("template", (String)null).build(), (Object)prefs);
    }

    public void testSiteLayout() throws Exception {
        PortalConfig pConfig = this.storage_.getPortalConfig(PortalConfig.PORTAL_TYPE, "classic");
        TestDataStorage.assertNotNull((Object)pConfig);
        TestDataStorage.assertNotNull((String)("The Group layout of " + pConfig.getName() + " is null"), (Object)pConfig.getPortalLayout());
    }

    public void testGroupLayout() throws Exception {
        GroupHandler groupHandler = this.org.getGroupHandler();
        Group group = groupHandler.findGroupById("groupTest");
        TestDataStorage.assertNull((Object)group);
        group = groupHandler.createGroupInstance();
        group.setGroupName("groupTest");
        group.setLabel("group test label");
        groupHandler.addChild(null, group, true);
        group = groupHandler.findGroupById("/groupTest");
        TestDataStorage.assertNotNull((Object)group);
        PortalConfig pConfig = new PortalConfig(PortalConfig.GROUP_TYPE, "/groupTest");
        this.storage_.create(pConfig);
        pConfig = this.storage_.getPortalConfig(PortalConfig.GROUP_TYPE, "/groupTest");
        TestDataStorage.assertNotNull((String)"the Group's PortalConfig is not null", (Object)pConfig);
        groupHandler.removeGroup(group, false);
        group = groupHandler.findGroupById("/groupTest");
        TestDataStorage.assertNull((Object)group);
        group = groupHandler.createGroupInstance();
        group.setGroupName("groupSite");
        group.setLabel("group site label");
        groupHandler.addChild(null, group, true);
        group = groupHandler.findGroupById("/groupSite");
        TestDataStorage.assertNotNull((Object)group);
        pConfig = this.storage_.getPortalConfig(PortalConfig.GROUP_TYPE, "/groupSite");
        TestDataStorage.assertNull((String)"the Group's PortalConfig is null", (Object)pConfig);
        groupHandler.removeGroup(group, false);
        group = groupHandler.findGroupById("/groupSite");
        TestDataStorage.assertNull((Object)group);
    }

    protected void createSite(SiteType type, String siteName) throws Exception {
        ContainerData container = new ContainerData(null, "testcontainer_" + siteName, "", "", "", "", "", "", "", "", "", "", null, null, Collections.emptyList(), Collections.emptyList());
        PortalData portal = new PortalData(null, siteName, type.getName(), null, null, null, new ArrayList(), null, null, null, container, true, 5, 0L);
        this.modelStorage.create(portal);
        NavigationContext nav = new NavigationContext(type.key(siteName), new NavigationState(Integer.valueOf(1)));
        this.navService.saveNavigation(nav);
        this.restartTransaction();
    }
}

