/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.account.setup.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.exoplatform.account.setup.web.AccountSetupService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.security.Credentials;

public class AccountSetup
extends HttpServlet {
    private static final Log LOG = ExoLogger.getLogger(AccountSetup.class);
    private static final long serialVersionUID = 6467955354840693802L;
    private static final String USER_NAME_ACCOUNT = "username";
    private static final String FIRST_NAME_ACCOUNT = "firstNameAccount";
    private static final String LAST_NAME_ACCOUNT = "lastNameAccount";
    private static final String EMAIL_ACCOUNT = "emailAccount";
    private static final String USER_PASSWORD_ACCOUNT = "password";
    private static final String ADMIN_PASSWORD = "adminPassword";
    private static final String INITIAL_URI_PARAM = "initialURI";
    private static final String ACCOUNT_SETUP_BUTTON = "setupbutton";
    private static final String SETUP_SKIP_BUTTON = "skipform";
    private AccountSetupService accountSetupService = (AccountSetupService)PortalContainer.getInstance().getComponentInstanceOfType(AccountSetupService.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectURI;
        String accountsetupbutton = request.getParameter(ACCOUNT_SETUP_BUTTON);
        if (accountsetupbutton.equals(SETUP_SKIP_BUTTON) || this.accountSetupService.mustSkipAccountSetup()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Direct access to Account Setup Form.");
            }
            this.accountSetupService.setSkipSetup(true);
            redirectURI = "/" + PortalContainer.getCurrentPortalContainerName();
        } else {
            String userNameAccount = request.getParameter(USER_NAME_ACCOUNT);
            String firstNameAccount = request.getParameter(FIRST_NAME_ACCOUNT);
            String lastNameAccount = request.getParameter(LAST_NAME_ACCOUNT);
            String emailAccount = request.getParameter(EMAIL_ACCOUNT);
            String userPasswordAccount = request.getParameter(USER_PASSWORD_ACCOUNT);
            String adminPassword = request.getParameter(ADMIN_PASSWORD);
            this.accountSetupService.createAccount(userNameAccount, firstNameAccount, lastNameAccount, emailAccount, userPasswordAccount, adminPassword);
            HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(this, request){

                public String getContextPath() {
                    return "/portal";
                }
            };
            Credentials credentials = new Credentials(userNameAccount, userPasswordAccount);
            ServletContainerFactory.getServletContainer().login((HttpServletRequest)wrappedRequest, response, credentials);
            redirectURI = "/" + PortalContainer.getCurrentPortalContainerName();
        }
        response.setCharacterEncoding("UTF-8");
        response.sendRedirect(redirectURI);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

