/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.mop.dao.AbstractDAOTest;
import org.exoplatform.portal.mop.dao.PermissionDAO;

public class PermissionDAOTest
extends AbstractDAOTest {
    private PermissionDAO permissionDAO;

    @Override
    protected void setUp() throws Exception {
        this.begin();
        super.setUp();
        this.permissionDAO = (PermissionDAO)this.getContainer().getComponentInstanceOfType(PermissionDAO.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.permissionDAO.deleteAll();
        super.tearDown();
        this.end();
    }

    public void testCreate() {
        PermissionEntity per1 = new PermissionEntity("type1", 1L, "per1", PermissionEntity.TYPE.ACCESS);
        this.permissionDAO.create((Object)per1);
        this.restartTransaction();
        PermissionEntity expected = (PermissionEntity)this.permissionDAO.find((Serializable)per1.getId());
        PermissionDAOTest.assertNotNull((Object)expected);
        this.assertPermission(expected, per1);
    }

    public void testGet() {
        PermissionEntity per1 = new PermissionEntity("type1", 1L, "per1", PermissionEntity.TYPE.ACCESS);
        this.permissionDAO.create((Object)per1);
        PermissionEntity per2 = new PermissionEntity("type2", 2L, "per2", PermissionEntity.TYPE.EDIT);
        this.permissionDAO.create((Object)per2);
        this.restartTransaction();
        List result1 = this.permissionDAO.getPermissions("type1", Long.valueOf(1L), PermissionEntity.TYPE.ACCESS);
        PermissionDAOTest.assertEquals((int)1, (int)result1.size());
        this.assertPermission(per1, (PermissionEntity)result1.get(0));
        List result2 = this.permissionDAO.getPermissions("type2", Long.valueOf(2L), PermissionEntity.TYPE.EDIT);
        PermissionDAOTest.assertEquals((int)1, (int)result2.size());
        this.assertPermission(per2, (PermissionEntity)result2.get(0));
    }

    public void testDelete() {
        PermissionEntity per1 = new PermissionEntity("type1", 1L, "per1", PermissionEntity.TYPE.ACCESS);
        this.permissionDAO.create((Object)per1);
        PermissionEntity per2 = new PermissionEntity("type1", 1L, "per2", PermissionEntity.TYPE.EDIT);
        this.permissionDAO.create((Object)per2);
        PermissionEntity per3 = new PermissionEntity("type3", 3L, "per3", PermissionEntity.TYPE.EDIT);
        this.permissionDAO.create((Object)per3);
        this.restartTransaction();
        int deleted = this.permissionDAO.deletePermissions("type1", Long.valueOf(1L));
        PermissionDAOTest.assertEquals((int)2, (int)deleted);
        PermissionDAOTest.assertEquals((int)1, (int)this.permissionDAO.findAll().size());
    }

    public void testSave() {
        PermissionEntity per1 = new PermissionEntity("type1", 1L, "per1", PermissionEntity.TYPE.ACCESS);
        this.permissionDAO.create((Object)per1);
        PermissionEntity per2 = new PermissionEntity("type1", 1L, "per2", PermissionEntity.TYPE.ACCESS);
        this.permissionDAO.create((Object)per2);
        PermissionEntity per3 = new PermissionEntity("type1", 1L, "per3", PermissionEntity.TYPE.ACCESS);
        this.permissionDAO.create((Object)per3);
        this.restartTransaction();
        List results = this.permissionDAO.savePermissions("type1", Long.valueOf(1L), PermissionEntity.TYPE.ACCESS, Arrays.asList("per1", "per4"));
        PermissionDAOTest.assertEquals((int)2, (int)results.size());
        PermissionDAOTest.assertTrue((boolean)results.remove(per1));
        PermissionDAOTest.assertEquals((String)"per4", (String)((PermissionEntity)results.get(0)).getPermission());
        PermissionDAOTest.assertNull((Object)this.permissionDAO.find((Serializable)per2.getId()));
        PermissionDAOTest.assertNull((Object)this.permissionDAO.find((Serializable)per3.getId()));
    }

    private void assertPermission(PermissionEntity expected, PermissionEntity entity) {
        PermissionDAOTest.assertEquals((String)expected.getPermission(), (String)entity.getPermission());
        PermissionDAOTest.assertEquals((Object)expected.getReferenceId(), (Object)entity.getReferenceId());
        PermissionDAOTest.assertEquals((Object)expected.getId(), (Object)entity.getId());
        PermissionDAOTest.assertEquals((Object)expected.getType(), (Object)entity.getType());
    }
}

