/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.HierarchyError;
import org.exoplatform.portal.mop.navigation.HierarchyException;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationError;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.Node;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.SiteStorage;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.PortalData;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/mop/navigation/configuration.xml")})
public class TestNavigationServiceRebase
extends AbstractKernelTest {
    protected NavigationService service;
    private SiteStorage modelStorage;

    protected void setUp() throws Exception {
        super.setUp();
        PortalContainer container = PortalContainer.getInstance();
        this.service = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.modelStorage = (SiteStorage)container.getComponentInstanceOfType(SiteStorage.class);
        this.begin();
    }

    protected void createSite(SiteType type, String siteName) throws Exception {
        ContainerData container = new ContainerData(null, "testcontainer_" + siteName, "", "", "", "", "", "", "", "", "", "", null, null, Collections.emptyList(), Collections.emptyList());
        PortalData portal = new PortalData(null, siteName, type.getName(), null, null, null, new ArrayList(), null, null, null, container, true, 11, 0L);
        this.modelStorage.create(portal);
        this.restartTransaction();
    }

    protected void createNavigation(SiteType siteType, String siteName) throws Exception {
        this.createSite(siteType, siteName);
        this.service.saveNavigation(new NavigationContext(new SiteKey(siteType, siteName), new NavigationState(Integer.valueOf(1))));
    }

    public void testRebase1() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase1");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase1"));
        NodeContext root1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        root1.add(null, "a");
        root1.add(null, "d");
        this.service.saveNode(root1, null);
        this.restartTransaction();
        root1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        NodeContext a = root1.get("a");
        NodeContext d = root1.get("d");
        NodeContext b = root1.add(Integer.valueOf(1), "b");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node c2 = root2.addChild(1, "c");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        this.service.rebaseNode(root1, null, null);
        TestNavigationServiceRebase.assertEquals((int)4, (int)root1.getNodeCount());
        TestNavigationServiceRebase.assertSame((Object)a.getNode(), (Object)root1.getNode(0));
        TestNavigationServiceRebase.assertSame((Object)b.getNode(), (Object)root1.getNode(1));
        Node c1 = (Node)root1.getNode(2);
        TestNavigationServiceRebase.assertEquals((String)"c", (String)c1.getName());
        TestNavigationServiceRebase.assertEquals((String)c2.getId(), (String)c1.getId());
        TestNavigationServiceRebase.assertSame((Object)d.getNode(), (Object)root1.getNode(3));
    }

    public void testRebase2() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase2");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase2"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        rootContext1.add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node a = root1.getChild("a");
        Node b = root1.getChild("b");
        Node c = a.addChild("c");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.getChild("b").addChild(root2.getChild("a"));
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        this.service.rebaseNode(root1.getContext(), null, null);
        TestNavigationServiceRebase.assertEquals(null, (Object)root1.getChild("a"));
        TestNavigationServiceRebase.assertSame((Object)b, (Object)root1.getChild("b"));
        TestNavigationServiceRebase.assertEquals((Object)root1, (Object)b.getParent());
        TestNavigationServiceRebase.assertSame((Object)a, (Object)b.getChild("a"));
        TestNavigationServiceRebase.assertEquals((Object)b, (Object)a.getParent());
        TestNavigationServiceRebase.assertSame((Object)c, (Object)a.getChild("c"));
        TestNavigationServiceRebase.assertEquals((Object)a, (Object)c.getParent());
    }

    public void testRebase3() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase3");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase3"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        rootContext1.add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root.getChild("a").addChild("foo");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.removeChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.rebaseNode(root.getContext(), null, null);
            TestNavigationServiceRebase.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceRebase.assertEquals((Object)NavigationError.ADD_CONCURRENTLY_REMOVED_PARENT_NODE, (Object)e.getError());
        }
    }

    public void testRebase4() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase4");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase4"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root.addChild(root.getChild("a").getChild("b"));
        root.removeChild("a");
        this.service.rebaseNode(root.getContext(), null, null);
    }

    public void testRebaseAddDuplicate() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase_add_duplicate");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase_add_duplicate"));
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root.addChild("a");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.addChild("a");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.rebaseNode(root.getContext(), null, null);
            TestNavigationServiceRebase.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceRebase.assertEquals((Object)NavigationError.ADD_CONCURRENTLY_ADDED_NODE, (Object)e.getError());
        }
    }

    public void testRebaseMoveDuplicate() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase_move_duplicate");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase_move_duplicate"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root.addChild(root.getChild("a").getChild("b"));
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.addChild("b");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.rebaseNode(root.getContext(), null, null);
            TestNavigationServiceRebase.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceRebase.assertEquals((Object)NavigationError.MOVE_CONCURRENTLY_DUPLICATE_NAME, (Object)e.getError());
        }
    }

    public void testRebaseRenameDuplicate() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase_rename_duplicate");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase_rename_duplicate"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root.getChild("a").setName("b");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.addChild("b");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        try {
            this.service.rebaseNode(root.getContext(), null, null);
            TestNavigationServiceRebase.fail();
        }
        catch (NavigationServiceException e) {
            TestNavigationServiceRebase.assertEquals((Object)NavigationError.RENAME_CONCURRENTLY_DUPLICATE_NAME, (Object)e.getError());
        }
    }

    public void testFederation() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase_federation");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase_federation"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a").add(null, "b");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root1 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        Node a = root1.getChild("a");
        Node c = root1.addChild("c");
        Node root2 = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        root2.addChild("d").addChild("e");
        this.service.saveNode(root2.getContext(), null);
        this.restartTransaction();
        Iterator<NodeChange<Node>> changes = a.rebase(this.service, Scope.CHILDREN);
        Iterator<Node> children = root1.getChildren().iterator();
        TestNavigationServiceRebase.assertSame((Object)a, (Object)children.next());
        TestNavigationServiceRebase.assertSame((Object)c, (Object)children.next());
        Node d = children.next();
        TestNavigationServiceRebase.assertEquals((String)"d", (String)d.getName());
        TestNavigationServiceRebase.assertFalse((boolean)children.hasNext());
        TestNavigationServiceRebase.assertFalse((boolean)d.getContext().isExpanded());
        children = a.getChildren().iterator();
        Node b = children.next();
        TestNavigationServiceRebase.assertEquals((String)"b", (String)b.getName());
        TestNavigationServiceRebase.assertFalse((boolean)children.hasNext());
        TestNavigationServiceRebase.assertFalse((boolean)b.getContext().isExpanded());
        NodeChange.Added added1 = (NodeChange.Added)changes.next();
        TestNavigationServiceRebase.assertSame((Object)b, (Object)added1.getTarget());
        TestNavigationServiceRebase.assertSame(null, (Object)added1.getPrevious());
        TestNavigationServiceRebase.assertSame((Object)a, (Object)added1.getParent());
        NodeChange.Added added2 = (NodeChange.Added)changes.next();
        TestNavigationServiceRebase.assertSame((Object)d, (Object)added2.getTarget());
        TestNavigationServiceRebase.assertSame((Object)c, (Object)added2.getPrevious());
        TestNavigationServiceRebase.assertSame((Object)root1, (Object)added2.getParent());
        TestNavigationServiceRebase.assertFalse((boolean)changes.hasNext());
    }

    public void testTransientParent() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase_transient_parent");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase_transient_parent"));
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.CHILDREN, null).getNode();
        Node a = root.addChild("a");
        Node b = root.addChild("b");
        this.service.rebaseNode(a.getContext(), Scope.CHILDREN, null);
    }

    public void testRemovedNavigation() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase_removed_navigation");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase_removed_navigation"));
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        this.service.destroyNavigation(navigation);
        this.restartTransaction();
        try {
            this.service.rebaseNode(root.getContext(), null, null);
        }
        catch (HierarchyException e) {
            TestNavigationServiceRebase.assertSame((Object)HierarchyError.UPDATE_CONCURRENTLY_REMOVED_NODE, (Object)e.getError());
        }
    }

    public void testStateRebase() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase_state");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase_state"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        NodeState state = new NodeState.Builder().label("foo").build();
        root.getChild("a").setState(state);
        TestNavigationServiceRebase.assertSame((Object)state, (Object)root.getChild("a").getState());
        this.restartTransaction();
        Iterator<NodeChange<Node>> changes = root.rebase(this.service, null);
        TestNavigationServiceRebase.assertFalse((boolean)changes.hasNext());
        TestNavigationServiceRebase.assertSame((Object)state, (Object)root.getChild("a").getState());
    }

    public void testNameRebase() throws Exception {
        this.createNavigation(SiteType.PORTAL, "rebase_name");
        NavigationContext navigation = this.service.loadNavigation(SiteKey.portal((String)"rebase_name"));
        NodeContext rootContext1 = this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null);
        rootContext1.add(null, "a");
        this.service.saveNode(rootContext1, null);
        this.restartTransaction();
        Node root = (Node)this.service.loadNode(Node.MODEL, navigation, Scope.ALL, null).getNode();
        Node a = root.getChild("a");
        a.setName("b");
        TestNavigationServiceRebase.assertSame((Object)"b", (Object)a.getName());
        this.restartTransaction();
        Iterator<NodeChange<Node>> changes = root.rebase(this.service, null);
        TestNavigationServiceRebase.assertFalse((boolean)changes.hasNext());
        TestNavigationServiceRebase.assertSame((Object)"b", (Object)a.getName());
    }
}

