/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.ResourceBundleService;

public class LocaleConfigImpl
implements LocaleConfig {
    private static Map<String, Locale> predefinedLocaleMap_ = null;
    private static ResourceBundleService resourceBundleService;
    private Locale locale_;
    private String outputEncoding_;
    private String inputEncoding_;
    private String description_;
    private String localeName_;
    private String tagIdentifier_;
    private Orientation orientation;
    private ResourceBundle mergedGlobalNavigationBundle = null;

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String desc) {
        this.description_ = desc;
    }

    public String getOutputEncoding() {
        return this.outputEncoding_;
    }

    public void setOutputEncoding(String enc) {
        this.outputEncoding_ = enc;
    }

    public String getInputEncoding() {
        return this.inputEncoding_;
    }

    public void setInputEncoding(String enc) {
        this.inputEncoding_ = enc;
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public void setLocale(Locale locale) {
        this.locale_ = locale;
        if (this.localeName_ == null) {
            this.localeName_ = locale.getLanguage();
        }
    }

    public void setLocale(String localeName) {
        this.localeName_ = localeName;
        this.locale_ = predefinedLocaleMap_.get(localeName);
        if (this.locale_ == null) {
            String[] localeParams = localeName.split("[_-]");
            this.locale_ = localeParams.length > 1 ? new Locale.Builder().setLanguage(localeParams[0]).setRegion(localeParams[1]).build() : new Locale.Builder().setLanguage(localeName).build();
            this.tagIdentifier_ = I18N.toTagIdentifier((Locale)this.locale_);
        }
    }

    public String getTagIdentifier() {
        return this.tagIdentifier_;
    }

    public String getLanguage() {
        return this.locale_.getLanguage();
    }

    public String getLocaleName() {
        return this.localeName_;
    }

    public void setLocaleName(String localeName) {
        this.localeName_ = localeName;
    }

    public ResourceBundle getResourceBundle(String name) {
        return LocaleConfigImpl.getResourceBundleService().getResourceBundle(name, this.locale_);
    }

    public ResourceBundle getMergeResourceBundle(String[] names) {
        return LocaleConfigImpl.getResourceBundleService().getResourceBundle(names, this.locale_);
    }

    public ResourceBundle getNavigationResourceBundle(String ownerType, String ownerId) {
        ResourceBundle resourceBundle = this.getResourceBundle("locale.navigation." + ownerType + "." + ownerId.replaceAll("/", "."));
        if (resourceBundle == null) {
            return this.getMergedNavigationBundle();
        }
        return resourceBundle;
    }

    public void setInput(HttpServletRequest req) throws UnsupportedEncodingException {
        req.setCharacterEncoding(this.inputEncoding_);
    }

    public void setOutput(HttpServletResponse res) {
        res.setContentType("text/html; charset=" + this.outputEncoding_);
        res.setLocale(this.locale_);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public String toString() {
        return "LocaleConfig[localeName=" + this.localeName_ + ",locale=" + String.valueOf(this.locale_) + ",description=" + this.description_ + ",inputEncoding=" + this.inputEncoding_ + ",outputEncoding=" + this.outputEncoding_ + "]";
    }

    private static ResourceBundleService getResourceBundleService() {
        if (resourceBundleService == null) {
            resourceBundleService = (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
        }
        return resourceBundleService;
    }

    private ResourceBundle getMergedNavigationBundle() {
        if (this.mergedGlobalNavigationBundle == null) {
            this.mergedGlobalNavigationBundle = this.getMergeResourceBundle((String[])ArrayUtils.add((Object[])LocaleConfigImpl.getResourceBundleService().getSharedResourceBundleNames(), (Object)"locale.navigation.portal.global"));
        }
        return this.mergedGlobalNavigationBundle;
    }

    @Generated
    public static void setResourceBundleService(ResourceBundleService resourceBundleService) {
        LocaleConfigImpl.resourceBundleService = resourceBundleService;
    }

    static {
        predefinedLocaleMap_ = new HashMap<String, Locale>(10);
        predefinedLocaleMap_.put("us", Locale.US);
        predefinedLocaleMap_.put("en", Locale.ENGLISH);
        predefinedLocaleMap_.put("fr", Locale.FRENCH);
        predefinedLocaleMap_.put("zh", Locale.SIMPLIFIED_CHINESE);
    }
}

