/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.groovyscript.LineBreakItem;
import org.exoplatform.groovyscript.Position;
import org.exoplatform.groovyscript.SectionItem;
import org.exoplatform.groovyscript.SectionType;
import org.exoplatform.groovyscript.TextItem;

public class TemplateSection {
    private final SectionType type;
    private final List<SectionItem> items;

    public TemplateSection(SectionType type, String text) {
        this(type, text, 0, 0);
    }

    public TemplateSection(SectionType type, String text, Position pos) {
        this(type, text, pos.getCol(), pos.getLine());
    }

    public TemplateSection(SectionType type, String text, int colNumber, int lineNumber) {
        String chunk;
        int to;
        if (type == null) {
            throw new NullPointerException();
        }
        if (text == null) {
            throw new NullPointerException();
        }
        ArrayList<SectionItem> sections = new ArrayList<SectionItem>();
        int from = 0;
        while ((to = text.indexOf(10, from)) != -1) {
            chunk = text.substring(from, to);
            sections.add(new TextItem(new Position(colNumber, lineNumber), chunk));
            sections.add(new LineBreakItem(new Position(colNumber + (to - from), lineNumber)));
            from = to + 1;
            ++lineNumber;
            colNumber = 1;
        }
        chunk = text.substring(from);
        sections.add(new TextItem(new Position(colNumber, lineNumber), chunk));
        this.type = type;
        this.items = Collections.unmodifiableList(sections);
    }

    public SectionType getType() {
        return this.type;
    }

    public List<SectionItem> getItems() {
        return this.items;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TemplateSection) {
            TemplateSection that = (TemplateSection)obj;
            return this.type == that.type && this.items.equals(that.items);
        }
        return false;
    }

    public String toString() {
        return "TextSection[type=" + String.valueOf((Object)this.type) + ",text=" + String.valueOf(this.items) + "]";
    }
}

