/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import junit.framework.TestCase;
import org.exoplatform.web.controller.router.Path;

public class TestPath
extends TestCase {
    public void testFoo() throws Exception {
        TestPath.assertEquals((String)"", (String)Path.parse((String)"").getValue());
        TestPath.assertEquals((String)"a", (String)Path.parse((String)"a").getValue());
        TestPath.assertEquals((String)"?", (String)Path.parse((String)"%3F").getValue());
        TestPath.assertEquals((String)" ", (String)Path.parse((String)"%20").getValue());
        TestPath.assertEquals((String)"? ", (String)Path.parse((String)"%3F%20").getValue());
        Path p2 = Path.parse((String)"_");
        TestPath.assertEquals((String)"_", (String)p2.getValue());
        TestPath.assertEquals((int)0, (int)p2.getRawStart(0));
        TestPath.assertEquals((int)1, (int)p2.getRawEnd(0));
        TestPath.assertEquals((int)1, (int)p2.getRawLength(0));
        Path p3 = Path.parse((String)"a%5Fb%5Fc");
        TestPath.assertEquals((String)"a_b_c", (String)p3.getValue());
        TestPath.assertEquals((int)0, (int)p3.getRawStart(0));
        TestPath.assertEquals((int)1, (int)p3.getRawEnd(0));
        TestPath.assertEquals((int)1, (int)p3.getRawLength(0));
        TestPath.assertEquals((int)1, (int)p3.getRawStart(1));
        TestPath.assertEquals((int)4, (int)p3.getRawEnd(1));
        TestPath.assertEquals((int)3, (int)p3.getRawLength(1));
        TestPath.assertEquals((int)4, (int)p3.getRawStart(2));
        TestPath.assertEquals((int)5, (int)p3.getRawEnd(2));
        TestPath.assertEquals((int)1, (int)p3.getRawLength(2));
        TestPath.assertEquals((int)5, (int)p3.getRawStart(3));
        TestPath.assertEquals((int)8, (int)p3.getRawEnd(3));
        TestPath.assertEquals((int)3, (int)p3.getRawLength(3));
        TestPath.assertEquals((int)8, (int)p3.getRawStart(4));
        TestPath.assertEquals((int)9, (int)p3.getRawEnd(4));
        TestPath.assertEquals((int)1, (int)p3.getRawLength(4));
        Path p4 = p3.subPath(2);
        TestPath.assertEquals((int)0, (int)p4.getRawStart(0));
        TestPath.assertEquals((int)1, (int)p4.getRawEnd(0));
        TestPath.assertEquals((int)1, (int)p4.getRawLength(0));
        TestPath.assertEquals((int)1, (int)p4.getRawStart(1));
        TestPath.assertEquals((int)4, (int)p4.getRawEnd(1));
        TestPath.assertEquals((int)3, (int)p4.getRawLength(1));
        TestPath.assertEquals((int)4, (int)p4.getRawStart(2));
        TestPath.assertEquals((int)5, (int)p4.getRawEnd(2));
        TestPath.assertEquals((int)1, (int)p4.getRawLength(2));
    }

    public void testOtherChar() {
        this.assertInvalid("\u00e9");
    }

    public void testPercent1() {
        Path path = Path.parse((String)"%5F");
        TestPath.assertEquals((String)"_", (String)path.getValue());
        TestPath.assertEquals((int)0, (int)path.getRawStart(0));
        TestPath.assertEquals((int)3, (int)path.getRawEnd(0));
        TestPath.assertEquals((int)3, (int)path.getRawLength(0));
    }

    public void testPercent2() {
        Path path = Path.parse((String)"%C2%A2");
        TestPath.assertEquals((int)1, (int)path.length());
        TestPath.assertEquals((char)'\u00a2', (char)path.charAt(0));
        TestPath.assertEquals((int)0, (int)path.getRawStart(0));
        TestPath.assertEquals((int)6, (int)path.getRawEnd(0));
        TestPath.assertEquals((int)6, (int)path.getRawLength(0));
    }

    public void testPercent3() {
        Path path = Path.parse((String)"%E2%82%AC");
        TestPath.assertEquals((int)1, (int)path.length());
        TestPath.assertEquals((char)'\u20ac', (char)path.charAt(0));
        TestPath.assertEquals((int)0, (int)path.getRawStart(0));
        TestPath.assertEquals((int)9, (int)path.getRawEnd(0));
        TestPath.assertEquals((int)9, (int)path.getRawLength(0));
    }

    public void testInvalid() {
        this.assertInvalid("%");
        this.assertInvalid("%1z");
        this.assertInvalid("%C2_A2");
        this.assertInvalid("%C2%A");
        this.assertInvalid("%FF");
    }

    private void assertInvalid(String s) {
        try {
            Path.parse((String)s);
            TestPath.fail((String)("Was expecting " + s + " to be invalid"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

