/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.HashMap;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.AbstractTestController;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.Router;

public class TestPortalConfiguration
extends AbstractTestController {
    private Router router;

    protected void setUp() throws Exception {
        this.router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/private/{gtn:sitetype}/{gtn:sitename}{gtn:path}").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:handler").withValue("site"), DescriptorBuilder.routeParam((String)"gtn:handler").withValue("site"), DescriptorBuilder.pathParam((String)"gtn:path").matchedBy(".*").preservePath()}), DescriptorBuilder.route((String)"/private/{gtn:sitetype}/{gtn:sitename}{gtn:path}").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:handler").withValue("site"), DescriptorBuilder.pathParam((String)"gtn:path").matchedBy(".*").preservePath()}), DescriptorBuilder.route((String)"/groups/{gtn:sitetype}/{gtn:sitename}{gtn:path}").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:handler").withValue("site"), DescriptorBuilder.pathParam((String)"gtn:path").matchedBy(".*").preservePath()}), DescriptorBuilder.route((String)"/users/{gtn:sitetype}/{gtn:sitename}{gtn:path}").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:handler").withValue("site"), DescriptorBuilder.pathParam((String)"gtn:path").matchedBy(".*").preservePath()})}).build();
    }

    public void testComponent() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "site");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_SITETYPE, "portal");
        expectedParameters.put(Names.GTN_PATH, "/");
        TestPortalConfiguration.assertEquals(expectedParameters, this.router.route("/private/portal/classic/"));
        TestPortalConfiguration.assertEquals((String)"/private/portal/classic/", (String)this.router.render(expectedParameters));
    }

    public void testPrivateClassic() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "site");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_SITETYPE, "portal");
        expectedParameters.put(Names.GTN_PATH, "");
        TestPortalConfiguration.assertEquals(expectedParameters, this.router.route("/private/portal/classic"));
        TestPortalConfiguration.assertEquals((String)"/private/portal/classic", (String)this.router.render(expectedParameters));
    }

    public void testPrivateClassicSlash() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "site");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_SITETYPE, "portal");
        expectedParameters.put(Names.GTN_PATH, "/");
        TestPortalConfiguration.assertEquals(expectedParameters, this.router.route("/private/portal/classic/"));
        TestPortalConfiguration.assertEquals((String)"/private/portal/classic/", (String)this.router.render(expectedParameters));
    }

    public void testPrivateClassicHome() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "site");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_SITETYPE, "portal");
        expectedParameters.put(Names.GTN_PATH, "/home");
        TestPortalConfiguration.assertEquals(expectedParameters, this.router.route("/private/portal/classic/home"));
        TestPortalConfiguration.assertEquals((String)"/private/portal/classic/home", (String)this.router.render(expectedParameters));
    }

    public void testSiteType() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "site");
        expectedParameters.put(Names.GTN_SITETYPE, "group");
        expectedParameters.put(Names.GTN_SITENAME, "platform");
        expectedParameters.put(Names.GTN_PATH, "/administration/registry");
        TestPortalConfiguration.assertEquals(expectedParameters, this.router.route("/private/group/platform/administration/registry"));
        TestPortalConfiguration.assertEquals((String)"/private/group/platform/administration/registry", (String)this.router.render(expectedParameters));
        HashMap<QualifiedName, String> expectedParameters1 = new HashMap<QualifiedName, String>();
        expectedParameters1.put(Names.GTN_HANDLER, "site");
        expectedParameters1.put(Names.GTN_SITETYPE, "user");
        expectedParameters1.put(Names.GTN_SITENAME, "root");
        expectedParameters1.put(Names.GTN_PATH, "/tab_0");
        TestPortalConfiguration.assertEquals(expectedParameters1, this.router.route("/private/user/root/tab_0"));
        TestPortalConfiguration.assertEquals((String)"/private/user/root/tab_0", (String)this.router.render(expectedParameters1));
    }
}

