/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import jregex.Matcher;
import jregex.Pattern;
import org.exoplatform.web.controller.router.Regex;
import org.exoplatform.web.controller.router.RegexFactory;

public class JRegexFactory
extends RegexFactory {
    public static final RegexFactory INSTANCE = new JRegexFactory();

    private JRegexFactory() {
    }

    public Regex compile(String pattern) {
        return new JRegex(pattern);
    }

    public String getName() {
        return "jregex";
    }

    public static class JRegex
    extends Regex {
        private final Pattern pattern;

        public JRegex(String regex) {
            this.pattern = new Pattern(regex);
        }

        public Regex.Matcher matcher() {
            return new Regex.Matcher(){
                private Matcher impl;

                private Matcher get(CharSequence seq) {
                    String s = seq.toString();
                    if (this.impl == null) {
                        this.impl = pattern.matcher(s);
                    } else {
                        this.impl.setTarget(s);
                    }
                    return this.impl;
                }

                public boolean matches(CharSequence s) {
                    return this.get(s).matches();
                }

                public Regex.Match[] find(CharSequence s) {
                    Matcher matcher = this.get(s);
                    if (matcher.find()) {
                        Regex.Match[] matches = new Regex.Match[matcher.groupCount()];
                        for (int i = 0; i < matcher.groupCount(); ++i) {
                            matches[i] = matcher.isCaptured(i) ? new Regex.Match(matcher.start(i), matcher.end(i), matcher.group(i)) : Regex.NULL_MATCH;
                        }
                        return matches;
                    }
                    return Regex.NO_MATCHES;
                }
            };
        }

        public String getPattern() {
            return this.pattern.toString();
        }
    }
}

