/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.router.AbstractTestController;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.Router;

public class TestRouter
extends AbstractTestController {
    public void testMatcher() throws Exception {
        URL routerURL = TestRouter.class.getClassLoader().getResource("controller.xml");
        ControllerDescriptor routerDesc = new DescriptorBuilder().build(routerURL.openStream());
        Router router = new Router(routerDesc);
        Iterator matcher = router.matcher("/", null);
        TestRouter.assertTrue((boolean)matcher.hasNext());
        Map params = (Map)matcher.next();
        HashMap<Object, String> expected = new HashMap<QualifiedName, String>();
        expected.put(WebAppController.HANDLER_PARAM, "default");
        TestRouter.assertEquals(expected, params);
        TestRouter.assertFalse((boolean)matcher.hasNext());
        matcher = router.matcher("/abc", null);
        TestRouter.assertTrue((boolean)matcher.hasNext());
        params = (Map)matcher.next();
        TestRouter.assertEquals((String)"portal", (String)((String)params.get(WebAppController.HANDLER_PARAM)));
        expected = new HashMap();
        expected.put(WebAppController.HANDLER_PARAM, "portal");
        expected.put(Names.GTN_SITETYPE, "portal");
        expected.put(Names.GTN_SITENAME, "abc");
        expected.put(Names.GTN_LANG, "");
        expected.put(Names.GTN_PATH, "");
        TestRouter.assertEquals(expected, params);
        TestRouter.assertFalse((boolean)matcher.hasNext());
        matcher = router.matcher("/fr/exist/point", null);
        TestRouter.assertTrue((boolean)matcher.hasNext());
        params = (Map)matcher.next();
        TestRouter.assertEquals((String)"portal", (String)((String)params.get(WebAppController.HANDLER_PARAM)));
        expected = new HashMap();
        expected.put(WebAppController.HANDLER_PARAM, "portal");
        expected.put(Names.GTN_SITETYPE, "portal");
        expected.put(Names.GTN_LANG, "fr");
        expected.put(Names.GTN_SITENAME, "exist");
        expected.put(Names.GTN_PATH, "point");
        TestRouter.assertEquals(expected, params);
        TestRouter.assertFalse((boolean)matcher.hasNext());
        matcher = router.matcher("/download", null);
        TestRouter.assertTrue((boolean)matcher.hasNext());
        params = (Map)matcher.next();
        TestRouter.assertEquals((String)"download", (String)((String)params.get(WebAppController.HANDLER_PARAM)));
        expected = new HashMap();
        expected.put(WebAppController.HANDLER_PARAM, "download");
        TestRouter.assertEquals(expected, params);
        TestRouter.assertTrue((boolean)matcher.hasNext());
        params = (Map)matcher.next();
        TestRouter.assertEquals((String)"portal", (String)((String)params.get(WebAppController.HANDLER_PARAM)));
        expected = new HashMap();
        expected.put(WebAppController.HANDLER_PARAM, "portal");
        expected.put(Names.GTN_SITETYPE, "portal");
        expected.put(Names.GTN_LANG, "");
        expected.put(Names.GTN_SITENAME, "download");
        expected.put(Names.GTN_PATH, "");
        TestRouter.assertEquals(expected, params);
        TestRouter.assertFalse((boolean)matcher.hasNext());
        matcher = router.matcher("/en/classic/home", null);
        TestRouter.assertTrue((boolean)matcher.hasNext());
        params = (Map)matcher.next();
        expected = new HashMap();
        expected.put(WebAppController.HANDLER_PARAM, "portal");
        expected.put(Names.GTN_SITETYPE, "portal");
        expected.put(Names.GTN_LANG, "en");
        expected.put(Names.GTN_SITENAME, "classic");
        expected.put(Names.GTN_PATH, "home");
        TestRouter.assertEquals(expected, params);
        TestRouter.assertFalse((boolean)matcher.hasNext());
        matcher = router.matcher("/g/classic/register", new HashMap<String, String[]>(Collections.singletonMap("lang", new String[]{"fr"})));
        TestRouter.assertTrue((boolean)matcher.hasNext());
        params = (Map)matcher.next();
        expected = new HashMap();
        expected.put(WebAppController.HANDLER_PARAM, "portal");
        expected.put(Names.GTN_SITETYPE, "group");
        expected.put(Names.GTN_LANG, "fr");
        expected.put(Names.GTN_SITENAME, "classic");
        expected.put(Names.GTN_PATH, "register");
        TestRouter.assertEquals(expected, params);
        TestRouter.assertTrue((boolean)matcher.hasNext());
        params = (Map)matcher.next();
        expected = new HashMap();
        expected.put(WebAppController.HANDLER_PARAM, "portal");
        expected.put(Names.GTN_SITETYPE, "portal");
        expected.put(Names.GTN_LANG, "");
        expected.put(Names.GTN_SITENAME, "g");
        expected.put(Names.GTN_PATH, "classic/register");
        TestRouter.assertEquals(expected, params);
        TestRouter.assertFalse((boolean)matcher.hasNext());
    }
}

