/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import junit.framework.TestCase;
import org.exoplatform.web.controller.router.JRegexFactory;
import org.exoplatform.web.controller.router.Regex;

public class RegexTestCase
extends TestCase {
    public void testLiteral() {
        Regex regex = JRegexFactory.INSTANCE.compile("abc");
        Regex.Match[] matches = regex.matcher().find((CharSequence)"abc");
        RegexTestCase.assertEquals((int)1, (int)matches.length);
        RegexTestCase.assertEquals((int)0, (int)matches[0].getStart());
        RegexTestCase.assertEquals((int)3, (int)matches[0].getEnd());
        RegexTestCase.assertEquals((String)"abc", (String)matches[0].getValue());
    }

    public void testSimpleGroup1() {
        Regex regex = JRegexFactory.INSTANCE.compile("(abc)");
        Regex.Match[] matches = regex.matcher().find((CharSequence)"abc");
        RegexTestCase.assertEquals((int)2, (int)matches.length);
        RegexTestCase.assertEquals((int)0, (int)matches[0].getStart());
        RegexTestCase.assertEquals((int)3, (int)matches[0].getEnd());
        RegexTestCase.assertEquals((String)"abc", (String)matches[0].getValue());
        RegexTestCase.assertEquals((int)0, (int)matches[1].getStart());
        RegexTestCase.assertEquals((int)3, (int)matches[1].getEnd());
        RegexTestCase.assertEquals((String)"abc", (String)matches[1].getValue());
    }

    public void testSimpleGroup2() {
        Regex regex = JRegexFactory.INSTANCE.compile("a(b)c");
        Regex.Match[] matches = regex.matcher().find((CharSequence)"abc");
        RegexTestCase.assertEquals((int)2, (int)matches.length);
        RegexTestCase.assertEquals((int)0, (int)matches[0].getStart());
        RegexTestCase.assertEquals((int)3, (int)matches[0].getEnd());
        RegexTestCase.assertEquals((String)"abc", (String)matches[0].getValue());
        RegexTestCase.assertEquals((int)1, (int)matches[1].getStart());
        RegexTestCase.assertEquals((int)2, (int)matches[1].getEnd());
        RegexTestCase.assertEquals((String)"b", (String)matches[1].getValue());
    }

    public void testNonCapturingGroup() {
        Regex regex = JRegexFactory.INSTANCE.compile("a(?:b)c");
        Regex.Match[] matches = regex.matcher().find((CharSequence)"abc");
        RegexTestCase.assertEquals((int)1, (int)matches.length);
        RegexTestCase.assertEquals((int)0, (int)matches[0].getStart());
        RegexTestCase.assertEquals((int)3, (int)matches[0].getEnd());
        RegexTestCase.assertEquals((String)"abc", (String)matches[0].getValue());
    }
}

