/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import junit.framework.TestCase;
import org.exoplatform.web.controller.router.BitStack;

public class TestBitStack
extends TestCase {
    public void testSimple() {
        BitStack bs = new BitStack();
        TestBitStack.assertEquals((int)0, (int)bs.getDepth());
        bs.init(2);
        bs.push();
        TestBitStack.assertEquals((int)1, (int)bs.getDepth());
        bs.set(1);
        TestBitStack.assertFalse((boolean)bs.isEmpty());
        bs.push();
        TestBitStack.assertEquals((int)2, (int)bs.getDepth());
        bs.set(0);
        TestBitStack.assertTrue((boolean)bs.isEmpty());
        bs.pop();
        TestBitStack.assertEquals((int)1, (int)bs.getDepth());
        TestBitStack.assertFalse((boolean)bs.isEmpty());
        bs.pop();
        TestBitStack.assertEquals((int)0, (int)bs.getDepth());
    }

    public void testReuse() {
        BitStack bs = new BitStack();
        bs.init(2);
        bs.push();
        bs.set(0);
        bs.push();
        bs.set(1);
        TestBitStack.assertTrue((boolean)bs.isEmpty());
        bs.pop();
        bs.push();
        TestBitStack.assertFalse((boolean)bs.isEmpty());
    }

    public void testState() {
        BitStack bs = new BitStack();
        try {
            bs.set(0);
            TestBitStack.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            bs.pop();
            TestBitStack.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

