/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import junit.framework.TestCase;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.EncodingMode;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.PathParam;
import org.exoplatform.web.controller.router.PatternRoute;
import org.exoplatform.web.controller.router.Route;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.SegmentRoute;

public class TestBuildRoute
extends TestCase {
    public void testParameterSegment() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}")}).build();
        TestBuildRoute.assertEquals((int)0, (int)router.root.getSegmentNames().size());
        TestBuildRoute.assertEquals((int)1, (int)router.root.getPatternSize());
        PatternRoute patternRoute = router.root.getPattern(0);
        TestBuildRoute.assertEquals((String)"^/(?:([^/]+))(?:(?<=^/)|(?=/)|$)", (String)patternRoute.pattern.getPattern());
        TestBuildRoute.assertEquals((int)1, (int)patternRoute.params.length);
        TestBuildRoute.assertEquals((Object)Names.A, (Object)patternRoute.params[0].name);
        TestBuildRoute.assertEquals((String)"^(.+)$", (String)patternRoute.params[0].matchingRegex[0].getPattern());
        TestBuildRoute.assertEquals((Object)EncodingMode.FORM, (Object)patternRoute.params[0].encodingMode);
        TestBuildRoute.assertEquals((int)2, (int)patternRoute.chunks.length);
        TestBuildRoute.assertEquals((String)"", (String)patternRoute.chunks[0]);
        TestBuildRoute.assertEquals((String)"", (String)patternRoute.chunks[1]);
    }

    public void testQualifiedParameterSegment() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{q:a}")}).build();
        TestBuildRoute.assertEquals((int)0, (int)router.root.getSegmentNames().size());
        TestBuildRoute.assertEquals((int)1, (int)router.root.getPatternSize());
        PatternRoute patternRoute = router.root.getPattern(0);
        TestBuildRoute.assertEquals((String)"^/(?:([^/]+))(?:(?<=^/)|(?=/)|$)", (String)patternRoute.pattern.getPattern());
        TestBuildRoute.assertEquals((int)1, (int)patternRoute.params.length);
        TestBuildRoute.assertEquals((Object)Names.Q_A, (Object)patternRoute.params[0].name);
        TestBuildRoute.assertEquals((String)"^(.+)$", (String)patternRoute.params[0].matchingRegex[0].getPattern());
        TestBuildRoute.assertEquals((Object)EncodingMode.FORM, (Object)patternRoute.params[0].encodingMode);
        TestBuildRoute.assertEquals((int)2, (int)patternRoute.chunks.length);
        TestBuildRoute.assertEquals((String)"", (String)patternRoute.chunks[0]);
        TestBuildRoute.assertEquals((String)"", (String)patternRoute.chunks[1]);
    }

    public void testPatternSegment() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy(".*")})}).build();
        TestBuildRoute.assertEquals((int)0, (int)router.root.getSegmentNames().size());
        TestBuildRoute.assertEquals((int)1, (int)router.root.getPatternSize());
        PatternRoute patternRoute = router.root.getPattern(0);
        TestBuildRoute.assertEquals((String)"^/(?:([^/]*))(?:(?<=^/)|(?=/)|$)", (String)patternRoute.pattern.getPattern());
        TestBuildRoute.assertEquals((int)1, (int)patternRoute.params.length);
        TestBuildRoute.assertEquals((Object)Names.A, (Object)patternRoute.params[0].name);
        TestBuildRoute.assertEquals((String)"^(.*)$", (String)patternRoute.params[0].matchingRegex[0].getPattern());
        TestBuildRoute.assertEquals((Object)EncodingMode.FORM, (Object)patternRoute.params[0].encodingMode);
        TestBuildRoute.assertEquals((int)2, (int)patternRoute.chunks.length);
        TestBuildRoute.assertEquals((String)"", (String)patternRoute.chunks[0]);
        TestBuildRoute.assertEquals((String)"", (String)patternRoute.chunks[1]);
    }

    public void testSamePrefix() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/public/foo")}).add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/public/bar")}).build();
        TestBuildRoute.assertEquals((int)2, (int)router.root.getSegmentSize("public"));
        SegmentRoute publicRoute1 = router.root.getSegment("public", 0);
        TestBuildRoute.assertEquals((int)1, (int)publicRoute1.getSegmentSize("foo"));
        SegmentRoute publicRoute2 = router.root.getSegment("public", 1);
        TestBuildRoute.assertEquals((int)1, (int)publicRoute2.getSegmentSize("bar"));
    }

    private void assertEquals(Route expectedRoute, Route route) {
        int i;
        TestBuildRoute.assertEquals(expectedRoute.getClass(), route.getClass());
        TestBuildRoute.assertEquals((Object)expectedRoute.getSegmentNames(), (Object)route.getSegmentNames());
        for (String segmentName : expectedRoute.getSegmentNames()) {
            TestBuildRoute.assertEquals((int)expectedRoute.getSegmentSize(segmentName), (int)route.getSegmentSize(segmentName));
            for (int segmentIndex = 0; segmentIndex < expectedRoute.getSegmentSize(segmentName); ++segmentIndex) {
                SegmentRoute expectedSegmentRoute = expectedRoute.getSegment(segmentName, segmentIndex);
                SegmentRoute segmentRoute = route.getSegment(segmentName, segmentIndex);
                this.assertEquals((Route)expectedSegmentRoute, (Route)segmentRoute);
            }
        }
        TestBuildRoute.assertEquals((int)expectedRoute.getPatternSize(), (int)route.getPatternSize());
        for (i = 0; i < expectedRoute.getPatternSize(); ++i) {
            this.assertEquals((Route)expectedRoute.getPattern(i), (Route)route.getPattern(i));
        }
        if (route instanceof PatternRoute) {
            TestBuildRoute.assertEquals((String)((PatternRoute)expectedRoute).pattern.toString(), (String)((PatternRoute)route).pattern.toString());
            TestBuildRoute.assertEquals((int)((PatternRoute)expectedRoute).params.length, (int)((PatternRoute)route).params.length);
            for (i = 0; i < ((PatternRoute)expectedRoute).params.length; ++i) {
                PathParam expectedParam = ((PatternRoute)expectedRoute).params[i];
                PathParam param = ((PatternRoute)route).params[i];
                TestBuildRoute.assertEquals((Object)expectedParam.name, (Object)param.name);
                TestBuildRoute.assertEquals((int)expectedParam.matchingRegex.length, (int)param.matchingRegex.length);
                for (int j = 0; j < expectedParam.matchingRegex.length; ++j) {
                    TestBuildRoute.assertEquals((String)expectedParam.matchingRegex[j].toString(), (String)param.matchingRegex[j].toString());
                }
                TestBuildRoute.assertEquals((Object)expectedParam.encodingMode, (Object)param.encodingMode);
            }
        } else if (route instanceof SegmentRoute) {
            TestBuildRoute.assertEquals((String)((SegmentRoute)expectedRoute).name, (String)((SegmentRoute)route).name);
        }
    }
}

