/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.handler;

import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;

public class DefaultRequestHandler
extends WebRequestHandler {
    private final UserPortalConfigService portalConfigService;

    public DefaultRequestHandler(UserPortalConfigService portalConfigService) {
        this.portalConfigService = portalConfigService;
    }

    @Override
    public String getHandlerName() {
        return "default";
    }

    @Override
    public boolean execute(ControllerContext context) throws Exception {
        String currentUser = context.getRequest().getRemoteUser();
        String defaultUri = this.portalConfigService.getDefaultPath(currentUser);
        HttpServletResponse resp = context.getResponse();
        if (StringUtils.isBlank((CharSequence)defaultUri)) {
            if (StringUtils.isBlank((CharSequence)currentUser)) {
                String currentPortalContainerName = PortalContainer.getCurrentPortalContainerName();
                resp.sendRedirect("/" + currentPortalContainerName + "/login");
                return true;
            }
            resp.sendRedirect("/portal/" + this.portalConfigService.getMetaPortal() + "/page-not-found");
            return true;
        }
        resp.sendRedirect(resp.encodeRedirectURL(defaultUri));
        return true;
    }

    @Override
    protected boolean getRequiresLifeCycle() {
        return true;
    }
}

