/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.regexp.REParser;
import org.exoplatform.web.controller.regexp.REVisitor;
import org.exoplatform.web.controller.router.CaptureGroupTransformation;
import org.exoplatform.web.controller.router.ValueResolverFactory;

public class TestFooVisitor
extends TestCase {
    private static void assertSatisfied(String expression, String ... expected) throws Exception {
        RENode root = new REParser((CharSequence)expression).parse();
        root.accept((REVisitor)new CaptureGroupTransformation());
        List alternatives = new ValueResolverFactory().foo(root);
        TestFooVisitor.assertEquals((int)expected.length, (int)alternatives.size());
        for (int i = 0; i < expected.length; ++i) {
            TestFooVisitor.assertEquals((String)expected[i], (String)((ValueResolverFactory.Alternative)alternatives.get(i)).getResolvingExpression().toString());
        }
    }

    public void testDisjunctions() throws Exception {
        TestFooVisitor.assertSatisfied("a|.", "(a)", "(.)");
        TestFooVisitor.assertSatisfied("a(.)b|.", "a(.)b", "(.)");
    }

    public void testDisjunction() throws Exception {
        TestFooVisitor.assertSatisfied("(?:a|b)(.)b", "a(.)b");
    }

    public void testAlternative() throws Exception {
        TestFooVisitor.assertSatisfied("a(.)b", "a(.)b");
    }

    public void testCharacterClassRange() throws Exception {
        TestFooVisitor.assertSatisfied("a(.)[b-c]", "a(.)b");
    }

    public void testCharacterClassOr() throws Exception {
        TestFooVisitor.assertSatisfied("a(.)[bc]", "a(.)b");
    }

    public void testCharacterClassAnd() throws Exception {
        TestFooVisitor.assertSatisfied("a(.)[b&&b]", "a(.)b");
    }

    public void testQuantifier() throws Exception {
        TestFooVisitor.assertSatisfied("a(.)b{2,3}", "a(.)bb");
    }

    public void testCharacterClassNegateChar() throws Exception {
        TestFooVisitor.assertSatisfied("a(.)[^a]", "a(.) ");
    }

    public void testCharacterClassNegateOr() throws Exception {
        TestFooVisitor.assertSatisfied("a(.)[^ !]", "a(.)\"");
    }

    public void testCharacterClassNegateAnd() throws Exception {
        TestFooVisitor.assertSatisfied("a(.)[^a&&b]", "a(.) ");
    }

    public void testAny() throws Exception {
        TestFooVisitor.assertSatisfied("a(.).", "a(.)a");
    }

    public void testComplex() throws Exception {
        TestFooVisitor.assertSatisfied("a(.)[a-z&&f-t&&p-q]", "a(.)p");
    }
}

