/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.mock;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.router.RouterConfigException;

public class WebAppControllerMock
extends WebAppController {
    private ExoContainer container;

    public WebAppControllerMock(ExoContainer container, InitParams params) throws Exception {
        super(params);
        this.container = container;
    }

    public void reloadConfiguration() throws RouterConfigException, IOException {
        try {
            super.reloadConfiguration();
        }
        catch (Exception e) {
            URL resource = null;
            String configurationPath = this.getConfigurationPath();
            if (StringUtils.contains((CharSequence)configurationPath, (CharSequence)"classpath:") || StringUtils.contains((CharSequence)configurationPath, (CharSequence)"jar:")) {
                configurationPath = configurationPath.replace("classpath:/", "").replace("classpath:", "").replace("jar:/", "").replace("jar:", "");
            }
            if ((resource = this.getResource(configurationPath)) == null && (resource = this.getResource("conf/controller.xml")) == null && (resource = this.getResource("controller.xml")) == null) {
                throw new RouterConfigException("File wasn't found in paths 'conf/controller.xml', 'controller.xml' nor " + this.getConfigurationPath());
            }
            this.loadConfiguration(resource);
        }
    }

    private URL getResource(String relativePath) {
        URL resource;
        if (StringUtils.isBlank((CharSequence)relativePath)) {
            return null;
        }
        ExoContainer exoContainer = this.container;
        if (exoContainer instanceof PortalContainer) {
            PortalContainer portalContainer = (PortalContainer)exoContainer;
            resource = portalContainer.getPortalClassLoader().getResource(relativePath);
        } else {
            resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(relativePath);
        }
        return resource;
    }
}

