/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.Collections;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.AbstractTestController;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.Router;

public class TestRoutePriority
extends AbstractTestController {
    public void testExactMatchingAfterWildcard() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{foo}")}).add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/foo").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"foo").withValue("b")})}).build();
        TestRoutePriority.assertEquals(Collections.singletonMap(Names.FOO, "foo"), router.route("/foo"));
        TestRoutePriority.assertEquals((String)"/foo", (String)router.render(Collections.singletonMap(Names.FOO, "foo")));
        TestRoutePriority.assertEquals((String)"/b", (String)router.render(Collections.singletonMap(Names.FOO, "b")));
    }

    public void testExactMatchingBeforeWildcard() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/foo").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"foo").withValue("b")})}).add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{foo}")}).build();
        TestRoutePriority.assertEquals(Collections.singletonMap(Names.FOO, "b"), router.route("/foo"));
        TestRoutePriority.assertEquals((String)"/foo", (String)router.render(Collections.singletonMap(Names.FOO, "b")));
        TestRoutePriority.assertEquals((String)"/foo", (String)router.render(Collections.singletonMap(Names.FOO, "foo")));
    }
}

