/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.portal;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.ResourceType;
import org.exoplatform.web.url.URLFactory;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/test.mop.portal.configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/web/portal/configuration.xml")})
public class TestRefreshCurrentUserPortal
extends AbstractKernelTest {
    private static final String TEST_USER_PORTAL_GROUP = "/platform";
    private static final SiteKey TEST_USER_PORTAL_SITE_KEY = SiteKey.group((String)"/platform");
    private UserPortal userPortal;
    private NavigationService navigationService;
    private UserPortalConfigService portalConfigService;
    private LayoutService layoutService;

    protected void setUp() throws Exception {
        super.setUp();
        this.begin();
        this.navigationService = (NavigationService)this.getContainer().getComponentInstanceOfType(NavigationService.class);
        this.portalConfigService = (UserPortalConfigService)this.getContainer().getComponentInstanceOfType(UserPortalConfigService.class);
        this.layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        ((IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class)).register(new Identity("root", Arrays.asList(new MembershipEntry(TEST_USER_PORTAL_GROUP), new MembershipEntry("/platform/users"), new MembershipEntry("/platform/administrators"))));
        UserPortalConfig userPortalConfig = this.portalConfigService.getUserPortalConfig("classic", "root");
        this.userPortal = userPortalConfig.getUserPortal();
        RequestContext.setCurrentInstance((RequestContext)new RequestContext(null){

            public URLFactory getURLFactory() {
                throw new UnsupportedOperationException();
            }

            public <R, U extends PortalURL<R, U>> U newURL(ResourceType<R, U> resourceType, URLFactory urlFactory) {
                throw new UnsupportedOperationException();
            }

            public Orientation getOrientation() {
                throw new UnsupportedOperationException();
            }

            public String getRequestParameter(String name) {
                throw new UnsupportedOperationException();
            }

            public String[] getRequestParameterValues(String name) {
                throw new UnsupportedOperationException();
            }

            public URLBuilder<?> getURLBuilder() {
                throw new UnsupportedOperationException();
            }

            public boolean useAjax() {
                throw new UnsupportedOperationException();
            }

            public UserPortal getUserPortal() {
                return TestRefreshCurrentUserPortal.this.userPortal;
            }
        });
        this.removeTestedNavigation();
    }

    protected void tearDown() throws Exception {
        ((IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class)).unregister("root");
        this.removeTestedNavigation();
        RequestContext.setCurrentInstance(null);
        this.end();
        ConversationState.setCurrent(null);
        super.tearDown();
    }

    public void testCreate() throws Exception {
        List navs = this.userPortal.getNavigations();
        TestRefreshCurrentUserPortal.assertFalse((boolean)navs.isEmpty());
        int initialSize = navs.size();
        this.createTestedNavigation();
        navs = this.userPortal.getNavigations();
        TestRefreshCurrentUserPortal.assertEquals((int)(initialSize + 1), (int)navs.size());
    }

    public void testUpdate() throws Exception {
        List navs = this.userPortal.getNavigations();
        TestRefreshCurrentUserPortal.assertFalse((boolean)navs.isEmpty());
        int initialSize = navs.size();
        this.createTestedNavigation();
        navs = this.userPortal.getNavigations();
        TestRefreshCurrentUserPortal.assertFalse((boolean)navs.isEmpty());
        TestRefreshCurrentUserPortal.assertEquals((int)(initialSize + 1), (int)navs.size());
        UserNavigation userNavigation = this.userPortal.getNavigation(TEST_USER_PORTAL_SITE_KEY);
        TestRefreshCurrentUserPortal.assertNotNull((Object)userNavigation);
        NavigationContext navigationContext = this.navigationService.loadNavigation(TEST_USER_PORTAL_SITE_KEY);
        NodeContext root = this.navigationService.loadNode(NodeModel.SELF_MODEL, navigationContext, Scope.ALL, null);
        root.add(null, "foo");
        this.navigationService.saveNode(root, null);
        navs = this.userPortal.getNavigations();
        TestRefreshCurrentUserPortal.assertEquals((int)(initialSize + 1), (int)navs.size());
        this.navigationService.destroyNavigation(TEST_USER_PORTAL_SITE_KEY);
        navs = this.userPortal.getNavigations();
        TestRefreshCurrentUserPortal.assertEquals((int)initialSize, (int)navs.size());
    }

    public void testDestroy() throws Exception {
        List navs = this.userPortal.getNavigations();
        TestRefreshCurrentUserPortal.assertFalse((boolean)navs.isEmpty());
        int initialSize = navs.size();
        this.createTestedNavigation();
        navs = this.userPortal.getNavigations();
        TestRefreshCurrentUserPortal.assertFalse((boolean)navs.isEmpty());
        TestRefreshCurrentUserPortal.assertEquals((int)(initialSize + 1), (int)navs.size());
        UserNavigation userNavigation = this.userPortal.getNavigation(TEST_USER_PORTAL_SITE_KEY);
        TestRefreshCurrentUserPortal.assertNotNull((Object)userNavigation);
        this.navigationService.destroyNavigation(TEST_USER_PORTAL_SITE_KEY);
        navs = this.userPortal.getNavigations();
        TestRefreshCurrentUserPortal.assertEquals((int)initialSize, (int)navs.size());
    }

    private void createTestedNavigation() {
        this.portalConfigService.createUserPortalConfig(PortalConfig.GROUP_TYPE, TEST_USER_PORTAL_GROUP, "group", "jar:/org/exoplatform/portal/config/conf");
        this.navigationService.saveNavigation(new NavigationContext(TEST_USER_PORTAL_SITE_KEY, new NavigationState(Integer.valueOf(1))));
    }

    private void removeTestedNavigation() {
        NavigationContext navigationContext = this.navigationService.loadNavigation(TEST_USER_PORTAL_SITE_KEY);
        if (navigationContext != null) {
            this.layoutService.remove(this.layoutService.getPortalConfig(TEST_USER_PORTAL_SITE_KEY));
            this.restartTransaction();
        }
    }
}

