/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import junit.framework.TestCase;
import org.exoplatform.web.controller.QualifiedName;

public class TestQualifiedName
extends TestCase {
    public void testSame() {
        QualifiedName qd1 = QualifiedName.create((String)"a", (String)"bc");
        TestQualifiedName.assertEquals((String)"a", (String)qd1.getQualifier());
        TestQualifiedName.assertEquals((String)"bc", (String)qd1.getName());
        TestQualifiedName.assertEquals((String)"a:bc", (String)qd1.getValue());
        QualifiedName qd2 = QualifiedName.parse((String)"a:bc");
        TestQualifiedName.assertEquals((String)"a", (String)qd2.getQualifier());
        TestQualifiedName.assertEquals((String)"bc", (String)qd2.getName());
        TestQualifiedName.assertEquals((String)"a:bc", (String)qd2.getValue());
        TestQualifiedName.assertTrue((boolean)qd1.equals((Object)qd2));
        TestQualifiedName.assertTrue((boolean)qd2.equals((Object)qd1));
        TestQualifiedName.assertTrue((boolean)qd1.equals((Object)qd1));
        TestQualifiedName.assertTrue((boolean)qd2.equals((Object)qd2));
        TestQualifiedName.assertEquals((int)qd1.hashCode(), (int)qd2.hashCode());
    }

    public void testSameQualifierComparison() {
        QualifiedName qd1 = QualifiedName.create((String)"a", (String)"b");
        QualifiedName qd2 = QualifiedName.create((String)"a", (String)"c");
        TestQualifiedName.assertEquals((Object)Float.valueOf(Math.signum(qd1.compareTo(qd2))), (Object)Float.valueOf(Math.signum("b".compareTo("c"))));
        TestQualifiedName.assertEquals((Object)Float.valueOf(Math.signum(qd2.compareTo(qd1))), (Object)Float.valueOf(Math.signum("c".compareTo("b"))));
    }

    public void testEmptyQualifierComparison() {
        QualifiedName qd1 = QualifiedName.create((String)"a");
        QualifiedName qd2 = QualifiedName.create((String)"b");
        TestQualifiedName.assertEquals((Object)Float.valueOf(Math.signum(qd1.compareTo(qd2))), (Object)Float.valueOf(Math.signum("a".compareTo("b"))));
        TestQualifiedName.assertEquals((Object)Float.valueOf(Math.signum(qd2.compareTo(qd1))), (Object)Float.valueOf(Math.signum("b".compareTo("a"))));
    }

    public void testDifferentQualifierSameNameComparison() {
        QualifiedName qd1 = QualifiedName.create((String)"a", (String)"c");
        QualifiedName qd2 = QualifiedName.create((String)"b", (String)"c");
        TestQualifiedName.assertEquals((Object)Float.valueOf(Math.signum(qd1.compareTo(qd2))), (Object)Float.valueOf(Math.signum("a".compareTo("b"))));
        TestQualifiedName.assertEquals((Object)Float.valueOf(Math.signum(qd2.compareTo(qd1))), (Object)Float.valueOf(Math.signum("b".compareTo("a"))));
    }

    public void testSameWithEmptyQualifier() {
        QualifiedName qd1 = QualifiedName.create((String)"abc");
        TestQualifiedName.assertEquals((String)"", (String)qd1.getQualifier());
        TestQualifiedName.assertEquals((String)"abc", (String)qd1.getName());
        TestQualifiedName.assertEquals((String)"abc", (String)qd1.getValue());
        QualifiedName qd2 = QualifiedName.parse((String)"abc");
        TestQualifiedName.assertEquals((String)"", (String)qd2.getQualifier());
        TestQualifiedName.assertEquals((String)"abc", (String)qd2.getName());
        TestQualifiedName.assertEquals((String)"abc", (String)qd2.getValue());
        TestQualifiedName.assertTrue((boolean)qd1.equals((Object)qd2));
        TestQualifiedName.assertTrue((boolean)qd2.equals((Object)qd1));
        TestQualifiedName.assertTrue((boolean)qd1.equals((Object)qd1));
        TestQualifiedName.assertTrue((boolean)qd2.equals((Object)qd2));
        TestQualifiedName.assertEquals((int)qd1.hashCode(), (int)qd2.hashCode());
    }

    public void testNPEInCtor() {
        try {
            QualifiedName.create(null);
            TestQualifiedName.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            QualifiedName.create((String)"a", null);
            TestQualifiedName.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            QualifiedName.create(null, (String)"a");
            TestQualifiedName.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            QualifiedName.create(null, null);
            TestQualifiedName.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            QualifiedName.parse(null);
            TestQualifiedName.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIAEInCtor() {
        try {
            QualifiedName.create((String)"a:b");
            TestQualifiedName.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            QualifiedName.create((String)":", (String)"a");
            TestQualifiedName.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            QualifiedName.create((String)"a", (String)":");
            TestQualifiedName.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            QualifiedName.create((String)":", (String)":");
            TestQualifiedName.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            QualifiedName.parse((String)"::");
            TestQualifiedName.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

