/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.AbstractTestController;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.URIHelper;

public class TestRequestParam
extends AbstractTestController {
    public void testRoot() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").named("a").matchedByLiteral("a").required()})}).build();
        TestRequestParam.assertNull((Object)router.route("/"));
        TestRequestParam.assertEquals(Collections.singletonMap(Names.FOO, "a"), router.route("/", Collections.singletonMap("a", new String[]{"a"})));
        TestRequestParam.assertEquals((String)"", (String)router.render(Collections.emptyMap()));
        URIHelper renderContext = new URIHelper();
        router.render(Collections.singletonMap(Names.FOO, "a"), renderContext.writer);
        TestRequestParam.assertEquals((String)"/", (String)renderContext.getPath());
        TestRequestParam.assertMapEquals(Collections.singletonMap("a", new String[]{"a"}), renderContext.getQueryParams());
    }

    public void testSegment() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").named("a").matchedByLiteral("a").required()})}).build();
        TestRequestParam.assertNull((Object)router.route("/a"));
        TestRequestParam.assertEquals(Collections.singletonMap(Names.FOO, "a"), router.route("/a", Collections.singletonMap("a", new String[]{"a"})));
        TestRequestParam.assertEquals((String)"", (String)router.render(Collections.emptyMap()));
        URIHelper renderContext = new URIHelper();
        router.render(Collections.singletonMap(Names.FOO, "a"), renderContext.writer);
        TestRequestParam.assertEquals((String)"/a", (String)renderContext.getPath());
        TestRequestParam.assertMapEquals(Collections.singletonMap("a", new String[]{"a"}), renderContext.getQueryParams());
    }

    public void testValuePattern() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").named("a").matchedByPattern("[0-9]+").required()})}).build();
        TestRequestParam.assertNull((Object)router.route("/a"));
        TestRequestParam.assertNull((Object)router.route("/a", Collections.singletonMap("a", new String[]{"a"})));
        TestRequestParam.assertEquals(Collections.singletonMap(Names.FOO, "0123"), router.route("/a", Collections.singletonMap("a", new String[]{"0123"})));
        TestRequestParam.assertEquals((String)"", (String)router.render(Collections.emptyMap()));
        TestRequestParam.assertEquals((String)"", (String)router.render(Collections.singletonMap(Names.FOO, "a")));
        URIHelper renderContext = new URIHelper();
        router.render(Collections.singletonMap(Names.FOO, "12"), renderContext.writer);
        TestRequestParam.assertEquals((String)"/a", (String)renderContext.getPath());
        TestRequestParam.assertMapEquals(Collections.singletonMap("a", new String[]{"12"}), renderContext.getQueryParams());
    }

    public void testPrecedence() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").named("a").matchedByLiteral("a").required()})}).add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"bar").named("b").matchedByLiteral("b").required()})}).build();
        TestRequestParam.assertNull((Object)router.route("/a"));
        TestRequestParam.assertEquals(Collections.singletonMap(Names.FOO, "a"), router.route("/a", Collections.singletonMap("a", new String[]{"a"})));
        TestRequestParam.assertEquals(Collections.singletonMap(Names.BAR, "b"), router.route("/a", Collections.singletonMap("b", new String[]{"b"})));
        TestRequestParam.assertEquals((String)"", (String)router.render(Collections.emptyMap()));
        URIHelper renderContext1 = new URIHelper();
        router.render(Collections.singletonMap(Names.FOO, "a"), renderContext1.writer);
        TestRequestParam.assertEquals((String)"/a", (String)renderContext1.getPath());
        TestRequestParam.assertMapEquals(Collections.singletonMap("a", new String[]{"a"}), renderContext1.getQueryParams());
        URIHelper renderContext2 = new URIHelper();
        router.render(Collections.singletonMap(Names.BAR, "b"), renderContext2.writer);
        TestRequestParam.assertEquals((String)"/a", (String)renderContext2.getPath());
        TestRequestParam.assertMapEquals(Collections.singletonMap("b", new String[]{"b"}), renderContext2.getQueryParams());
    }

    public void testInheritance() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").named("a").matchedByLiteral("a").required()}).sub(DescriptorBuilder.route((String)"/b").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"bar").named("b").matchedByLiteral("b").required()}))}).build();
        TestRequestParam.assertNull((Object)router.route("/a"));
        TestRequestParam.assertNull((Object)router.route("/a", Collections.singletonMap("a", new String[]{"a"})));
        TestRequestParam.assertNull((Object)router.route("/a/b"));
        HashMap<String, String[]> requestParameters = new HashMap<String, String[]>();
        requestParameters.put("a", new String[]{"a"});
        requestParameters.put("b", new String[]{"b"});
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.FOO, "a");
        expectedParameters.put(Names.BAR, "b");
        TestRequestParam.assertEquals(expectedParameters, router.route("/a/b", requestParameters));
        TestRequestParam.assertEquals((String)"", (String)router.render(Collections.emptyMap()));
        URIHelper renderContext1 = new URIHelper();
        router.render(Collections.singletonMap(Names.FOO, "a"), renderContext1.writer);
        TestRequestParam.assertEquals((String)"", (String)renderContext1.getPath());
        URIHelper renderContext2 = new URIHelper();
        router.render(expectedParameters, renderContext2.writer);
        TestRequestParam.assertEquals((String)"/a/b", (String)renderContext2.getPath());
        HashMap<String, String[]> expectedRequestParameters = new HashMap<String, String[]>();
        expectedRequestParameters.put("a", new String[]{"a"});
        expectedRequestParameters.put("b", new String[]{"b"});
        TestRequestParam.assertMapEquals(expectedRequestParameters, renderContext2.getQueryParams());
    }

    public void testOptional() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").named("a").matchedByLiteral("a")})}).build();
        TestRequestParam.assertEquals(Collections.emptyMap(), router.route("/", Collections.emptyMap()));
        TestRequestParam.assertEquals(Collections.singletonMap(Names.FOO, "a"), router.route("/", Collections.singletonMap("a", new String[]{"a"})));
        URIHelper renderContext1 = new URIHelper();
        router.render(Collections.emptyMap(), renderContext1.writer);
        TestRequestParam.assertEquals((String)"/", (String)renderContext1.getPath());
        TestRequestParam.assertEquals(null, renderContext1.getQueryParams());
        URIHelper renderContext2 = new URIHelper();
        router.render(Collections.singletonMap(Names.FOO, "a"), renderContext2.writer);
        TestRequestParam.assertEquals((String)"/", (String)renderContext2.getPath());
        TestRequestParam.assertMapEquals(Collections.singletonMap("a", new String[]{"a"}), renderContext2.getQueryParams());
    }

    public void testMatchDescendantOfRootParameters() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").named("a").matchedByLiteral("a")}).sub(DescriptorBuilder.route((String)"/a").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"bar").named("b").matchedByLiteral("b")}))}).build();
        URIHelper renderContext = new URIHelper();
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(Names.FOO, "a");
        parameters.put(Names.BAR, "b");
        router.render(parameters, renderContext.writer);
        TestRequestParam.assertEquals((String)"/a", (String)renderContext.getPath());
        HashMap<String, String[]> expectedRequestParameters = new HashMap<String, String[]>();
        expectedRequestParameters.put("a", new String[]{"a"});
        expectedRequestParameters.put("b", new String[]{"b"});
        TestRequestParam.assertMapEquals(expectedRequestParameters, renderContext.getQueryParams());
    }

    public void testLiteralMatch() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").canonical().optional().named("a").matchedByLiteral("foo_value")})}).build();
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(Names.FOO, "foo_value");
        URIHelper rc = new URIHelper();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals((String)"/", (String)rc.getPath());
        TestRequestParam.assertEquals(Collections.singleton("a"), rc.getQueryParams().keySet());
        TestRequestParam.assertEquals(Collections.singletonList("foo_value"), Arrays.asList(rc.getQueryParams().get("a")));
        Map a = router.route("/", Collections.singletonMap("a", new String[]{"foo_value"}));
        TestRequestParam.assertNotNull((Object)a);
        TestRequestParam.assertEquals(Collections.singleton(Names.FOO), a.keySet());
        TestRequestParam.assertEquals((String)"foo_value", (String)((String)a.get(Names.FOO)));
        parameters = new HashMap();
        parameters.put(Names.FOO, "bar_value");
        rc.reset();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals((String)"", (String)rc.getPath());
        TestRequestParam.assertNull(rc.getQueryParams());
        a = router.route("/", Collections.singletonMap("a", new String[]{"bar_value"}));
        TestRequestParam.assertNull((Object)a);
    }

    public void testCanonical() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").canonical().optional().named("a")})}).build();
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(Names.FOO, "bar");
        URIHelper rc = new URIHelper();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals(Collections.singleton("a"), rc.getQueryParams().keySet());
        TestRequestParam.assertEquals(Collections.singletonList("bar"), Arrays.asList(rc.getQueryParams().get("a")));
        Map a = router.route("/", Collections.singletonMap("a", new String[]{"bar"}));
        TestRequestParam.assertNotNull((Object)a);
        TestRequestParam.assertEquals(Collections.singleton(Names.FOO), a.keySet());
        TestRequestParam.assertEquals((String)"bar", (String)((String)a.get(Names.FOO)));
        parameters = new HashMap();
        parameters.put(Names.FOO, "");
        rc.reset();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals(Collections.singleton("a"), rc.getQueryParams().keySet());
        TestRequestParam.assertEquals(Collections.singletonList(""), Arrays.asList(rc.getQueryParams().get("a")));
        a = router.route("/", Collections.singletonMap("a", new String[]{""}));
        TestRequestParam.assertNotNull((Object)a);
        TestRequestParam.assertEquals(Collections.singleton(Names.FOO), a.keySet());
        TestRequestParam.assertEquals((String)"", (String)((String)a.get(Names.FOO)));
        parameters = new HashMap();
        rc.reset();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals(null, rc.getQueryParams());
        a = router.route("/");
        TestRequestParam.assertNotNull((Object)a);
        TestRequestParam.assertEquals(Collections.emptySet(), a.keySet());
    }

    public void testNeverEmpty() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").neverEmpty().optional().named("a")})}).build();
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(Names.FOO, "bar");
        URIHelper rc = new URIHelper();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals(Collections.singleton("a"), rc.getQueryParams().keySet());
        TestRequestParam.assertEquals(Collections.singletonList("bar"), Arrays.asList(rc.getQueryParams().get("a")));
        Map a = router.route("/", Collections.singletonMap("a", new String[]{"bar"}));
        TestRequestParam.assertNotNull((Object)a);
        TestRequestParam.assertEquals(Collections.singleton(Names.FOO), a.keySet());
        TestRequestParam.assertEquals((String)"bar", (String)((String)a.get(Names.FOO)));
        parameters = new HashMap();
        parameters.put(Names.FOO, "");
        rc.reset();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals(null, rc.getQueryParams());
        a = router.route("/", Collections.singletonMap("a", new String[]{""}));
        TestRequestParam.assertNotNull((Object)a);
        TestRequestParam.assertEquals(Collections.emptySet(), a.keySet());
        parameters = new HashMap();
        rc.reset();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals(null, rc.getQueryParams());
        a = router.route("/");
        TestRequestParam.assertNotNull((Object)a);
        TestRequestParam.assertEquals(Collections.emptySet(), a.keySet());
    }

    public void testNeverNull() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"foo").neverNull().optional().named("a")})}).build();
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(Names.FOO, "bar");
        URIHelper rc = new URIHelper();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals(Collections.singleton("a"), rc.getQueryParams().keySet());
        TestRequestParam.assertEquals(Collections.singletonList("bar"), Arrays.asList(rc.getQueryParams().get("a")));
        Map a = router.route("/", Collections.singletonMap("a", new String[]{"bar"}));
        TestRequestParam.assertNotNull((Object)a);
        TestRequestParam.assertEquals(Collections.singleton(Names.FOO), a.keySet());
        TestRequestParam.assertEquals((String)"bar", (String)((String)a.get(Names.FOO)));
        parameters = new HashMap();
        parameters.put(Names.FOO, "");
        rc.reset();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals(Collections.singleton("a"), rc.getQueryParams().keySet());
        TestRequestParam.assertEquals(Collections.singletonList(""), Arrays.asList(rc.getQueryParams().get("a")));
        a = router.route("/", Collections.singletonMap("a", new String[]{""}));
        TestRequestParam.assertNotNull((Object)a);
        TestRequestParam.assertEquals(Collections.singleton(Names.FOO), a.keySet());
        TestRequestParam.assertEquals((String)"", (String)((String)a.get(Names.FOO)));
        parameters = new HashMap();
        rc.reset();
        router.render(parameters, rc.writer);
        TestRequestParam.assertEquals(Collections.singleton("a"), rc.getQueryParams().keySet());
        TestRequestParam.assertEquals(Collections.singletonList(""), Arrays.asList(rc.getQueryParams().get("a")));
        a = router.route("/");
        TestRequestParam.assertNotNull((Object)a);
        TestRequestParam.assertEquals(Collections.singleton(Names.FOO), a.keySet());
        TestRequestParam.assertEquals((String)"", (String)((String)a.get(Names.FOO)));
    }
}

